/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.MoveLineExportService;
import com.axelor.apps.account.service.ReimbursementExportService;
import com.axelor.apps.account.service.ReimbursementImportService;
import com.axelor.apps.account.service.ReimbursementService;
import com.axelor.apps.account.service.RejectImportService;
import com.axelor.apps.account.service.bankorder.file.cfonb.CfonbExportService;
import com.axelor.apps.account.service.bankorder.file.cfonb.CfonbImportService;
import com.axelor.apps.account.service.batch.BatchAccountCustomer;
import com.axelor.apps.account.service.debtrecovery.DebtRecoveryService;
import com.axelor.apps.account.service.debtrecovery.DoubtfulCustomerService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BatchRepository;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public abstract class BatchStrategy
extends AbstractBatch {
    protected DebtRecoveryService debtRecoveryService;
    protected DoubtfulCustomerService doubtfulCustomerService;
    protected ReimbursementExportService reimbursementExportService;
    protected ReimbursementImportService reimbursementImportService;
    protected RejectImportService rejectImportService;
    protected CfonbExportService cfonbExportService;
    protected CfonbImportService cfonbImportService;
    protected PaymentModeService paymentModeService;
    protected AccountCustomerService accountCustomerService;
    protected MoveLineExportService moveLineExportService;
    protected BatchAccountCustomer batchAccountCustomer;
    @Inject
    protected BatchRepository batchRepo;
    @Inject
    protected CompanyRepository companyRepo;
    @Inject
    protected MoveService moveService;
    @Inject
    protected MoveRepository moveRepo;
    @Inject
    protected MoveLineService moveLineService;
    @Inject
    protected MoveLineRepository moveLineRepo;
    @Inject
    protected ReimbursementService reimbursementService;

    protected BatchStrategy() {
    }

    protected BatchStrategy(DebtRecoveryService debtRecoveryService) {
        this.debtRecoveryService = debtRecoveryService;
    }

    protected BatchStrategy(DoubtfulCustomerService doubtfulCustomerService, BatchAccountCustomer batchAccountCustomer) {
        this.doubtfulCustomerService = doubtfulCustomerService;
        this.batchAccountCustomer = batchAccountCustomer;
    }

    protected BatchStrategy(ReimbursementExportService reimbursementExportService, CfonbExportService cfonbExportService, BatchAccountCustomer batchAccountCustomer) {
        this.reimbursementExportService = reimbursementExportService;
        this.cfonbExportService = cfonbExportService;
        this.batchAccountCustomer = batchAccountCustomer;
    }

    protected BatchStrategy(ReimbursementImportService reimbursementImportService, RejectImportService rejectImportService, BatchAccountCustomer batchAccountCustomer) {
        this.reimbursementImportService = reimbursementImportService;
        this.rejectImportService = rejectImportService;
        this.batchAccountCustomer = batchAccountCustomer;
    }

    protected BatchStrategy(AccountCustomerService accountCustomerService) {
        this.accountCustomerService = accountCustomerService;
    }

    protected BatchStrategy(MoveLineExportService moveLineExportService) {
        this.moveLineExportService = moveLineExportService;
    }

    protected void updateInvoice(Invoice invoice) {
        invoice.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updateReimbursement(Reimbursement reimbursement) {
        reimbursement.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updatePaymentScheduleLine(PaymentScheduleLine paymentScheduleLine) {
        paymentScheduleLine.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updatePaymentVoucher(PaymentVoucher paymentVoucher) {
        paymentVoucher.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updatePartner(Partner partner) {
        partner.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updateAccountingSituation(AccountingSituation accountingSituation) {
        accountingSituation.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updateAccountingReport(AccountingReport accountingReport) {
        accountingReport.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updateAccount(Account account) {
        account.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
        this.incrementDone();
    }

    protected void updateAccountMove(Move move, boolean incrementDone) {
        move.addBatchSetItem((Batch)((Object)((BatchRepository)((Object)Beans.get(BatchRepository.class))).find(this.batch.getId())));
        if (incrementDone) {
            this.incrementDone();
        } else {
            this.checkPoint();
        }
    }

    public void testAccountingBatchBankDetails(AccountingBatch accountingBatch) throws AxelorException {
        if (accountingBatch.getBankDetails() == null) {
            throw new AxelorException((Model)((Object)accountingBatch), 4, I18n.get((String)"%s : You must configure a RIB for batch's configurator %s"), new Object[]{I18n.get((String)"Warning !"), accountingBatch.getCode()});
        }
        this.cfonbExportService.testBankDetailsField(accountingBatch.getBankDetails());
    }
}

