/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.config;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.DebtRecoveryConfigLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.JournalType;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.message.db.Template;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.util.List;

public class AccountConfigService {
    public AccountConfig getAccountConfig(Company company) throws AxelorException {
        AccountConfig accountConfig = company.getAccountConfig();
        if (accountConfig == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure account's informations for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return accountConfig;
    }

    public void getReimbursementExportFolderPathCFONB(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getReimbursementExportFolderPathCFONB() == null || accountConfig.getReimbursementExportFolderPathCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB format reimbursement's export's folder for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
    }

    public void getPaymentScheduleExportFolderPathCFONB(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getPaymentScheduleExportFolderPathCFONB() == null || accountConfig.getPaymentScheduleExportFolderPathCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB format direct debit's export's folder for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
    }

    public void getRejectImportPathAndFileName(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getRejectImportPathAndFileName() == null || accountConfig.getRejectImportPathAndFileName().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a path for the reject's file for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
    }

    public void getTempImportPathAndFileName(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getTempImportPathAndFileName() == null || accountConfig.getTempImportPathAndFileName().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a path for the temporary reject's file for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
    }

    public void getReimbursementImportFolderPathCFONB(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getReimbursementImportFolderPathCFONB() == null || accountConfig.getReimbursementImportFolderPathCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a path for the reimbursements rejects import's file for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
    }

    public void getTempReimbImportFolderPathCFONB(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getTempReimbImportFolderPathCFONB() == null || accountConfig.getTempReimbImportFolderPathCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a path for the reimbursement rejects import's temporary file for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
    }

    public Journal getRejectJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getRejectJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a rejects journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getRejectJournal();
    }

    public Journal getIrrecoverableJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getIrrecoverableJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure an irrevocable journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getIrrecoverableJournal();
    }

    public Journal getSupplierPurchaseJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getSupplierPurchaseJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Supplier purchase journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getSupplierPurchaseJournal();
    }

    public Journal getSupplierCreditNoteJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getSupplierCreditNoteJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Supplier credit note journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getSupplierCreditNoteJournal();
    }

    public Journal getCustomerSalesJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCustomerSalesJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Sales journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCustomerSalesJournal();
    }

    public Journal getCustomerCreditNoteJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCustomerCreditNoteJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Customer credit note journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCustomerCreditNoteJournal();
    }

    public Journal getAutoMiscOpeJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getAutoMiscOpeJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Misc. Operation journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getAutoMiscOpeJournal();
    }

    public Journal getReimbursementJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getReimbursementJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Reimbursement journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getReimbursementJournal();
    }

    public Journal getReportedBalanceJournal(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getReportedBalanceJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a reported balance journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getReportedBalanceJournal();
    }

    public JournalType getSaleJournalType(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getSaleJournalType() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Sales journal type for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getSaleJournalType();
    }

    public JournalType getCreditNoteJournalType(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCreditNoteJournalType() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Credit note journal type for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCreditNoteJournalType();
    }

    public JournalType getCashJournalType(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCashJournalType() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Cash journal type for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCashJournalType();
    }

    public JournalType getPurchaseJournalType(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getPurchaseJournalType() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Purchase journal type for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getPurchaseJournalType();
    }

    public Account getIrrecoverableAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getIrrecoverableAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure an irrevocable doubtful account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getIrrecoverableAccount();
    }

    public Account getCustomerAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCustomerAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a customer account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCustomerAccount();
    }

    public Account getSupplierAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getSupplierAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a supplier account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getSupplierAccount();
    }

    public Account getEmployeeAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getEmployeeAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure an employee account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getEmployeeAccount();
    }

    public Account getAdvancePaymentAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getAdvancePaymentAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure an advance payment account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getAdvancePaymentAccount();
    }

    public Account getCashPositionVariationAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCashPositionVariationAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a cash difference account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCashPositionVariationAccount();
    }

    public Account getReimbursementAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getReimbursementAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a reimbursement account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getReimbursementAccount();
    }

    public Account getDoubtfulCustomerAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getDoubtfulCustomerAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a doubtful customer account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getDoubtfulCustomerAccount();
    }

    public Account getYearOpeningAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getYearOpeningAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a year opening account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getYearOpeningAccount();
    }

    public Account getYearClosureAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getYearClosureAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a year closure account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getYearClosureAccount();
    }

    public Tax getIrrecoverableStandardRateTax(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getIrrecoverableStandardRateTax() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a tax standard rate for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getIrrecoverableStandardRateTax();
    }

    public PaymentMode getDirectDebitPaymentMode(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getDirectDebitPaymentMode() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a direct debit payment mode for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getDirectDebitPaymentMode();
    }

    public PaymentMode getRejectionPaymentMode(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getRejectionPaymentMode() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a payment mode after reject for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getRejectionPaymentMode();
    }

    public String getIrrecoverableReasonPassage(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getIrrecoverableReasonPassage() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a shift to irrecoverable's reason for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getIrrecoverableReasonPassage();
    }

    public Template getRejectPaymentScheduleTemplate(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getRejectPaymentScheduleTemplate() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a reject import letter template for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getRejectPaymentScheduleTemplate();
    }

    public String getReimbursementExportFolderPath(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getReimbursementExportFolderPath() == null) {
            throw new AxelorException(4, "%s :\n " + I18n.get((String)"Export reimbursement folder (SEPA format) has not been configured for the company %s."), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getReimbursementExportFolderPath();
    }

    public String getSixMonthDebtPassReason(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getSixMonthDebtPassReason() == null || accountConfig.getSixMonthDebtPassReason().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a shifting reason (debt more than six months) for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getSixMonthDebtPassReason();
    }

    public String getThreeMonthDebtPassReason(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getThreeMonthDebtPassReason() == null || accountConfig.getThreeMonthDebtPassReason().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a shifting reason (debt more than three months) for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getThreeMonthDebtPassReason();
    }

    public List<DebtRecoveryConfigLine> getDebtRecoveryConfigLineList(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getDebtRecoveryConfigLineList() == null || accountConfig.getDebtRecoveryConfigLineList().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a debt recovery tab for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getDebtRecoveryConfigLineList();
    }

    public Sequence getCustInvSequence(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCustInvSequence() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Please, configure a sequence for the customer invoices and the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCustInvSequence();
    }

    public Sequence getCustRefSequence(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getCustRefSequence() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Please, configure a sequence for the customer refunds and the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getCustRefSequence();
    }

    public Sequence getSuppInvSequence(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getSuppInvSequence() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Please, configure a sequence for the supplier invoices and the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getSuppInvSequence();
    }

    public Sequence getSuppRefSequence(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getSuppRefSequence() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Please, configure a sequence for the supplier refunds and the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getSuppRefSequence();
    }

    public boolean getInvoiceInAti(AccountConfig accountConfig) throws AxelorException {
        int atiChoice = accountConfig.getInvoiceInAtiSelect();
        return atiChoice == 4 || atiChoice == 2;
    }

    public String getExportFileName(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getExportFileName() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a file name for the export of move file for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getExportFileName();
    }

    public Account getFactorCreditAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getFactorCreditAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a factor credit account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getFactorCreditAccount();
    }

    public Account getFactorDebitAccount(AccountConfig accountConfig) throws AxelorException {
        if (accountConfig.getFactorDebitAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a factor debit account for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return accountConfig.getFactorDebitAccount();
    }
}

