/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.config;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.CfonbConfig;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.base.db.Company;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;

public class CfonbConfigService
extends AccountConfigService {
    public CfonbConfig getCfonbConfig(AccountConfig accountConfig) throws AxelorException {
        CfonbConfig cfonbConfig = accountConfig.getCfonbConfig();
        if (cfonbConfig == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure CFONB for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountConfig.getCompany().getName()});
        }
        return cfonbConfig;
    }

    public CfonbConfig getCfonbConfig(Company company) throws AxelorException {
        AccountConfig accountConfig = super.getAccountConfig(company);
        return this.getCfonbConfig(accountConfig);
    }

    public String getSenderRecordCodeExportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        String senderRecordCodeExportCFONB = cfonbConfig.getSenderRecordCodeExportCFONB();
        if (senderRecordCodeExportCFONB == null || senderRecordCodeExportCFONB.isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB sender code register for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
        return senderRecordCodeExportCFONB;
    }

    public void getSenderNumExportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getSenderNumExportCFONB() == null || cfonbConfig.getSenderNumExportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB sender's number for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getSenderNameCodeExportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getSenderNameCodeExportCFONB() == null || cfonbConfig.getSenderNameCodeExportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB sender's name/corporate name for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getRecipientRecordCodeExportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getRecipientRecordCodeExportCFONB() == null || cfonbConfig.getRecipientRecordCodeExportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB receiver code register for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getTotalRecordCodeExportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getTotalRecordCodeExportCFONB() == null || cfonbConfig.getTotalRecordCodeExportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB total code register for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getTransferOperationCodeExportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getTransferOperationCodeExportCFONB() == null || cfonbConfig.getTransferOperationCodeExportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB internet payment code for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getDirectDebitOperationCodeExportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getDirectDebitOperationCodeExportCFONB() == null || cfonbConfig.getDirectDebitOperationCodeExportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB direct debit code for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getHeaderRecordCodeImportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getHeaderRecordCodeImportCFONB() == null || cfonbConfig.getHeaderRecordCodeImportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB header code register for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getDetailRecordCodeImportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getDetailRecordCodeImportCFONB() == null || cfonbConfig.getDetailRecordCodeImportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB detail code register for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getEndingRecordCodeImportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getEndingRecordCodeImportCFONB() == null || cfonbConfig.getEndingRecordCodeImportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB code register end for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getTransferOperationCodeImportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getTransferOperationCodeImportCFONB() == null || cfonbConfig.getTransferOperationCodeImportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB rejected direct debit code for the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }

    public void getDirectDebitOperationCodeImportCFONB(CfonbConfig cfonbConfig) throws AxelorException {
        if (cfonbConfig.getDirectDebitOperationCodeImportCFONB() == null || cfonbConfig.getDirectDebitOperationCodeImportCFONB().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a CFONB unpaid direct debit code fir the company %s"), new Object[]{I18n.get((String)"Warning !"), cfonbConfig.getName()});
        }
    }
}

