/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.debtrecovery;

import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.DebtRecoveryHistory;
import com.axelor.apps.account.db.DebtRecoveryMethodLine;
import com.axelor.apps.account.db.repo.DebtRecoveryHistoryRepository;
import com.axelor.apps.account.db.repo.DebtRecoveryRepository;
import com.axelor.apps.account.service.TemplateMessageAccountService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebtRecoveryActionService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected UserService userService;
    protected DebtRecoveryRepository debtRecoveryRepo;
    protected DebtRecoveryHistoryRepository debtRecoveryHistoryRepository;
    protected TemplateMessageAccountService templateMessageAccountService;
    protected AppAccountService appAccountService;

    @Inject
    public DebtRecoveryActionService(UserService userService, DebtRecoveryRepository debtRecoveryRepo, DebtRecoveryHistoryRepository debtRecoveryHistoryRepository, TemplateMessageAccountService templateMessageAccountService, AppAccountService appAccountService) {
        this.userService = userService;
        this.debtRecoveryRepo = debtRecoveryRepo;
        this.debtRecoveryHistoryRepository = debtRecoveryHistoryRepository;
        this.templateMessageAccountService = templateMessageAccountService;
        this.appAccountService = appAccountService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void runAction(DebtRecovery debtRecovery) throws AxelorException {
        DebtRecoveryMethodLine debtRecoveryMethodLine = debtRecovery.getDebtRecoveryMethodLine();
        Partner partner = debtRecovery.getAccountingSituation().getPartner();
        if (debtRecovery.getDebtRecoveryMethod() == null) {
            throw new AxelorException((Model)((Object)debtRecovery), 1, "%s :\n" + I18n.get((String)"Partner") + " %s: " + I18n.get((String)"Debt recovery method missing."), new Object[]{I18n.get((String)"Warning !"), partner.getName()});
        }
        if (debtRecoveryMethodLine == null) {
            throw new AxelorException((Model)((Object)debtRecovery), 1, "%s :\n" + I18n.get((String)"Partner") + " %s: " + I18n.get((String)"Debt recovery line missing."), new Object[]{I18n.get((String)"Warning !"), partner.getName()});
        }
        if (CollectionUtils.isEmpty(debtRecoveryMethodLine.getMessageTemplateSet())) {
            throw new AxelorException(4, I18n.get((String)"%s : Letter template missing for debt recovery matrix %s (Partner %s, Level %s)."), new Object[]{I18n.get((String)"Warning !"), partner.getName(), debtRecoveryMethodLine.getDebtRecoveryMethod().getName(), debtRecoveryMethodLine.getDebtRecoveryLevel().getName()});
        }
        debtRecovery.setDebtRecoveryDate(this.appAccountService.getTodayDate());
        this.saveDebtRecovery(debtRecovery);
    }

    public Set<Message> runStandardMessage(DebtRecovery debtRecovery) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        HashSet<Message> messages = new HashSet<Message>();
        DebtRecoveryMethodLine debtRecoveryMethodLine = debtRecovery.getDebtRecoveryMethodLine();
        Set<Template> templateSet = debtRecoveryMethodLine.getMessageTemplateSet();
        DebtRecoveryHistory debtRecoveryHistory = this.getDebtRecoveryHistory(debtRecovery);
        for (Template template : templateSet) {
            messages.add(this.templateMessageAccountService.generateMessage(debtRecoveryHistory, template));
        }
        return messages;
    }

    public DebtRecoveryHistory getDebtRecoveryHistory(DebtRecovery detDebtRecovery) {
        if (detDebtRecovery.getDebtRecoveryHistoryList() == null || detDebtRecovery.getDebtRecoveryHistoryList().isEmpty()) {
            return null;
        }
        return Collections.max(detDebtRecovery.getDebtRecoveryHistoryList(), Comparator.comparing(DebtRecoveryHistory::getDebtRecoveryDate));
    }

    @Transactional(rollbackOn={Exception.class})
    public void runManualAction(DebtRecovery debtRecovery) throws AxelorException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        this.log.debug("Begin runManualAction service ...");
        DebtRecoveryMethodLine debtRecoveryMethodLine = debtRecovery.getWaitDebtRecoveryMethodLine();
        Partner partner = debtRecovery.getAccountingSituation().getPartner();
        if (debtRecovery.getDebtRecoveryMethod() == null) {
            throw new AxelorException(1, "%s :\n" + I18n.get((String)"Partner") + " %s: " + I18n.get((String)"Debt recovery method missing."), new Object[]{I18n.get((String)"Warning !"), partner.getName()});
        }
        if (debtRecoveryMethodLine == null) {
            throw new AxelorException(1, "%s :\n" + I18n.get((String)"Partner") + " %s: " + I18n.get((String)"Debt recovery line missing."), new Object[]{I18n.get((String)"Warning !"), partner.getName()});
        }
        if (CollectionUtils.isEmpty(debtRecoveryMethodLine.getMessageTemplateSet())) {
            throw new AxelorException(4, I18n.get((String)"%s : Letter template missing for debt recovery matrix %s (Partner %s, Level %s)."), new Object[]{I18n.get((String)"Warning !"), partner.getName(), debtRecoveryMethodLine.getDebtRecoveryMethod().getName(), debtRecoveryMethodLine.getDebtRecoveryLevel().getName()});
        }
        debtRecovery.setDebtRecoveryDate(this.appAccountService.getTodayDate());
        this.debtRecoveryLevelValidate(debtRecovery);
        this.saveDebtRecovery(debtRecovery);
        this.runMessage(debtRecovery);
        this.log.debug("End runManualAction service");
    }

    @Transactional(rollbackOn={Exception.class})
    public void runMessage(DebtRecovery debtRecovery) throws AxelorException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        Set<Message> messageSet = this.runStandardMessage(debtRecovery);
        for (Message message : messageSet) {
            message = (Message)((Object)((MessageRepository)((Object)Beans.get(MessageRepository.class))).save((Model)((Object)message)));
            message = ((MessageService)Beans.get(MessageService.class)).sendMessage(message);
            if (debtRecovery.getDebtRecoveryMethodLine().getManualValidationOk().booleanValue() || message.getMailAccount() != null) continue;
            throw new AxelorException(5, I18n.get((String)"Email is not sent. Please check email account configuration."));
        }
    }

    @Transactional
    public void moveDebtRecoveryMethodLine(DebtRecovery debtRecovery, DebtRecoveryMethodLine debtRecoveryMethodLine) {
        debtRecovery.setWaitDebtRecoveryMethodLine(debtRecoveryMethodLine);
        this.debtRecoveryRepo.save((Model)((Object)debtRecovery));
    }

    public DebtRecovery debtRecoveryLevelValidate(DebtRecovery debtRecovery) throws AxelorException {
        this.log.debug("Begin debtRecoveryLevelValidate service ...");
        debtRecovery.setDebtRecoveryMethodLine(debtRecovery.getWaitDebtRecoveryMethodLine());
        debtRecovery.setWaitDebtRecoveryMethodLine(null);
        this.log.debug("End debtRecoveryLevelValidate service");
        return debtRecovery;
    }

    @Transactional
    public void saveDebtRecovery(DebtRecovery debtRecovery) {
        DebtRecoveryHistory debtRecoveryHistory = new DebtRecoveryHistory();
        debtRecoveryHistory.setDebtRecovery(debtRecovery);
        debtRecoveryHistory.setBalanceDue(debtRecovery.getBalanceDue());
        debtRecoveryHistory.setBalanceDueDebtRecovery(debtRecovery.getBalanceDueDebtRecovery());
        debtRecoveryHistory.setDebtRecoveryDate(debtRecovery.getDebtRecoveryDate());
        debtRecoveryHistory.setDebtRecoveryMethodLine(debtRecovery.getDebtRecoveryMethodLine());
        debtRecoveryHistory.setSetToIrrecoverableOK(debtRecovery.getSetToIrrecoverableOk());
        debtRecoveryHistory.setUnknownAddressOK(debtRecovery.getUnknownAddressOk());
        debtRecoveryHistory.setReferenceDate(debtRecovery.getReferenceDate());
        debtRecoveryHistory.setDebtRecoveryMethod(debtRecovery.getDebtRecoveryMethod());
        debtRecoveryHistory.setUserDebtRecovery(this.userService.getUser());
        debtRecovery.addDebtRecoveryHistoryListItem(debtRecoveryHistory);
        this.debtRecoveryHistoryRepository.save((Model)((Object)debtRecoveryHistory));
    }
}

