/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.debtrecovery;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.DebtRecoveryHistory;
import com.axelor.apps.account.db.DebtRecoveryMethod;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.repo.AccountingSituationRepository;
import com.axelor.apps.account.db.repo.DebtRecoveryRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.debtrecovery.DebtRecoveryActionService;
import com.axelor.apps.account.service.debtrecovery.DebtRecoverySessionService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebtRecoveryService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected DebtRecoverySessionService debtRecoverySessionService;
    protected DebtRecoveryActionService debtRecoveryActionService;
    protected AccountCustomerService accountCustomerService;
    protected MoveLineRepository moveLineRepo;
    protected PaymentScheduleLineRepository paymentScheduleLineRepo;
    protected AccountConfigService accountConfigService;
    protected DebtRecoveryRepository debtRecoveryRepo;
    protected AppAccountService appAccountService;
    protected MessageRepository messageRepo;

    @Inject
    public DebtRecoveryService(DebtRecoverySessionService debtRecoverySessionService, DebtRecoveryActionService debtRecoveryActionService, AccountCustomerService accountCustomerService, MoveLineRepository moveLineRepo, PaymentScheduleLineRepository paymentScheduleLineRepo, AccountConfigService accountConfigService, DebtRecoveryRepository debtRecoveryRepo, AppAccountService appAccountService, MessageRepository messageRepo) {
        this.debtRecoverySessionService = debtRecoverySessionService;
        this.debtRecoveryActionService = debtRecoveryActionService;
        this.accountCustomerService = accountCustomerService;
        this.moveLineRepo = moveLineRepo;
        this.paymentScheduleLineRepo = paymentScheduleLineRepo;
        this.accountConfigService = accountConfigService;
        this.debtRecoveryRepo = debtRecoveryRepo;
        this.appAccountService = appAccountService;
        this.messageRepo = messageRepo;
    }

    public void testCompanyField(Company company) throws AxelorException {
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        this.accountConfigService.getDebtRecoveryConfigLineList(accountConfig);
    }

    public BigDecimal getBalanceDueDebtRecovery(List<MoveLine> moveLineList, Partner partner) {
        BigDecimal balanceSubstract = this.getSubstractBalanceDue(partner);
        BigDecimal balanceDueDebtRecovery = BigDecimal.ZERO;
        for (MoveLine moveLine : moveLineList) {
            balanceDueDebtRecovery = balanceDueDebtRecovery.add(moveLine.getAmountRemaining());
        }
        balanceDueDebtRecovery = balanceDueDebtRecovery.add(balanceSubstract);
        return balanceDueDebtRecovery;
    }

    public BigDecimal getSubstractBalanceDue(Partner partner) {
        List moveLineQuery = this.moveLineRepo.all().filter("self.partner = ?1", new Object[]{partner}).fetch();
        BigDecimal balance = BigDecimal.ZERO;
        for (MoveLine moveLine : moveLineQuery) {
            if (moveLine.getCredit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getAccount() == null || !moveLine.getAccount().getUseForPartnerBalance().booleanValue()) continue;
            balance = balance.subtract(moveLine.getAmountRemaining());
        }
        return balance;
    }

    public LocalDate getOldDateMoveLine(List<MoveLine> moveLineList) {
        LocalDate minMoveLineDate = LocalDate.now();
        if (moveLineList != null && !moveLineList.isEmpty()) {
            for (MoveLine moveLine : moveLineList) {
                if (!minMoveLineDate.isAfter(moveLine.getDueDate())) continue;
                minMoveLineDate = moveLine.getDueDate();
            }
        } else {
            minMoveLineDate = null;
        }
        return minMoveLineDate;
    }

    public LocalDate getLastDate(LocalDate date1, LocalDate date2) {
        LocalDate minDate = LocalDate.now();
        minDate = date1 != null && date2 != null ? (date1.isAfter(date2) ? date1 : date2) : (date1 != null ? date1 : (date2 != null ? date2 : null));
        return minDate;
    }

    public LocalDate getLastDateDebtRecovery(DebtRecovery debtRecovery) {
        return debtRecovery.getDebtRecoveryDate();
    }

    public LocalDate getReferenceDate(DebtRecovery debtRecovery) {
        AccountingSituation accountingSituation = debtRecovery.getAccountingSituation();
        List<MoveLine> moveLineList = this.getMoveLineDebtRecovery(accountingSituation.getPartner(), accountingSituation.getCompany());
        LocalDate minMoveLineDate = this.getOldDateMoveLine(moveLineList);
        this.log.debug("minMoveLineDate : {}", (Object)minMoveLineDate);
        LocalDate debtRecoveryLastDate = this.getLastDateDebtRecovery(debtRecovery);
        this.log.debug("debtRecoveryLastDate : {}", (Object)debtRecoveryLastDate);
        LocalDate debtRecoveryRefDate = this.getLastDate(minMoveLineDate, debtRecoveryLastDate);
        this.log.debug("debtRecoveryRefDate : {}", (Object)debtRecoveryRefDate);
        return debtRecoveryRefDate;
    }

    public List<MoveLine> getMoveLineDebtRecovery(Partner partner, Company company) {
        ArrayList<MoveLine> moveLineList = new ArrayList<MoveLine>();
        List<? extends MoveLine> moveLineQuery = this.getMoveLine(partner, company);
        int mailTransitTime = company.getAccountConfig().getMailTransitTime();
        for (MoveLine moveLine : moveLineQuery) {
            if (moveLine.getMove() == null || moveLine.getMove().getIgnoreInDebtRecoveryOk().booleanValue()) continue;
            Move move = moveLine.getMove();
            if (move.getStatusSelect() != 4 && move.getInvoice() != null && !move.getInvoice().getDebtRecoveryBlockingOk().booleanValue() && !move.getInvoice().getSchedulePaymentOk().booleanValue() && move.getInvoice().getInvoiceDate().plusDays(mailTransitTime).isBefore(this.appAccountService.getTodayDate())) {
                if (moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getDueDate() == null || !this.appAccountService.getTodayDate().isAfter(moveLine.getDueDate()) && !this.appAccountService.getTodayDate().isEqual(moveLine.getDueDate()) || moveLine.getAccount() == null || !moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
                moveLineList.add(moveLine);
                continue;
            }
            if (move.getInvoice() != null || moveLine.getPaymentScheduleLine() == null || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getDueDate() == null || !this.appAccountService.getTodayDate().isAfter(moveLine.getDueDate()) && !this.appAccountService.getTodayDate().isEqual(moveLine.getDueDate()) || moveLine.getAccount() == null || !moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            moveLineList.add(moveLine);
        }
        return moveLineList;
    }

    public List<Invoice> getInvoiceList(List<MoveLine> moveLineList) {
        ArrayList<Invoice> invoiceList = new ArrayList<Invoice>();
        for (MoveLine moveLine : moveLineList) {
            if (moveLine.getMove().getInvoice() == null || moveLine.getMove().getInvoice().getDebtRecoveryBlockingOk().booleanValue()) continue;
            invoiceList.add(moveLine.getMove().getInvoice());
        }
        return invoiceList;
    }

    public List<PaymentScheduleLine> getPaymentScheduleList(List<MoveLine> moveLineList, Partner partner) {
        ArrayList<PaymentScheduleLine> paymentScheduleLineList = new ArrayList<PaymentScheduleLine>();
        for (MoveLine moveLine : moveLineList) {
            PaymentScheduleLine paymentScheduleLine;
            if (moveLine.getMove().getInvoice() != null || (paymentScheduleLine = this.getPaymentScheduleFromMoveLine(partner, moveLine)) == null || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            paymentScheduleLineList.add(paymentScheduleLine);
        }
        return paymentScheduleLineList;
    }

    public List<? extends MoveLine> getMoveLine(Partner partner, Company company) {
        return this.moveLineRepo.all().filter("self.partner = ?1 and self.move.company = ?2", new Object[]{partner, company}).fetch();
    }

    public PaymentScheduleLine getPaymentScheduleFromMoveLine(Partner partner, MoveLine moveLine) {
        return (PaymentScheduleLine)((Object)this.paymentScheduleLineRepo.all().filter("self.rejectMoveLine = ?1", new Object[]{moveLine}).fetchOne());
    }

    public boolean periodOk(int dayBegin, int dayEnd, int monthBegin, int monthEnd) {
        return DateTool.dateInPeriod((LocalDate)this.appAccountService.getTodayDate(), (int)dayBegin, (int)monthBegin, (int)dayEnd, (int)monthEnd);
    }

    public DebtRecovery getDebtRecovery(Partner partner, Company company) throws AxelorException {
        AccountingSituationRepository accSituationRepo = (AccountingSituationRepository)((Object)Beans.get(AccountingSituationRepository.class));
        AccountingSituation accountingSituation = (AccountingSituation)((Object)accSituationRepo.all().filter("self.partner = ?1 and self.company = ?2", new Object[]{partner, company}).fetchOne());
        if (accountingSituation == null) {
            throw new AxelorException((Model)((Object)accountingSituation), 4, "%s :\n" + I18n.get((String)"Partner") + " %s, " + I18n.get((String)"Company") + " %s : " + I18n.get((String)"There's no accounting situation."), new Object[]{I18n.get((String)"Warning !"), partner.getName(), company.getName()});
        }
        return accountingSituation.getDebtRecovery();
    }

    @Transactional(rollbackOn={Exception.class})
    public DebtRecovery createDebtRecovery(AccountingSituation accountingSituation) {
        DebtRecovery debtRecovery = new DebtRecovery();
        debtRecovery.setAccountingSituation(accountingSituation);
        accountingSituation.setDebtRecovery(debtRecovery);
        this.debtRecoveryRepo.save((Model)((Object)debtRecovery));
        return debtRecovery;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackOn={Exception.class})
    public boolean debtRecoveryGenerate(Partner partner, Company company) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        boolean remindedOk = false;
        DebtRecovery debtRecovery = this.getDebtRecovery(partner, company);
        BigDecimal balanceDue = this.accountCustomerService.getBalanceDue(partner, company);
        if (balanceDue.compareTo(BigDecimal.ZERO) > 0) {
            this.log.debug("balanceDue : {} ", (Object)balanceDue);
            BigDecimal balanceDueDebtRecovery = this.accountCustomerService.getBalanceDueDebtRecovery(partner, company);
            if (balanceDueDebtRecovery.compareTo(BigDecimal.ZERO) > 0) {
                LocalDate referenceDate;
                this.log.debug("balanceDueDebtRecovery : {} ", (Object)balanceDueDebtRecovery);
                remindedOk = true;
                if (debtRecovery == null) {
                    AccountingSituationRepository accSituationRepo = (AccountingSituationRepository)((Object)Beans.get(AccountingSituationRepository.class));
                    AccountingSituation accountingSituation = (AccountingSituation)((Object)accSituationRepo.all().filter("self.partner = ?1 and self.company = ?2", new Object[]{partner, company}).fetchOne());
                    debtRecovery = this.createDebtRecovery(accountingSituation);
                }
                debtRecovery.setCompany((Company)((Object)((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).find(company.getId())));
                debtRecovery.setCurrency(partner.getCurrency());
                debtRecovery.setBalanceDue(balanceDue);
                List<MoveLine> moveLineList = this.getMoveLineDebtRecovery(partner, company);
                this.updateInvoiceDebtRecovery(debtRecovery, this.getInvoiceList(moveLineList));
                this.updatePaymentScheduleLineDebtRecovery(debtRecovery, this.getPaymentScheduleList(moveLineList, partner));
                debtRecovery.setBalanceDueDebtRecovery(balanceDueDebtRecovery);
                Integer levelDebtRecovery = 0;
                if (debtRecovery.getDebtRecoveryMethodLine() != null) {
                    levelDebtRecovery = debtRecovery.getDebtRecoveryMethodLine().getDebtRecoveryLevel().getName();
                }
                if ((referenceDate = this.getReferenceDate(debtRecovery)) == null) {
                    throw new AxelorException((Model)((Object)debtRecovery), 4, "%s :\n" + I18n.get((String)"Partner") + " %s, " + I18n.get((String)"Company") + " %s : " + I18n.get((String)"Reference date undefined."), new Object[]{I18n.get((String)"Warning !"), partner.getName(), company.getName()});
                }
                this.log.debug("date de r\u00e9f\u00e9rence : {} ", (Object)referenceDate);
                debtRecovery.setReferenceDate(referenceDate);
                if (debtRecovery.getDebtRecoveryMethod() == null) {
                    DebtRecoveryMethod debtRecoveryMethod = this.debtRecoverySessionService.getDebtRecoveryMethod(debtRecovery);
                    if (debtRecoveryMethod == null) throw new AxelorException((Model)((Object)debtRecovery), 4, "%s :\n" + I18n.get((String)"Partner") + " %s, " + I18n.get((String)"Company") + " %s : " + I18n.get((String)"Debt recovery method missing for the configuration."), new Object[]{I18n.get((String)"Warning !"), partner.getName(), company.getName()});
                    debtRecovery.setDebtRecoveryMethod(debtRecoveryMethod);
                    this.debtRecoverySessionService.debtRecoverySession(debtRecovery);
                } else {
                    this.debtRecoverySessionService.debtRecoverySession(debtRecovery);
                }
                if (debtRecovery.getWaitDebtRecoveryMethodLine() == null) {
                    if (debtRecovery.getDebtRecoveryMethodLine() == null || debtRecovery.getDebtRecoveryMethodLine().getDebtRecoveryLevel() == null || debtRecovery.getDebtRecoveryMethodLine().getDebtRecoveryLevel().getName() <= levelDebtRecovery) return remindedOk;
                    this.debtRecoveryActionService.runAction(debtRecovery);
                    DebtRecoveryHistory debtRecoveryHistory = this.debtRecoveryActionService.getDebtRecoveryHistory(debtRecovery);
                    if (!CollectionUtils.isEmpty((Collection)this.messageRepo.findByRelatedTo(Math.toIntExact(debtRecoveryHistory.getId()), DebtRecoveryHistory.class.getCanonicalName()).fetch())) return remindedOk;
                    this.debtRecoveryActionService.runMessage(debtRecovery);
                    return remindedOk;
                } else {
                    this.log.debug("Tiers {}, Soci\u00e9t\u00e9 {} - Niveau de relance en attente ", (Object)partner.getName(), (Object)company.getName());
                    TraceBackService.trace((AxelorException)new AxelorException((Model)((Object)debtRecovery), 5, "%s :\n" + I18n.get((String)"Partner") + " %s, " + I18n.get((String)"Company") + " %s : " + I18n.get((String)"Debt recovery level waiting for approval."), new Object[]{I18n.get((String)"Warning !"), partner.getName(), company.getName()}));
                }
                return remindedOk;
            } else {
                this.debtRecoverySessionService.debtRecoveryInitialization(debtRecovery);
            }
            return remindedOk;
        } else {
            this.debtRecoverySessionService.debtRecoveryInitialization(debtRecovery);
        }
        return remindedOk;
    }

    public void updateInvoiceDebtRecovery(DebtRecovery debtRecovery, List<Invoice> invoiceList) {
        debtRecovery.setInvoiceDebtRecoverySet(new HashSet<Invoice>());
        debtRecovery.getInvoiceDebtRecoverySet().addAll(invoiceList);
    }

    public void updatePaymentScheduleLineDebtRecovery(DebtRecovery debtRecovery, List<PaymentScheduleLine> paymentSchedueLineList) {
        debtRecovery.setPaymentScheduleLineDebtRecoverySet(new HashSet<PaymentScheduleLine>());
        debtRecovery.getPaymentScheduleLineDebtRecoverySet().addAll(paymentSchedueLineList);
    }
}

