/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.debtrecovery;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.DebtRecoveryHistory;
import com.axelor.apps.account.db.DebtRecoveryLevel;
import com.axelor.apps.account.db.DebtRecoveryMethodLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayerQualityConfigLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayerQualityService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppAccountService appAccountService;
    protected PartnerRepository partnerRepository;

    @Inject
    public PayerQualityService(AppAccountService appAccountService, PartnerRepository partnerRepository) {
        this.appAccountService = appAccountService;
        this.partnerRepository = partnerRepository;
    }

    public List<DebtRecoveryHistory> getDebtRecoveryHistoryList(Partner partner) {
        ArrayList<DebtRecoveryHistory> debtRecoveryHistoryList = new ArrayList<DebtRecoveryHistory>();
        if (partner.getAccountingSituationList() != null) {
            for (AccountingSituation accountingSituation : partner.getAccountingSituationList()) {
                DebtRecovery debtRecovery = accountingSituation.getDebtRecovery();
                if (debtRecovery == null || debtRecovery.getDebtRecoveryHistoryList() == null || debtRecovery.getDebtRecoveryHistoryList().isEmpty()) continue;
                for (DebtRecoveryHistory debtRecoveryHistory : debtRecovery.getDebtRecoveryHistoryList()) {
                    if (debtRecoveryHistory.getDebtRecoveryDate() == null || !debtRecoveryHistory.getDebtRecoveryDate().isAfter(this.appAccountService.getTodayDate().minusYears(1L))) continue;
                    debtRecoveryHistoryList.add(debtRecoveryHistory);
                }
            }
        }
        return debtRecoveryHistoryList;
    }

    public List<MoveLine> getMoveLineRejectList(Partner partner) {
        MoveLineRepository moveLineRepo = (MoveLineRepository)((Object)Beans.get(MoveLineRepository.class));
        return moveLineRepo.all().filter("self.partner = ?1 AND self.date > ?2 AND self.interbankCodeLine IS NOT NULL", new Object[]{partner, this.appAccountService.getTodayDate().minusYears(1L)}).fetch();
    }

    public BigDecimal getPayerQualityNote(Partner partner, List<PayerQualityConfigLine> payerQualityConfigLineList) {
        BigDecimal burden = BigDecimal.ZERO;
        List<DebtRecoveryHistory> debtRecoveryHistoryList = this.getDebtRecoveryHistoryList(partner);
        List<MoveLine> moveLineList = this.getMoveLineRejectList(partner);
        this.log.debug("Tiers {} : Nombre de relance concern\u00e9e : {}", (Object)partner.getName(), (Object)debtRecoveryHistoryList.size());
        this.log.debug("Tiers {} : Nombre de rejets concern\u00e9e : {}", (Object)partner.getName(), (Object)moveLineList.size());
        for (DebtRecoveryHistory debtRecoveryHistory : debtRecoveryHistoryList) {
            burden = burden.add(this.getPayerQualityNote(debtRecoveryHistory, payerQualityConfigLineList));
        }
        for (MoveLine moveLine : moveLineList) {
            burden = burden.add(this.getPayerQualityNote(moveLine, payerQualityConfigLineList));
        }
        this.log.debug("Tiers {} : Qualit\u00e9 payeur : {}", (Object)partner.getName(), (Object)burden);
        return burden;
    }

    public BigDecimal getPayerQualityNote(DebtRecoveryHistory debtRecoveryHistory, List<PayerQualityConfigLine> payerQualityConfigLineList) {
        DebtRecoveryLevel debtRecoveryLevel = this.getDebtRecoveryLevel(debtRecoveryHistory);
        if (debtRecoveryLevel != null) {
            for (PayerQualityConfigLine payerQualityConfigLine : payerQualityConfigLineList) {
                if (payerQualityConfigLine.getIncidentTypeSelect() != 0 || !payerQualityConfigLine.getDebtRecoveryLevel().equals((Object)debtRecoveryLevel)) continue;
                return payerQualityConfigLine.getBurden();
            }
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getPayerQualityNote(MoveLine moveLine, List<PayerQualityConfigLine> payerQualityConfigLineList) {
        for (PayerQualityConfigLine payerQualityConfigLine : payerQualityConfigLineList) {
            if (payerQualityConfigLine.getIncidentTypeSelect() != 1 || moveLine.getInterbankCodeLine().getTechnicalRejectOk().booleanValue()) continue;
            return payerQualityConfigLine.getBurden();
        }
        return BigDecimal.ZERO;
    }

    public DebtRecoveryLevel getDebtRecoveryLevel(DebtRecoveryHistory debtRecoveryHistory) {
        DebtRecoveryMethodLine debtRecoveryMethodLine = null;
        if (debtRecoveryHistory.getDebtRecoveryDate() != null) {
            debtRecoveryMethodLine = debtRecoveryHistory.getDebtRecoveryMethodLine();
        }
        if (debtRecoveryMethodLine != null) {
            return debtRecoveryMethodLine.getDebtRecoveryLevel();
        }
        return null;
    }

    public List<Partner> getPartnerList() {
        return this.partnerRepository.all().filter("self.isCustomer = true").fetch();
    }

    @Transactional(rollbackOn={Exception.class})
    public void payerQualityProcess() throws AxelorException {
        List<PayerQualityConfigLine> payerQualityConfigLineList = this.appAccountService.getAppAccount().getPayerQualityConfigLineList();
        if (payerQualityConfigLineList == null || payerQualityConfigLineList.size() == 0) {
            throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure a weight table in general configuration"), new Object[]{I18n.get((String)"Warning !")});
        }
        List<Partner> partnerList = this.getPartnerList();
        if (partnerList != null && partnerList.size() != 0) {
            for (Partner partner : partnerList) {
                BigDecimal burden = this.getPayerQualityNote(partner, payerQualityConfigLineList);
                if (burden.compareTo(BigDecimal.ZERO) != 1) continue;
                partner.setPayerQuality(burden);
                this.partnerRepository.save((Model)((Object)partner));
                this.log.debug("Tiers payeur {} : Qualit\u00e9 payeur : {}", (Object)partner.getName(), (Object)burden);
            }
        }
    }
}

