/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Alarm;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public interface InvoiceService {
    public Map<Invoice, List<Alarm>> getAlarms(Invoice ... var1);

    public Account getPartnerAccount(Invoice var1) throws AxelorException;

    public Journal getJournal(Invoice var1) throws AxelorException;

    public void raisingAlarms(Invoice var1, String var2);

    public Invoice compute(Invoice var1) throws AxelorException;

    public void validate(Invoice var1) throws AxelorException;

    public void ventilate(Invoice var1) throws AxelorException;

    public void validateAndVentilate(Invoice var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void cancel(Invoice var1) throws AxelorException;

    @Transactional
    public void usherProcess(Invoice var1);

    public String checkNotImputedRefunds(Invoice var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Invoice createRefund(Invoice var1) throws AxelorException;

    public void setDraftSequence(Invoice var1) throws AxelorException;

    public Invoice mergeInvoiceProcess(List<Invoice> var1, Company var2, Currency var3, Partner var4, Partner var5, PriceList var6, PaymentMode var7, PaymentCondition var8) throws AxelorException;

    public Invoice mergeInvoice(List<Invoice> var1, Company var2, Currency var3, Partner var4, Partner var5, PriceList var6, PaymentMode var7, PaymentCondition var8) throws AxelorException;

    public List<InvoiceLine> getInvoiceLinesFromInvoiceList(List<Invoice> var1);

    public void setInvoiceForInvoiceLines(List<InvoiceLine> var1, Invoice var2);

    public void deleteOldInvoices(List<Invoice> var1);

    public Invoice getInvoice(MoveLine var1);

    public String createAdvancePaymentInvoiceSetDomain(Invoice var1) throws AxelorException;

    public Set<Invoice> getDefaultAdvancePaymentInvoice(Invoice var1) throws AxelorException;

    public List<MoveLine> getMoveLinesFromAdvancePayments(Invoice var1) throws AxelorException;

    public List<MoveLine> getMoveLinesFromInvoiceAdvancePayments(Invoice var1);

    public List<MoveLine> getMoveLinesFromSOAdvancePayments(Invoice var1);

    public void filterAdvancePaymentInvoice(Invoice var1, Set<Invoice> var2) throws AxelorException;

    public BankDetails getBankDetails(Invoice var1) throws AxelorException;

    public int getPurchaseTypeOrSaleType(Invoice var1);

    public Pair<Integer, Integer> massValidate(Collection<? extends Number> var1);

    public Pair<Integer, Integer> massValidateAndVentilate(Collection<? extends Number> var1);

    public Pair<Integer, Integer> massVentilate(Collection<? extends Number> var1);

    public Boolean checkPartnerBankDetailsList(Invoice var1);

    public String checkNotLetteredAdvancePaymentMoveLines(Invoice var1) throws AxelorException;

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void refusalToPay(Invoice var1, CancelReason var2, String var3);

    public User getPfpValidatorUser(Invoice var1);

    public String getPfpValidatorUserDomain(Invoice var1);
}

