/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import java.math.BigDecimal;
import java.time.LocalDate;

public class InvoiceToolService {
    @CallMethod
    public static LocalDate getDueDate(PaymentCondition paymentCondition, LocalDate invoiceDate) {
        if (paymentCondition == null) {
            return invoiceDate;
        }
        LocalDate nDaysDate = null;
        nDaysDate = paymentCondition.getPeriodTypeSelect().equals(1) ? invoiceDate.plusDays(paymentCondition.getPaymentTime().intValue()) : invoiceDate.plusMonths(paymentCondition.getPaymentTime().intValue());
        switch (paymentCondition.getTypeSelect()) {
            case 1: {
                return nDaysDate;
            }
            case 2: {
                if (paymentCondition.getPeriodTypeSelect().equals(1)) {
                    return invoiceDate.withDayOfMonth(invoiceDate.lengthOfMonth()).plusDays(paymentCondition.getPaymentTime().intValue());
                }
                return invoiceDate.withDayOfMonth(invoiceDate.lengthOfMonth()).plusMonths(paymentCondition.getPaymentTime().intValue());
            }
            case 3: {
                return nDaysDate.withDayOfMonth(nDaysDate.lengthOfMonth());
            }
            case 4: {
                return nDaysDate.withDayOfMonth(nDaysDate.lengthOfMonth()).plusDays(paymentCondition.getDaySelect().intValue());
            }
        }
        return invoiceDate;
    }

    public static boolean isPurchase(Invoice invoice) throws AxelorException {
        switch (invoice.getOperationTypeSelect()) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"Invoice type missing on invoice %s"), new Object[]{invoice.getInvoiceId()});
    }

    public static boolean isRefund(Invoice invoice) throws AxelorException {
        boolean isRefund;
        switch (invoice.getOperationTypeSelect()) {
            case 1: {
                isRefund = false;
                break;
            }
            case 2: {
                isRefund = true;
                break;
            }
            case 3: {
                isRefund = false;
                break;
            }
            case 4: {
                isRefund = true;
                break;
            }
            default: {
                throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"Invoice type missing on invoice %s"), new Object[]{invoice.getInvoiceId()});
            }
        }
        return isRefund;
    }

    public static boolean isOutPayment(Invoice invoice) throws AxelorException {
        if (invoice.getInTaxTotal().compareTo(BigDecimal.ZERO) >= 0) {
            return InvoiceToolService.isPurchase(invoice) != InvoiceToolService.isRefund(invoice);
        }
        return InvoiceToolService.isPurchase(invoice) == InvoiceToolService.isRefund(invoice);
    }

    public static PaymentMode getPaymentMode(Invoice invoice) throws AxelorException {
        PaymentMode paymentMode;
        Partner partner = invoice.getPartner();
        if (InvoiceToolService.isOutPayment(invoice)) {
            PaymentMode paymentMode2;
            if (partner != null && (paymentMode2 = partner.getOutPaymentMode()) != null) {
                return paymentMode2;
            }
            return ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(invoice.getCompany()).getOutPaymentMode();
        }
        if (partner != null && (paymentMode = partner.getInPaymentMode()) != null) {
            return paymentMode;
        }
        return ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(invoice.getCompany()).getInPaymentMode();
    }

    public static PaymentCondition getPaymentCondition(Invoice invoice) throws AxelorException {
        PaymentCondition paymentCondition;
        Partner partner = invoice.getPartner();
        if (partner != null && (paymentCondition = partner.getPaymentCondition()) != null) {
            return paymentCondition;
        }
        return ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(invoice.getCompany()).getDefPaymentCondition();
    }
}

