/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator.batch;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.generator.batch.BatchWkf;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchVentilation
extends BatchWkf {
    static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public BatchVentilation(InvoiceService invoiceService) {
        super(invoiceService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        for (Invoice invoice : BatchVentilation.invoices(this.batch.getInvoiceBatch(), true)) {
            try {
                this.invoiceService.ventilate((Invoice)((Object)this.invoiceRepo.find(invoice.getId())));
                this.updateInvoice((Invoice)((Object)this.invoiceRepo.find(invoice.getId())));
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Invoice") + " %s", new Object[]{invoice.getInvoiceId()}), (String)"invoice", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Invoice") + " %s", invoice.getInvoiceId()), e), (String)"invoice", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            finally {
                JPA.clear();
            }
        }
    }

    protected void stop() {
        String comment = I18n.get((String)"Invoice ventilation's reporting :") + "\n";
        comment = comment + String.format("\t* %s " + I18n.get((String)"Invoice(s) ventilated") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

