/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator.tax;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.invoice.generator.TaxGenerator;
import com.google.common.base.Joiner;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxInvoiceLine
extends TaxGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TaxInvoiceLine(Invoice invoice, List<InvoiceLine> invoiceLines) {
        super(invoice, invoiceLines);
    }

    public List<InvoiceLineTax> creates() {
        ArrayList<InvoiceLineTax> invoiceLineTaxList = new ArrayList<InvoiceLineTax>();
        HashMap<TaxLine, InvoiceLineTax> map = new HashMap<TaxLine, InvoiceLineTax>();
        HashSet<String> specificNotes = new HashSet<String>();
        boolean customerSpecificNote = false;
        if (this.invoice.getPartner().getFiscalPosition() != null) {
            customerSpecificNote = this.invoice.getPartner().getFiscalPosition().getCustomerSpecificNote();
        }
        if (this.invoiceLines != null && !this.invoiceLines.isEmpty()) {
            LOG.debug("Cr\u00e9ation des lignes de tva pour les lignes de factures.");
            for (InvoiceLine invoiceLine : this.invoiceLines) {
                TaxLine taxLineRC;
                TaxLine taxLine = invoiceLine.getTaxLine();
                TaxEquiv taxEquiv = invoiceLine.getTaxEquiv();
                TaxLine taxLine2 = taxLineRC = taxEquiv != null && taxEquiv.getReverseCharge() != false && taxEquiv.getReverseChargeTax() != null ? taxEquiv.getReverseChargeTax().getActiveTaxLine() : null;
                if (taxLine != null) {
                    LOG.debug("TVA {}", (Object)taxLine);
                    InvoiceLineTax invoiceLineTax = (InvoiceLineTax)((Object)map.get(taxLine));
                    if (invoiceLineTax != null) {
                        invoiceLineTax.setExTaxBase(invoiceLineTax.getExTaxBase().add(invoiceLine.getExTaxTotal()));
                        invoiceLineTax.setCompanyExTaxBase(invoiceLineTax.getCompanyExTaxBase().add(invoiceLine.getCompanyExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
                        invoiceLineTax.setReverseCharged(false);
                        if (!invoiceLine.getFixedAssets().booleanValue()) {
                            invoiceLineTax.setSubTotalExcludingFixedAssets(invoiceLineTax.getSubTotalExcludingFixedAssets().add(invoiceLine.getExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
                            invoiceLineTax.setCompanySubTotalExcludingFixedAssets(invoiceLineTax.getCompanySubTotalExcludingFixedAssets().add(invoiceLine.getCompanyExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
                        }
                    } else {
                        invoiceLineTax = new InvoiceLineTax();
                        invoiceLineTax.setInvoice(this.invoice);
                        invoiceLineTax.setExTaxBase(invoiceLine.getExTaxTotal());
                        invoiceLineTax.setCompanyExTaxBase(invoiceLine.getCompanyExTaxTotal().setScale(2, RoundingMode.HALF_UP));
                        invoiceLineTax.setReverseCharged(false);
                        if (!invoiceLine.getFixedAssets().booleanValue()) {
                            invoiceLineTax.setSubTotalExcludingFixedAssets(invoiceLine.getCompanyExTaxTotal().setScale(2, RoundingMode.HALF_UP));
                            invoiceLineTax.setCompanySubTotalExcludingFixedAssets(invoiceLineTax.getCompanySubTotalExcludingFixedAssets().add(invoiceLine.getCompanyExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
                        }
                        invoiceLineTax.setTaxLine(taxLine);
                        map.put(taxLine, invoiceLineTax);
                    }
                }
                if (taxLineRC != null) {
                    InvoiceLineTax invoiceLineTaxRC;
                    if (map.containsKey(taxLineRC)) {
                        invoiceLineTaxRC = (InvoiceLineTax)((Object)map.get(taxEquiv.getReverseChargeTax().getActiveTaxLine()));
                        invoiceLineTaxRC.setExTaxBase(invoiceLineTaxRC.getExTaxBase().add(invoiceLine.getExTaxTotal()));
                        invoiceLineTaxRC.setCompanyExTaxBase(invoiceLineTaxRC.getCompanyExTaxBase().add(invoiceLine.getCompanyExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
                        invoiceLineTaxRC.setReverseCharged(true);
                    } else {
                        invoiceLineTaxRC = new InvoiceLineTax();
                        invoiceLineTaxRC.setInvoice(this.invoice);
                        invoiceLineTaxRC.setExTaxBase(invoiceLine.getExTaxTotal());
                        invoiceLineTaxRC.setCompanyExTaxBase(invoiceLine.getCompanyExTaxTotal().setScale(2, RoundingMode.HALF_UP));
                        invoiceLineTaxRC.setReverseCharged(true);
                        invoiceLineTaxRC.setTaxLine(taxLineRC);
                        map.put(taxLineRC, invoiceLineTaxRC);
                    }
                }
                if (customerSpecificNote || taxEquiv == null || taxEquiv.getSpecificNote() == null) continue;
                specificNotes.add(taxEquiv.getSpecificNote());
            }
        }
        for (InvoiceLineTax invoiceLineTax : map.values()) {
            BigDecimal taxValue = invoiceLineTax.getTaxLine().getValue();
            BigDecimal exTaxBase = invoiceLineTax.getReverseCharged() != false ? invoiceLineTax.getExTaxBase().negate() : invoiceLineTax.getExTaxBase();
            BigDecimal taxTotal = TaxInvoiceLine.computeAmount(exTaxBase, taxValue);
            invoiceLineTax.setTaxTotal(taxTotal);
            invoiceLineTax.setInTaxTotal(invoiceLineTax.getExTaxBase().add(taxTotal));
            BigDecimal companyExTaxBase = invoiceLineTax.getReverseCharged() != false ? invoiceLineTax.getCompanyExTaxBase().negate() : invoiceLineTax.getCompanyExTaxBase();
            BigDecimal companyTaxTotal = TaxInvoiceLine.computeAmount(companyExTaxBase, taxValue);
            invoiceLineTax.setCompanyTaxTotal(companyTaxTotal);
            invoiceLineTax.setCompanyInTaxTotal(invoiceLineTax.getCompanyExTaxBase().add(companyTaxTotal));
            invoiceLineTax.setSubTotalExcludingFixedAssets(TaxInvoiceLine.computeAmount(invoiceLineTax.getSubTotalExcludingFixedAssets(), taxValue));
            invoiceLineTax.setSubTotalOfFixedAssets(taxTotal.subtract(invoiceLineTax.getSubTotalExcludingFixedAssets()).setScale(2, RoundingMode.HALF_UP));
            invoiceLineTax.setCompanySubTotalExcludingFixedAssets(TaxInvoiceLine.computeAmount(invoiceLineTax.getCompanySubTotalExcludingFixedAssets(), taxValue));
            invoiceLineTax.setCompanySubTotalOfFixedAssets(companyTaxTotal.subtract(invoiceLineTax.getCompanySubTotalExcludingFixedAssets()).setScale(2, RoundingMode.HALF_UP));
            invoiceLineTaxList.add(invoiceLineTax);
            LOG.debug("Ligne de TVA : Total TVA => {}, Total HT => {}", new Object[]{invoiceLineTax.getTaxTotal(), invoiceLineTax.getInTaxTotal()});
        }
        if (!customerSpecificNote) {
            this.invoice.setSpecificNotes(Joiner.on((char)'\n').join(specificNotes));
        } else {
            this.invoice.setSpecificNotes(this.invoice.getPartner().getSpecificTaxNote());
        }
        return invoiceLineTaxList;
    }
}

