/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.print;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.AccountConfigRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.print.InvoicePrintService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class InvoicePrintServiceImpl
implements InvoicePrintService {
    protected InvoiceRepository invoiceRepo;
    protected AccountConfigRepository accountConfigRepo;

    @Inject
    public InvoicePrintServiceImpl(InvoiceRepository invoiceRepo, AccountConfigRepository accountConfigRepo) {
        this.invoiceRepo = invoiceRepo;
        this.accountConfigRepo = accountConfigRepo;
    }

    @Override
    public String printInvoice(Invoice invoice, boolean forceRefresh, String format, Integer reportType, String locale) throws AxelorException, IOException {
        String fileName = this.getInvoiceFilesName(false, format);
        return PdfTool.getFileLinkFromPdfFile((File)this.printCopiesToFile(invoice, forceRefresh, reportType, format, locale), (String)fileName);
    }

    @Override
    public File printCopiesToFile(Invoice invoice, boolean forceRefresh, Integer reportType, String format, String locale) throws AxelorException, IOException {
        File file = this.getPrintedInvoice(invoice, forceRefresh, reportType, format, locale);
        int copyNumber = invoice.getInvoicesCopySelect();
        return format.equals("pdf") ? PdfTool.printCopiesToFile((File)file, (int)copyNumber) : file;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public File getPrintedInvoice(Invoice invoice, boolean forceRefresh, Integer reportType, String format, String locale) throws AxelorException {
        if (invoice.getStatusSelect() == 3 || invoice.getOperationSubTypeSelect() == 2 && invoice.getStatusSelect() == 2) {
            if (!forceRefresh && invoice.getPrintedPDF() != null && reportType != null && reportType != 3) {
                Path path = MetaFiles.getPath((String)invoice.getPrintedPDF().getFileName());
                return path.toFile();
            }
            return reportType != null && reportType == 3 ? this.print(invoice, reportType, format, locale) : this.printAndSave(invoice, reportType, format, locale);
        }
        return this.print(invoice, reportType, format, locale);
    }

    @Override
    public File print(Invoice invoice, Integer reportType, String format, String locale) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(invoice, reportType, format, locale);
        return reportSettings.generate().getFile();
    }

    @Override
    public File printAndSave(Invoice invoice, Integer reportType, String format, String locale) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(invoice, reportType, format, locale);
        reportSettings.toAttach((Model)((Object)invoice));
        File file = reportSettings.generate().getFile();
        try {
            MetaFiles metaFiles = (MetaFiles)Beans.get(MetaFiles.class);
            MetaFile metaFile = metaFiles.upload(file);
            invoice.setPrintedPDF(metaFile);
            return MetaFiles.getPath((MetaFile)metaFile).toFile();
        }
        catch (IOException e) {
            throw new AxelorException(4, I18n.get((String)"Error on uploading printed invoice:") + " " + e.getLocalizedMessage());
        }
    }

    @Override
    public String printInvoices(List<Long> ids) throws IOException, AxelorException {
        final ArrayList printedInvoices = new ArrayList();
        List<String> invalidPrintSettingsInvoiceIds = this.checkInvalidPrintSettingsInvoices(ids);
        if (invalidPrintSettingsInvoiceIds.size() > 0) {
            throw new AxelorException(1, I18n.get((String)"Please fill printing settings on following invoices: %s"), new Object[]{invalidPrintSettingsInvoiceIds.toString()});
        }
        ModelTool.apply(Invoice.class, ids, (ThrowConsumer)new ThrowConsumer<Invoice>(){

            public void accept(Invoice invoice) throws Exception {
                printedInvoices.add(InvoicePrintServiceImpl.this.printCopiesToFile(invoice, false, null, "pdf", null));
            }
        });
        String fileName = this.getInvoiceFilesName(true, "pdf");
        return PdfTool.mergePdfToFileLink(printedInvoices, (String)fileName);
    }

    public List<String> checkInvalidPrintSettingsInvoices(List<Long> ids) {
        ArrayList<String> invalidPrintSettingsInvoiceIds = new ArrayList<String>();
        for (Long id : ids) {
            Invoice invoice = (Invoice)((Object)this.invoiceRepo.find(id));
            if (invoice.getPrintingSettings() != null) continue;
            invalidPrintSettingsInvoiceIds.add(invoice.getInvoiceId());
        }
        return invalidPrintSettingsInvoiceIds;
    }

    @Override
    public ReportSettings prepareReportSettings(Invoice invoice, Integer reportType, String format, String locale) throws AxelorException {
        if (invoice.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on invoice %s."), invoice.getInvoiceId()), new Object[]{invoice});
        }
        String title = I18n.get((String)"Invoice");
        if (invoice.getInvoiceId() != null) {
            title = title + " " + invoice.getInvoiceId();
        }
        ReportSettings reportSetting = ReportFactory.createReport((String)"Invoice.rptdesign", (String)(title + " - ${date}"));
        if (Strings.isNullOrEmpty((String)locale)) {
            String userLanguageCode = AuthUtils.getUser().getLanguage();
            String companyLanguageCode = invoice.getCompany().getLanguage() != null ? invoice.getCompany().getLanguage().getCode() : userLanguageCode;
            String partnerLanguageCode = invoice.getPartner().getLanguage() != null ? invoice.getPartner().getLanguage().getCode() : userLanguageCode;
            locale = this.accountConfigRepo.findByCompany(invoice.getCompany()).getIsPrintInvoicesInCompanyLanguage() != false ? companyLanguageCode : partnerLanguageCode;
        }
        return reportSetting.addParam("InvoiceId", (Object)invoice.getId()).addParam("Locale", (Object)locale).addParam("ReportType", (Object)(reportType == null ? 0 : reportType)).addParam("HeaderHeight", (Object)invoice.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)invoice.getPrintingSettings().getPdfFooterHeight()).addFormat(format);
    }

    protected String getInvoiceFilesName(boolean plural, String format) {
        return I18n.get((String)(plural ? "Invoices" : "Invoice")) + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate().format(DateTimeFormatter.BASIC_ISO_DATE) + "." + format;
    }
}

