/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.workflow.cancel;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.service.BudgetService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.workflow.WorkflowInvoice;
import com.axelor.apps.account.service.invoice.workflow.cancel.WorkflowCancelService;
import com.axelor.apps.account.service.move.MoveCancelService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public class CancelState
extends WorkflowInvoice {
    private WorkflowCancelService workflowService;
    private BudgetService budgetService;

    @Inject
    CancelState(WorkflowCancelService workflowService, BudgetService budgetService) {
        this.workflowService = workflowService;
        this.budgetService = budgetService;
    }

    @Override
    public void init(Invoice invoice) {
        this.invoice = invoice;
    }

    @Override
    public void process() throws AxelorException {
        this.workflowService.beforeCancel(this.invoice);
        if (this.invoice.getStatusSelect() == 3 && this.invoice.getCompany().getAccountConfig().getAllowCancelVentilatedInvoice().booleanValue()) {
            this.cancelMove();
        }
        this.setStatus();
        if (((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(this.invoice.getCompany()).getIsManagePassedForPayment().booleanValue()) {
            this.setPfpStatus();
        }
        this.budgetService.updateBudgetLinesFromInvoice(this.invoice);
        this.workflowService.afterCancel(this.invoice);
    }

    protected void setStatus() {
        this.invoice.setStatusSelect(4);
    }

    protected void cancelMove() throws AxelorException {
        if (this.invoice.getOldMove() != null) {
            throw new AxelorException(4, I18n.get((String)"Invoice is passed in doubfult debit, and can't be canceled"));
        }
        Move move = this.invoice.getMove();
        this.invoice.setMove(null);
        ((MoveCancelService)Beans.get(MoveCancelService.class)).cancel(move);
    }

    protected void setPfpStatus() {
        this.invoice.setPfpValidateStatusSelect(1);
        this.invoice.setDecisionPfpTakenDate(null);
    }
}

