/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.workflow.validate;

import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.BudgetService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.workflow.WorkflowInvoice;
import com.axelor.apps.account.service.invoice.workflow.validate.WorkflowValidationService;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;

public class ValidateState
extends WorkflowInvoice {
    protected UserService userService;
    protected BlockingService blockingService;
    protected WorkflowValidationService workflowValidationService;
    protected AppBaseService appBaseService;
    protected InvoiceService invoiceService;
    protected AppAccountService appAccountService;
    protected BudgetService budgetService;

    @Inject
    public ValidateState(UserService userService, BlockingService blockingService, WorkflowValidationService workflowValidationService, AppBaseService appBaseService, InvoiceService invoiceService, AppAccountService appAccountService, BudgetService budgetService) {
        this.userService = userService;
        this.blockingService = blockingService;
        this.workflowValidationService = workflowValidationService;
        this.appBaseService = appBaseService;
        this.invoiceService = invoiceService;
        this.appAccountService = appAccountService;
        this.budgetService = budgetService;
    }

    @Override
    public void init(Invoice invoice) {
        this.invoice = invoice;
    }

    @Override
    public void process() throws AxelorException {
        if (this.invoice.getAddress() == null && (this.invoice.getOperationTypeSelect() == 3 || this.invoice.getOperationTypeSelect() == 4)) {
            throw new AxelorException(1, I18n.get((String)"%s : Invoicing address missing"), new Object[]{I18n.get((String)"Warning !")});
        }
        if (this.invoice.getPaymentMode() != null && (InvoiceToolService.isOutPayment(this.invoice) && this.invoice.getPaymentMode().getInOutSelect() == 1 || !InvoiceToolService.isOutPayment(this.invoice) && this.invoice.getPaymentMode().getInOutSelect() == 2)) {
            throw new AxelorException(5, I18n.get((String)"The payment mode is not in adequacy with the invoice type"));
        }
        if (this.blockingService.getBlocking(this.invoice.getPartner(), this.invoice.getCompany(), BlockingRepository.INVOICING_BLOCKING.intValue()) != null) {
            throw new AxelorException(5, I18n.get((String)"The partner is blocked for invoicing."));
        }
        this.invoice.setStatusSelect(2);
        this.invoice.setValidatedByUser(this.userService.getUser());
        this.invoice.setValidatedDate(this.appBaseService.getTodayDate());
        if (this.invoice.getPartnerAccount() == null) {
            this.invoice.setPartnerAccount(this.invoiceService.getPartnerAccount(this.invoice));
        }
        if (this.invoice.getJournal() == null) {
            this.invoice.setJournal(this.invoiceService.getJournal(this.invoice));
        }
        if (this.invoice.getOperationTypeSelect() == 1 && this.appAccountService.isApp("budget")) {
            if (!this.appAccountService.getAppBudget().getManageMultiBudget().booleanValue()) {
                this.generateBudgetDistribution(this.invoice);
            }
            this.budgetService.updateBudgetLinesFromInvoice(this.invoice);
        }
        this.workflowValidationService.afterValidation(this.invoice);
    }

    private void generateBudgetDistribution(Invoice invoice) {
        if (invoice.getInvoiceLineList() != null) {
            for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
                if (invoiceLine.getBudget() == null || invoiceLine.getBudgetDistributionList() != null && !invoiceLine.getBudgetDistributionList().isEmpty()) continue;
                BudgetDistribution budgetDistribution = new BudgetDistribution();
                budgetDistribution.setBudget(invoiceLine.getBudget());
                budgetDistribution.setAmount(invoiceLine.getCompanyExTaxTotal());
                invoiceLine.addBudgetDistributionListItem(budgetDistribution);
            }
        }
    }
}

