/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveCreateService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class MoveAdjustementService {
    protected MoveLineService moveLineService;
    protected MoveCreateService moveCreateService;
    protected MoveValidateService moveValidateService;
    protected MoveRepository moveRepository;
    protected AccountConfigService accountConfigService;
    protected AppAccountService appAccountService;

    @Inject
    public MoveAdjustementService(AppAccountService appAccountService, MoveLineService moveLineService, MoveCreateService moveCreateService, MoveValidateService moveValidateService, AccountConfigService accountConfigService, MoveRepository moveRepository) {
        this.moveLineService = moveLineService;
        this.moveCreateService = moveCreateService;
        this.moveValidateService = moveValidateService;
        this.moveRepository = moveRepository;
        this.accountConfigService = accountConfigService;
        this.appAccountService = appAccountService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void createAdjustmentDebitMove(MoveLine debitMoveLine) throws AxelorException {
        Partner partner = debitMoveLine.getPartner();
        Account account = debitMoveLine.getAccount();
        Move debitMove = debitMoveLine.getMove();
        Company company = debitMove.getCompany();
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        BigDecimal debitAmountRemaining = debitMoveLine.getAmountRemaining();
        Journal miscOperationJournal = this.accountConfigService.getAutoMiscOpeJournal(accountConfig);
        Move adjustmentMove = this.moveCreateService.createMove(miscOperationJournal, company, null, partner, null, 2);
        MoveLine creditAdjustmentMoveLine = this.moveLineService.createMoveLine(adjustmentMove, partner, account, debitAmountRemaining, false, this.appAccountService.getTodayDate(), 1, null, null);
        MoveLine debitAdjustmentMoveLine = this.moveLineService.createMoveLine(adjustmentMove, partner, this.accountConfigService.getCashPositionVariationAccount(accountConfig), debitAmountRemaining, true, this.appAccountService.getTodayDate(), 2, null, null);
        adjustmentMove.addMoveLineListItem(creditAdjustmentMoveLine);
        adjustmentMove.addMoveLineListItem(debitAdjustmentMoveLine);
        this.moveValidateService.validate(adjustmentMove);
        this.moveRepository.save((Model)((Object)adjustmentMove));
    }

    public MoveLine createAdjustmentCreditMove(MoveLine debitMoveLine) throws AxelorException {
        Partner partner = debitMoveLine.getPartner();
        Account account = debitMoveLine.getAccount();
        Move debitMove = debitMoveLine.getMove();
        Company company = debitMove.getCompany();
        BigDecimal debitAmountRemaining = debitMoveLine.getAmountRemaining();
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        Journal miscOperationJournal = this.accountConfigService.getAutoMiscOpeJournal(accountConfig);
        Move adjustmentMove = this.moveCreateService.createMove(miscOperationJournal, company, null, partner, null, 2);
        MoveLine creditAdjustmentMoveLine = this.moveLineService.createMoveLine(adjustmentMove, partner, account, debitAmountRemaining, false, this.appAccountService.getTodayDate(), 1, null, null);
        MoveLine debitAdjustmentMoveLine = this.moveLineService.createMoveLine(adjustmentMove, partner, this.accountConfigService.getCashPositionVariationAccount(accountConfig), debitAmountRemaining, true, this.appAccountService.getTodayDate(), 2, null, null);
        adjustmentMove.addMoveLineListItem(creditAdjustmentMoveLine);
        adjustmentMove.addMoveLineListItem(debitAdjustmentMoveLine);
        this.moveValidateService.validate(adjustmentMove);
        this.moveRepository.save((Model)((Object)adjustmentMove));
        return creditAdjustmentMoveLine;
    }

    public Move createMoveToPassOnTheOtherAccount(MoveLine debitMoveLineToReconcile, MoveLine creditMoveLineToReconcile, BigDecimal amount) throws AxelorException {
        Partner partnerDebit = debitMoveLineToReconcile.getPartner();
        Partner partnerCredit = creditMoveLineToReconcile.getPartner();
        Company company = debitMoveLineToReconcile.getMove().getCompany();
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        Journal journal = this.accountConfigService.getAutoMiscOpeJournal(accountConfig);
        Move move = this.moveCreateService.createMove(journal, company, null, partnerDebit, null, 2);
        MoveLine debitMoveLine = this.moveLineService.createMoveLine(move, partnerCredit, creditMoveLineToReconcile.getAccount(), amount, true, this.appAccountService.getTodayDate(), 1, null, null);
        MoveLine creditMoveLine = this.moveLineService.createMoveLine(move, partnerDebit, debitMoveLineToReconcile.getAccount(), amount, false, this.appAccountService.getTodayDate(), 2, null, null);
        move.addMoveLineListItem(debitMoveLine);
        move.addMoveLineListItem(creditMoveLine);
        this.moveValidateService.validate(move);
        return move;
    }
}

