/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.exception.AxelorException;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveDueService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private MoveLineRepository moveLineRepository;

    @Inject
    public MoveDueService(MoveLineRepository moveLineRepository) {
        this.moveLineRepository = moveLineRepository;
    }

    public MoveLine getOrignalInvoiceFromRefund(Invoice invoice) {
        Invoice originalInvoice = invoice.getOriginalInvoice();
        if (originalInvoice != null && originalInvoice.getMove() != null) {
            for (MoveLine moveLine : originalInvoice.getMove().getMoveLineList()) {
                if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
                return moveLine;
            }
        }
        return null;
    }

    public List<MoveLine> getInvoiceDue(Invoice invoice, boolean useOthersInvoiceDue) throws AxelorException {
        Company company = invoice.getCompany();
        Partner partner = invoice.getPartner();
        ArrayList debitMoveLines = Lists.newArrayList();
        MoveLine originalInvoice = this.getOrignalInvoiceFromRefund(invoice);
        if (originalInvoice != null) {
            debitMoveLines.add(originalInvoice);
        }
        List othersDebitMoveLines = null;
        if (useOthersInvoiceDue) {
            othersDebitMoveLines = debitMoveLines != null && debitMoveLines.size() != 0 ? this.moveLineRepository.all().filter("self.move.company = ?1 AND (self.move.statusSelect = ?2 OR self.move.statusSelect = ?3) AND self.move.ignoreInAccountingOk IN (false,null) AND self.account.useForPartnerBalance = ?4 AND self.debit > 0 AND self.amountRemaining > 0  AND self.partner = ?5 AND self NOT IN (?6) ORDER BY self.date ASC ", new Object[]{company, 3, 2, true, partner, debitMoveLines}).fetch() : this.moveLineRepository.all().filter("self.move.company = ?1 AND (self.move.statusSelect = ?2 OR self.move.statusSelect = ?3) AND self.move.ignoreInAccountingOk IN (false,null) AND self.account.useForPartnerBalance = ?4 AND self.debit > 0 AND self.amountRemaining > 0  AND self.partner = ?5 ORDER BY self.date ASC ", new Object[]{company, 3, 2, true, partner}).fetch();
            debitMoveLines.addAll(othersDebitMoveLines);
        }
        this.log.debug("Nombre de ligne \u00e0 payer avec l'avoir r\u00e9cup\u00e9r\u00e9 : {}", (Object)debitMoveLines.size());
        return debitMoveLines;
    }
}

