/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.TaxPaymentMoveLine;
import com.axelor.apps.account.db.repo.AnalyticMoveLineRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.FiscalPositionAccountService;
import com.axelor.apps.account.service.TaxAccountService;
import com.axelor.apps.account.service.TaxPaymentMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.payment.PaymentService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.config.CompanyConfigService;
import com.axelor.apps.tool.StringTool;
import com.axelor.auth.db.AuditableModel;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveLineService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AccountManagementAccountService accountManagementService;
    protected TaxAccountService taxAccountService;
    protected FiscalPositionAccountService fiscalPositionAccountService;
    protected AnalyticMoveLineService analyticMoveLineService;
    protected AppAccountService appAccountService;
    protected CurrencyService currencyService;
    protected CompanyConfigService companyConfigService;
    protected MoveLineRepository moveLineRepository;
    protected TaxPaymentMoveLineService taxPaymentMoveLineService;
    public static final boolean IS_CREDIT = false;
    public static final boolean IS_DEBIT = true;

    @Inject
    public MoveLineService(AccountManagementAccountService accountManagementService, TaxAccountService taxAccountService, FiscalPositionAccountService fiscalPositionAccountService, AppAccountService appAccountService, AnalyticMoveLineService analyticMoveLineService, CurrencyService currencyService, CompanyConfigService companyConfigService, MoveLineRepository moveLineRepository, TaxPaymentMoveLineService taxPaymentMoveLineService) {
        this.accountManagementService = accountManagementService;
        this.taxAccountService = taxAccountService;
        this.fiscalPositionAccountService = fiscalPositionAccountService;
        this.analyticMoveLineService = analyticMoveLineService;
        this.appAccountService = appAccountService;
        this.currencyService = currencyService;
        this.companyConfigService = companyConfigService;
        this.moveLineRepository = moveLineRepository;
        this.taxPaymentMoveLineService = taxPaymentMoveLineService;
    }

    public MoveLine computeAnalyticDistribution(MoveLine moveLine) {
        List<AnalyticMoveLine> analyticMoveLineList = moveLine.getAnalyticMoveLineList();
        if (analyticMoveLineList == null || analyticMoveLineList.isEmpty()) {
            this.createAnalyticDistributionWithTemplate(moveLine);
        } else {
            LocalDate date = moveLine.getDate();
            BigDecimal amount = moveLine.getDebit().add(moveLine.getCredit());
            for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
                this.analyticMoveLineService.updateAnalyticMoveLine(analyticMoveLine, amount, date);
            }
        }
        this.updateAccountTypeOnAnalytic(moveLine, analyticMoveLineList);
        return moveLine;
    }

    public MoveLine createAnalyticDistributionWithTemplate(MoveLine moveLine) {
        List<AnalyticMoveLine> analyticMoveLineList = this.analyticMoveLineService.generateLines(moveLine.getAnalyticDistributionTemplate(), moveLine.getDebit().add(moveLine.getCredit()), 3, moveLine.getDate());
        if (moveLine.getAnalyticMoveLineList() == null) {
            moveLine.setAnalyticMoveLineList(new ArrayList<AnalyticMoveLine>());
        } else {
            moveLine.getAnalyticMoveLineList().clear();
        }
        for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
            moveLine.addAnalyticMoveLineListItem(analyticMoveLine);
        }
        return moveLine;
    }

    public void updateAccountTypeOnAnalytic(MoveLine moveLine, List<AnalyticMoveLine> analyticMoveLineList) {
        if (analyticMoveLineList == null || analyticMoveLineList.isEmpty()) {
            return;
        }
        for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
            if (moveLine.getAccount() == null) continue;
            analyticMoveLine.setAccount(moveLine.getAccount());
            analyticMoveLine.setAccountType(moveLine.getAccount().getAccountType());
        }
    }

    public void generateAnalyticMoveLines(MoveLine moveLine) {
        List<AnalyticMoveLine> analyticMoveLineList = this.analyticMoveLineService.generateLines(moveLine.getAnalyticDistributionTemplate(), moveLine.getDebit().add(moveLine.getCredit()), 3, moveLine.getDate());
        analyticMoveLineList.stream().forEach(moveLine::addAnalyticMoveLineListItem);
    }

    public MoveLine createMoveLine(Move move, Partner partner, Account account, BigDecimal amountInSpecificMoveCurrency, boolean isDebit, LocalDate date, LocalDate dueDate, int counter, String origin, String description) throws AxelorException {
        this.log.debug("Creating accounting move line (Account : {}, Amount in specific move currency : {}, debit ? : {}, date : {}, counter : {}, reference : {}", new Object[]{account.getName(), amountInSpecificMoveCurrency, isDebit, date, counter, origin});
        Currency currency = move.getCurrency();
        Currency companyCurrency = this.companyConfigService.getCompanyCurrency(move.getCompany());
        BigDecimal currencyRate = this.currencyService.getCurrencyConversionRate(currency, companyCurrency, date);
        BigDecimal amountConvertedInCompanyCurrency = this.currencyService.getAmountCurrencyConvertedUsingExchangeRate(amountInSpecificMoveCurrency, currencyRate);
        return this.createMoveLine(move, partner, account, amountInSpecificMoveCurrency, amountConvertedInCompanyCurrency, currencyRate, isDebit, date, dueDate, date, counter, origin, description);
    }

    public MoveLine createMoveLine(Move move, Partner partner, Account account, BigDecimal amountInSpecificMoveCurrency, BigDecimal amountInCompanyCurrency, BigDecimal currencyRate, boolean isDebit, LocalDate date, LocalDate dueDate, LocalDate originDate, int counter, String origin, String description) throws AxelorException {
        amountInSpecificMoveCurrency = amountInSpecificMoveCurrency.abs();
        this.log.debug("Creating accounting move line (Account : {}, Amount in specific move currency : {}, debit ? : {}, date : {}, counter : {}, reference : {}", new Object[]{account.getName(), amountInSpecificMoveCurrency, isDebit, date, counter, origin});
        if (partner != null) {
            account = this.fiscalPositionAccountService.getAccount(partner.getFiscalPosition(), account);
        }
        BigDecimal debit = BigDecimal.ZERO;
        BigDecimal credit = BigDecimal.ZERO;
        if (amountInCompanyCurrency.compareTo(BigDecimal.ZERO) == -1) {
            isDebit = !isDebit;
            amountInCompanyCurrency = amountInCompanyCurrency.negate();
        }
        if (isDebit) {
            debit = amountInCompanyCurrency;
        } else {
            credit = amountInCompanyCurrency;
        }
        if (currencyRate == null) {
            currencyRate = amountInSpecificMoveCurrency.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : amountInCompanyCurrency.divide(amountInSpecificMoveCurrency, 5, RoundingMode.HALF_EVEN);
        }
        if (originDate == null) {
            originDate = date;
        }
        return new MoveLine(move, partner, account, date, dueDate, counter, debit, credit, StringTool.cutTooLongString((String)this.determineDescriptionMoveLine(move.getJournal(), origin, description)), origin, currencyRate.setScale(5, RoundingMode.HALF_EVEN), amountInSpecificMoveCurrency, originDate);
    }

    public MoveLine createMoveLine(Move move, Partner partner, Account account, BigDecimal amount, boolean isDebit, LocalDate date, int ref, String origin, String description) throws AxelorException {
        return this.createMoveLine(move, partner, account, amount, isDebit, date, date, ref, origin, description);
    }

    public List<MoveLine> createMoveLines(Invoice invoice, Move move, Company company, Partner partner, Account partnerAccount, boolean consolidate, boolean isPurchase, boolean isDebitCustomer) throws AxelorException {
        this.log.debug("Cr\u00e9ation des lignes d'\u00e9criture comptable de la facture/l'avoir {}", (Object)invoice.getInvoiceId());
        ArrayList<MoveLine> moveLines = new ArrayList<MoveLine>();
        HashSet analyticAccounts = new HashSet();
        int moveLineId = 1;
        if (partner == null) {
            throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"Partner is missing on the invoice %s"), new Object[]{invoice.getInvoiceId()});
        }
        if (partnerAccount == null) {
            throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"Partner account missing on the invoice %s"), new Object[]{invoice.getInvoiceId()});
        }
        String origin = invoice.getInvoiceId();
        if (InvoiceToolService.isPurchase(invoice)) {
            origin = invoice.getSupplierInvoiceNb();
        }
        MoveLine moveLine1 = this.createMoveLine(move, partner, partnerAccount, invoice.getInTaxTotal(), invoice.getCompanyInTaxTotal(), null, isDebitCustomer, invoice.getInvoiceDate(), invoice.getDueDate(), invoice.getOriginDate(), moveLineId++, origin, null);
        moveLines.add(moveLine1);
        AnalyticMoveLineRepository analyticMoveLineRepository = (AnalyticMoveLineRepository)((Object)Beans.get(AnalyticMoveLineRepository.class));
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            BigDecimal companyExTaxTotal = invoiceLine.getCompanyExTaxTotal();
            if (companyExTaxTotal.compareTo(BigDecimal.ZERO) == 0) continue;
            analyticAccounts.clear();
            Account account = invoiceLine.getAccount();
            if (account == null) {
                throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"Account missing on configuration for line : %s (company : %s)"), new Object[]{invoiceLine.getName(), company.getName()});
            }
            companyExTaxTotal = invoiceLine.getCompanyExTaxTotal();
            this.log.debug("Traitement de la ligne de facture : compte comptable = {}, montant = {}", new Object[]{account.getName(), companyExTaxTotal});
            if (invoiceLine.getAnalyticDistributionTemplate() == null && (invoiceLine.getAnalyticMoveLineList() == null || invoiceLine.getAnalyticMoveLineList().isEmpty()) && account.getAnalyticDistributionAuthorized().booleanValue() && account.getAnalyticDistributionRequiredOnInvoiceLines().booleanValue()) {
                throw new AxelorException((Model)((Object)move), 1, I18n.get((String)"Analytic distribution is missing on configuration for line : %s (company : %s)"), new Object[]{invoiceLine.getName(), company.getName()});
            }
            MoveLine moveLine = this.createMoveLine(move, partner, account, invoiceLine.getExTaxTotal(), companyExTaxTotal, null, !isDebitCustomer, invoice.getInvoiceDate(), null, invoice.getOriginDate(), moveLineId++, origin, invoiceLine.getProductName());
            moveLine.setAnalyticDistributionTemplate(invoiceLine.getAnalyticDistributionTemplate());
            if (invoiceLine.getAnalyticMoveLineList() != null && !invoiceLine.getAnalyticMoveLineList().isEmpty()) {
                for (AnalyticMoveLine invoiceAnalyticMoveLine : invoiceLine.getAnalyticMoveLineList()) {
                    AnalyticMoveLine analyticMoveLine = (AnalyticMoveLine)((Object)analyticMoveLineRepository.copy((Model)((Object)invoiceAnalyticMoveLine), false));
                    analyticMoveLine.setTypeSelect(3);
                    analyticMoveLine.setInvoiceLine(null);
                    analyticMoveLine.setAccount(moveLine.getAccount());
                    analyticMoveLine.setAccountType(moveLine.getAccount().getAccountType());
                    this.analyticMoveLineService.updateAnalyticMoveLine(analyticMoveLine, moveLine.getDebit().add(moveLine.getCredit()), moveLine.getDate());
                    moveLine.addAnalyticMoveLineListItem(analyticMoveLine);
                }
            } else {
                this.generateAnalyticMoveLines(moveLine);
            }
            TaxLine taxLine = invoiceLine.getTaxLine();
            if (taxLine != null) {
                moveLine.setTaxLine(taxLine);
                moveLine.setTaxRate(taxLine.getValue());
                moveLine.setTaxCode(taxLine.getTax().getCode());
            }
            moveLines.add(moveLine);
        }
        for (InvoiceLineTax invoiceLineTax : invoice.getInvoiceLineTaxList()) {
            MoveLine moveLine;
            Account account;
            boolean hasOtherAssets;
            BigDecimal companyTaxTotal = invoiceLineTax.getCompanyTaxTotal();
            if (companyTaxTotal.compareTo(BigDecimal.ZERO) == 0) continue;
            Tax tax = invoiceLineTax.getTaxLine().getTax();
            boolean hasFixedAssets = !invoiceLineTax.getSubTotalOfFixedAssets().equals(BigDecimal.ZERO);
            boolean bl = hasOtherAssets = !invoiceLineTax.getSubTotalExcludingFixedAssets().equals(BigDecimal.ZERO);
            if (hasFixedAssets && invoiceLineTax.getCompanySubTotalOfFixedAssets().compareTo(BigDecimal.ZERO) != 0) {
                account = this.taxAccountService.getAccount(tax, company, isPurchase, true);
                if (account == null) {
                    throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"Account missing on the tax line : %s (company : %s)"), new Object[]{tax.getName(), company.getName()});
                }
                moveLine = this.createMoveLine(move, partner, account, invoiceLineTax.getSubTotalOfFixedAssets(), invoiceLineTax.getCompanySubTotalOfFixedAssets(), null, !isDebitCustomer, invoice.getInvoiceDate(), null, invoice.getOriginDate(), moveLineId++, origin, null);
                moveLine.setTaxLine(invoiceLineTax.getTaxLine());
                moveLine.setTaxRate(invoiceLineTax.getTaxLine().getValue());
                moveLine.setTaxCode(tax.getCode());
                moveLines.add(moveLine);
            }
            if (!hasOtherAssets || invoiceLineTax.getCompanySubTotalExcludingFixedAssets().compareTo(BigDecimal.ZERO) == 0) continue;
            account = this.taxAccountService.getAccount(tax, company, isPurchase, false);
            if (account == null) {
                throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"Account missing on the tax line : %s (company : %s)"), new Object[]{tax.getName(), company.getName()});
            }
            moveLine = this.createMoveLine(move, partner, account, invoiceLineTax.getSubTotalExcludingFixedAssets(), invoiceLineTax.getCompanySubTotalExcludingFixedAssets(), null, !isDebitCustomer, invoice.getInvoiceDate(), null, invoice.getOriginDate(), moveLineId++, origin, null);
            moveLine.setTaxLine(invoiceLineTax.getTaxLine());
            moveLine.setTaxRate(invoiceLineTax.getTaxLine().getValue());
            moveLine.setTaxCode(tax.getCode());
            moveLines.add(moveLine);
        }
        if (consolidate) {
            this.consolidateMoveLines(moveLines);
        }
        return moveLines;
    }

    public MoveLine findConsolidateMoveLine(Map<List<Object>, MoveLine> map, MoveLine moveLine, List<Object> keys) {
        if (map != null && !map.isEmpty()) {
            HashMap<List<Object>, MoveLine> copyMap = new HashMap<List<Object>, MoveLine>(map);
            while (!copyMap.isEmpty()) {
                if (map.containsKey(keys)) {
                    MoveLine moveLineIt = map.get(keys);
                    int count = 0;
                    if (moveLineIt.getAnalyticMoveLineList() == null && moveLine.getAnalyticMoveLineList() == null) {
                        return moveLineIt;
                    }
                    if (moveLineIt.getAnalyticMoveLineList() == null || moveLine.getAnalyticMoveLineList() == null) break;
                    List<AnalyticMoveLine> list1 = moveLineIt.getAnalyticMoveLineList();
                    List<AnalyticMoveLine> list2 = moveLine.getAnalyticMoveLineList();
                    ArrayList<AnalyticMoveLine> copyList = new ArrayList<AnalyticMoveLine>(list1);
                    if (list1.size() != list2.size()) continue;
                    block1: for (AnalyticMoveLine analyticDistributionLine : list2) {
                        for (AnalyticMoveLine analyticDistributionLineIt : copyList) {
                            if (!analyticDistributionLine.getAnalyticAxis().equals((Object)analyticDistributionLineIt.getAnalyticAxis()) || !analyticDistributionLine.getAnalyticAccount().equals((Object)analyticDistributionLineIt.getAnalyticAccount()) || !analyticDistributionLine.getAccount().equals((Object)analyticDistributionLineIt.getAccount()) || !analyticDistributionLine.getPercentage().equals(analyticDistributionLineIt.getPercentage()) || (analyticDistributionLine.getAnalyticJournal() != null || analyticDistributionLineIt.getAnalyticJournal() != null) && !analyticDistributionLine.getAnalyticJournal().equals((Object)analyticDistributionLineIt.getAnalyticJournal())) continue;
                            copyList.remove((Object)analyticDistributionLineIt);
                            ++count;
                            continue block1;
                        }
                    }
                    if (count != list1.size()) continue;
                    return moveLineIt;
                }
                return null;
            }
        }
        return null;
    }

    public List<MoveLine> consolidateMoveLines(List<MoveLine> moveLines) {
        HashMap<List<Object>, MoveLine> map = new HashMap<List<Object>, MoveLine>();
        MoveLine consolidateMoveLine = null;
        for (MoveLine moveLine : moveLines) {
            ArrayList<Object> keys = new ArrayList<Object>();
            keys.add((Object)moveLine.getAccount());
            keys.add(moveLine.getTaxLine());
            keys.add((Object)moveLine.getAnalyticDistributionTemplate());
            consolidateMoveLine = this.findConsolidateMoveLine(map, moveLine, keys);
            if (consolidateMoveLine != null) {
                BigDecimal consolidateCurrencyAmount = BigDecimal.ZERO;
                this.log.debug("MoveLine :: Debit : {}, Credit : {}, Currency amount : {}", new Object[]{moveLine.getDebit(), moveLine.getCredit(), moveLine.getCurrencyAmount()});
                this.log.debug("Consolidate moveLine :: Debit : {}, Credit : {}, Currency amount : {}", new Object[]{consolidateMoveLine.getDebit(), consolidateMoveLine.getCredit(), consolidateMoveLine.getCurrencyAmount()});
                consolidateCurrencyAmount = moveLine.getDebit().subtract(moveLine.getCredit()).compareTo(BigDecimal.ZERO) != consolidateMoveLine.getDebit().subtract(consolidateMoveLine.getCredit()).compareTo(BigDecimal.ZERO) ? consolidateMoveLine.getCurrencyAmount().subtract(moveLine.getCurrencyAmount()) : consolidateMoveLine.getCurrencyAmount().add(moveLine.getCurrencyAmount());
                consolidateMoveLine.setCurrencyAmount(consolidateCurrencyAmount.abs());
                consolidateMoveLine.setCredit(consolidateMoveLine.getCredit().add(moveLine.getCredit()));
                consolidateMoveLine.setDebit(consolidateMoveLine.getDebit().add(moveLine.getDebit()));
                if (consolidateMoveLine.getAnalyticMoveLineList() == null || consolidateMoveLine.getAnalyticMoveLineList().isEmpty()) continue;
                block1: for (AnalyticMoveLine analyticDistributionLine : consolidateMoveLine.getAnalyticMoveLineList()) {
                    for (AnalyticMoveLine analyticDistributionLineIt : moveLine.getAnalyticMoveLineList()) {
                        if (!analyticDistributionLine.getAnalyticAxis().equals((Object)analyticDistributionLineIt.getAnalyticAxis()) || !analyticDistributionLine.getAnalyticAccount().equals((Object)analyticDistributionLineIt.getAnalyticAccount()) || !analyticDistributionLine.getAccount().equals((Object)analyticDistributionLineIt.getAccount()) || !analyticDistributionLine.getPercentage().equals(analyticDistributionLineIt.getPercentage()) || (analyticDistributionLine.getAnalyticJournal() != null || analyticDistributionLineIt.getAnalyticJournal() != null) && !analyticDistributionLine.getAnalyticJournal().equals((Object)analyticDistributionLineIt.getAnalyticJournal())) continue;
                        analyticDistributionLine.setAmount(analyticDistributionLine.getAmount().add(analyticDistributionLineIt.getAmount()));
                        continue block1;
                    }
                }
                continue;
            }
            map.put(keys, moveLine);
        }
        BigDecimal credit = null;
        BigDecimal debit = null;
        int moveLineId = 1;
        moveLines.clear();
        for (MoveLine moveLine : map.values()) {
            credit = moveLine.getCredit();
            debit = moveLine.getDebit();
            moveLine.setCurrencyAmount(moveLine.getCurrencyAmount().abs());
            if (debit.compareTo(BigDecimal.ZERO) == 1 && credit.compareTo(BigDecimal.ZERO) == 1) {
                if (debit.compareTo(credit) == 1) {
                    moveLine.setDebit(debit.subtract(credit));
                    moveLine.setCredit(BigDecimal.ZERO);
                    moveLine.setCounter(moveLineId++);
                    moveLines.add(moveLine);
                    continue;
                }
                if (credit.compareTo(debit) != 1) continue;
                moveLine.setCredit(credit.subtract(debit));
                moveLine.setDebit(BigDecimal.ZERO);
                moveLine.setCounter(moveLineId++);
                moveLines.add(moveLine);
                continue;
            }
            if (debit.compareTo(BigDecimal.ZERO) != 1 && credit.compareTo(BigDecimal.ZERO) != 1) continue;
            moveLine.setCounter(moveLineId++);
            moveLines.add(moveLine);
        }
        return moveLines;
    }

    public MoveLine getCreditCustomerMoveLine(Invoice invoice) {
        if (invoice.getMove() != null) {
            return this.getCreditCustomerMoveLine(invoice.getMove());
        }
        return null;
    }

    public MoveLine getCreditCustomerMoveLine(Move move) {
        for (MoveLine moveLine : move.getMoveLineList()) {
            if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getCredit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            return moveLine;
        }
        return null;
    }

    public MoveLine getDebitCustomerMoveLine(Invoice invoice) {
        if (invoice.getMove() != null) {
            return this.getDebitCustomerMoveLine(invoice.getMove());
        }
        return null;
    }

    public MoveLine getDebitCustomerMoveLine(Move move) {
        for (MoveLine moveLine : move.getMoveLineList()) {
            if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            return moveLine;
        }
        return null;
    }

    public String determineDescriptionMoveLine(Journal journal, String origin, String description) {
        String descriptionComputed = "";
        if (journal == null) {
            return "";
        }
        if (journal.getDescriptionModel() != null) {
            descriptionComputed = descriptionComputed + journal.getDescriptionModel();
        }
        if (journal.getDescriptionIdentificationOk().booleanValue() && origin != null) {
            if (!descriptionComputed.isEmpty()) {
                descriptionComputed = descriptionComputed + " ";
            }
            descriptionComputed = descriptionComputed + origin;
        }
        if (!journal.getIsInvoiceMoveConsolidated().booleanValue() && description != null) {
            if (!descriptionComputed.isEmpty()) {
                descriptionComputed = descriptionComputed + " - ";
            }
            descriptionComputed = descriptionComputed + description;
        }
        return descriptionComputed;
    }

    @Transactional
    public void usherProcess(MoveLine moveLine) {
        Invoice invoice = moveLine.getMove().getInvoice();
        if (invoice != null) {
            if (moveLine.getUsherPassageOk().booleanValue()) {
                invoice.setUsherPassageOk(true);
            } else {
                invoice.setUsherPassageOk(false);
            }
            ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)((Object)invoice));
        }
    }

    public List<MoveLine> getReconciliableCreditMoveLines(List<MoveLine> moveLineList) {
        ArrayList<MoveLine> reconciliableCreditMoveLineList = new ArrayList<MoveLine>();
        for (MoveLine moveLine : moveLineList) {
            if (!moveLine.getAccount().getReconcileOk().booleanValue() || moveLine.getCredit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getDebit().compareTo(BigDecimal.ZERO) != 0) continue;
            reconciliableCreditMoveLineList.add(moveLine);
        }
        return reconciliableCreditMoveLineList;
    }

    public List<MoveLine> getReconciliableDebitMoveLines(List<MoveLine> moveLineList) {
        ArrayList<MoveLine> reconciliableDebitMoveLineList = new ArrayList<MoveLine>();
        for (MoveLine moveLine : moveLineList) {
            if (!moveLine.getAccount().getReconcileOk().booleanValue() || moveLine.getCredit().compareTo(BigDecimal.ZERO) != 0 || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0) continue;
            reconciliableDebitMoveLineList.add(moveLine);
        }
        return reconciliableDebitMoveLineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileMoveLinesWithCacheManagement(List<MoveLine> moveLineList) {
        List<MoveLine> reconciliableCreditMoveLineList = this.getReconciliableCreditMoveLines(moveLineList);
        List<MoveLine> reconciliableDebitMoveLineList = this.getReconciliableDebitMoveLines(moveLineList);
        HashMap<List<Object>, Pair<List<MoveLine>, List<MoveLine>>> moveLineMap = new HashMap<List<Object>, Pair<List<MoveLine>, List<MoveLine>>>();
        this.populateCredit(moveLineMap, reconciliableCreditMoveLineList);
        this.populateDebit(moveLineMap, reconciliableDebitMoveLineList);
        Comparator<MoveLine> byDate = Comparator.comparing(MoveLine::getDate);
        PaymentService paymentService = (PaymentService)Beans.get(PaymentService.class);
        for (Pair<List<MoveLine>, List<MoveLine>> moveLineLists : moveLineMap.values()) {
            try {
                moveLineLists = this.findMoveLineLists(moveLineLists);
                this.useExcessPaymentOnMoveLinesDontThrow(byDate, paymentService, moveLineLists);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
                this.log.debug(e.getMessage());
            }
            finally {
                JPA.clear();
            }
        }
    }

    protected Pair<List<MoveLine>, List<MoveLine>> findMoveLineLists(Pair<List<MoveLine>, List<MoveLine>> moveLineLists) {
        List fetchedDebitMoveLineList = ((List)moveLineLists.getLeft()).stream().map(moveLine -> (MoveLine)((Object)((Object)this.moveLineRepository.find(moveLine.getId())))).collect(Collectors.toList());
        List fetchedCreditMoveLineList = ((List)moveLineLists.getRight()).stream().map(moveLine -> (MoveLine)((Object)((Object)this.moveLineRepository.find(moveLine.getId())))).collect(Collectors.toList());
        return Pair.of(fetchedDebitMoveLineList, fetchedCreditMoveLineList);
    }

    @Transactional
    public void reconcileMoveLines(List<MoveLine> moveLineList) {
        List<MoveLine> reconciliableCreditMoveLineList = this.getReconciliableCreditMoveLines(moveLineList);
        List<MoveLine> reconciliableDebitMoveLineList = this.getReconciliableDebitMoveLines(moveLineList);
        HashMap<List<Object>, Pair<List<MoveLine>, List<MoveLine>>> moveLineMap = new HashMap<List<Object>, Pair<List<MoveLine>, List<MoveLine>>>();
        this.populateCredit(moveLineMap, reconciliableCreditMoveLineList);
        this.populateDebit(moveLineMap, reconciliableDebitMoveLineList);
        Comparator<MoveLine> byDate = Comparator.comparing(MoveLine::getDate);
        PaymentService paymentService = (PaymentService)Beans.get(PaymentService.class);
        for (Pair moveLineLists : moveLineMap.values()) {
            List companyPartnerCreditMoveLineList = (List)moveLineLists.getLeft();
            List companyPartnerDebitMoveLineList = (List)moveLineLists.getRight();
            companyPartnerCreditMoveLineList.sort(byDate);
            companyPartnerDebitMoveLineList.sort(byDate);
            paymentService.useExcessPaymentOnMoveLinesDontThrow(companyPartnerDebitMoveLineList, companyPartnerCreditMoveLineList);
        }
    }

    @Transactional
    protected void useExcessPaymentOnMoveLinesDontThrow(Comparator<MoveLine> byDate, PaymentService paymentService, Pair<List<MoveLine>, List<MoveLine>> moveLineLists) {
        List companyPartnerCreditMoveLineList = (List)moveLineLists.getLeft();
        List companyPartnerDebitMoveLineList = (List)moveLineLists.getRight();
        companyPartnerCreditMoveLineList.sort(byDate);
        companyPartnerDebitMoveLineList.sort(byDate);
        paymentService.useExcessPaymentOnMoveLinesDontThrow(companyPartnerDebitMoveLineList, companyPartnerCreditMoveLineList);
    }

    private void populateCredit(Map<List<Object>, Pair<List<MoveLine>, List<MoveLine>>> moveLineMap, List<MoveLine> reconciliableMoveLineList) {
        this.populateMoveLineMap(moveLineMap, reconciliableMoveLineList, true);
    }

    private void populateDebit(Map<List<Object>, Pair<List<MoveLine>, List<MoveLine>>> moveLineMap, List<MoveLine> reconciliableMoveLineList) {
        this.populateMoveLineMap(moveLineMap, reconciliableMoveLineList, false);
    }

    private void populateMoveLineMap(Map<List<Object>, Pair<List<MoveLine>, List<MoveLine>>> moveLineMap, List<MoveLine> reconciliableMoveLineList, boolean isCredit) {
        for (MoveLine moveLine : reconciliableMoveLineList) {
            Move move = moveLine.getMove();
            ArrayList<AuditableModel> keys = new ArrayList<AuditableModel>();
            keys.add(move.getCompany());
            keys.add(moveLine.getAccount());
            keys.add(moveLine.getPartner());
            Pair moveLineLists = moveLineMap.get(keys);
            if (moveLineLists == null) {
                moveLineLists = Pair.of(new ArrayList(), new ArrayList());
                moveLineMap.put(keys, (Pair<List<MoveLine>, List<MoveLine>>)moveLineLists);
            }
            List moveLineList = isCredit ? (List)moveLineLists.getLeft() : (List)moveLineLists.getRight();
            moveLineList.add(moveLine);
        }
    }

    public void autoTaxLineGenerate(Move move) throws AxelorException {
        List<MoveLine> moveLineList = move.getMoveLineList();
        moveLineList.sort(new Comparator<MoveLine>(){

            @Override
            public int compare(MoveLine o1, MoveLine o2) {
                if (o2.getSourceTaxLine() != null) {
                    return 0;
                }
                return -1;
            }
        });
        Iterator<MoveLine> moveLineItr = moveLineList.iterator();
        HashMap<String, MoveLine> map = new HashMap<String, MoveLine>();
        HashMap<String, MoveLine> newMap = new HashMap<String, MoveLine>();
        while (moveLineItr.hasNext()) {
            String accountType;
            MoveLine moveLine = moveLineItr.next();
            TaxLine taxLine = moveLine.getTaxLine();
            TaxLine sourceTaxLine = moveLine.getSourceTaxLine();
            if (sourceTaxLine != null) {
                String sourceTaxLineKey = moveLine.getAccount().getCode() + sourceTaxLine.getId();
                moveLine.setCredit(BigDecimal.ZERO);
                moveLine.setDebit(BigDecimal.ZERO);
                map.put(sourceTaxLineKey, moveLine);
                moveLineItr.remove();
                continue;
            }
            if (taxLine == null || !(accountType = moveLine.getAccount().getAccountType().getTechnicalTypeSelect()).equals("debt") && !accountType.equals("charge") && !accountType.equals("income") && !accountType.equals("asset")) continue;
            BigDecimal debit = moveLine.getDebit();
            BigDecimal credit = moveLine.getCredit();
            LocalDate date = moveLine.getDate();
            Company company = move.getCompany();
            MoveLine newOrUpdatedMoveLine = new MoveLine();
            if (accountType.equals("debt") || accountType.equals("charge")) {
                newOrUpdatedMoveLine.setAccount(this.taxAccountService.getAccount(taxLine.getTax(), company, true, false));
            } else if (accountType.equals("income")) {
                newOrUpdatedMoveLine.setAccount(this.taxAccountService.getAccount(taxLine.getTax(), company, false, false));
            } else if (accountType.equals("asset")) {
                newOrUpdatedMoveLine.setAccount(this.taxAccountService.getAccount(taxLine.getTax(), company, true, true));
            }
            Account newAccount = newOrUpdatedMoveLine.getAccount();
            if (newAccount == null) {
                throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"Account missing on the tax line : %s (company : %s)"), new Object[]{taxLine.getName(), company.getName()});
            }
            String newSourceTaxLineKey = newAccount.getCode() + taxLine.getId();
            if (!map.containsKey(newSourceTaxLineKey) && !newMap.containsKey(newSourceTaxLineKey)) {
                newOrUpdatedMoveLine = this.createNewMoveLine(debit, credit, date, accountType, taxLine, newOrUpdatedMoveLine);
            } else {
                if (newMap.containsKey(newSourceTaxLineKey)) {
                    newOrUpdatedMoveLine = (MoveLine)((Object)newMap.get(newSourceTaxLineKey));
                } else if (!newMap.containsKey(newSourceTaxLineKey) && map.containsKey(newSourceTaxLineKey)) {
                    newOrUpdatedMoveLine = (MoveLine)((Object)map.get(newSourceTaxLineKey));
                }
                newOrUpdatedMoveLine.setDebit(newOrUpdatedMoveLine.getDebit().add(debit.multiply(taxLine.getValue())));
                newOrUpdatedMoveLine.setCredit(newOrUpdatedMoveLine.getCredit().add(credit.multiply(taxLine.getValue())));
            }
            newMap.put(newSourceTaxLineKey, newOrUpdatedMoveLine);
        }
        moveLineList.addAll(newMap.values());
    }

    public MoveLine createNewMoveLine(BigDecimal debit, BigDecimal credit, LocalDate date, String accountType, TaxLine taxLine, MoveLine newOrUpdatedMoveLine) {
        newOrUpdatedMoveLine.setSourceTaxLine(taxLine);
        newOrUpdatedMoveLine.setDebit(debit.multiply(taxLine.getValue()));
        newOrUpdatedMoveLine.setCredit(credit.multiply(taxLine.getValue()));
        newOrUpdatedMoveLine.setDescription(taxLine.getTax().getName());
        newOrUpdatedMoveLine.setDate(date);
        return newOrUpdatedMoveLine;
    }

    public void validateMoveLine(MoveLine moveLine) throws AxelorException {
        if (moveLine.getDebit().compareTo(BigDecimal.ZERO) == 0 && moveLine.getCredit().compareTo(BigDecimal.ZERO) == 0 && moveLine.getCurrencyAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new AxelorException((Model)((Object)moveLine), 4, I18n.get((String)"The accounting move line on the account %s can't have an amount equals to zero"), new Object[]{moveLine.getAccount().getCode()});
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public MoveLine generateTaxPaymentMoveLineList(MoveLine customerMoveLine, Invoice invoice, Reconcile reconcile) throws AxelorException {
        BigDecimal paymentAmount = reconcile.getAmount();
        BigDecimal invoiceTotalAmount = invoice.getCompanyInTaxTotal();
        for (InvoiceLineTax invoiceLineTax : invoice.getInvoiceLineTaxList()) {
            TaxLine taxLine = invoiceLineTax.getTaxLine();
            BigDecimal vatRate = taxLine.getValue();
            BigDecimal baseAmount = invoiceLineTax.getCompanyExTaxBase();
            BigDecimal detailPaymentAmount = baseAmount.multiply(paymentAmount).divide(invoiceTotalAmount, 6, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_UP);
            TaxPaymentMoveLine taxPaymentMoveLine = new TaxPaymentMoveLine(customerMoveLine, taxLine, reconcile, vatRate, detailPaymentAmount, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate());
            taxPaymentMoveLine = this.taxPaymentMoveLineService.computeTaxAmount(taxPaymentMoveLine);
            customerMoveLine.addTaxPaymentMoveLineListItem(taxPaymentMoveLine);
        }
        this.computeTaxAmount(customerMoveLine);
        return (MoveLine)((Object)((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).save((Model)((Object)customerMoveLine)));
    }

    @Transactional(rollbackOn={Exception.class})
    public MoveLine reverseTaxPaymentMoveLines(MoveLine customerMoveLine, Reconcile reconcile) throws AxelorException {
        ArrayList<TaxPaymentMoveLine> reverseTaxPaymentMoveLines = new ArrayList<TaxPaymentMoveLine>();
        for (TaxPaymentMoveLine taxPaymentMoveLine : customerMoveLine.getTaxPaymentMoveLineList()) {
            if (taxPaymentMoveLine.getIsAlreadyReverse().booleanValue() || !taxPaymentMoveLine.getReconcile().equals((Object)reconcile)) continue;
            TaxPaymentMoveLine reverseTaxPaymentMoveLine = this.taxPaymentMoveLineService.getReverseTaxPaymentMoveLine(taxPaymentMoveLine);
            reverseTaxPaymentMoveLines.add(reverseTaxPaymentMoveLine);
        }
        for (TaxPaymentMoveLine reverseTaxPaymentMoveLine : reverseTaxPaymentMoveLines) {
            customerMoveLine.addTaxPaymentMoveLineListItem(reverseTaxPaymentMoveLine);
        }
        this.computeTaxAmount(customerMoveLine);
        return (MoveLine)((Object)((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).save((Model)((Object)customerMoveLine)));
    }

    @Transactional(rollbackOn={Exception.class})
    public MoveLine computeTaxAmount(MoveLine moveLine) throws AxelorException {
        moveLine.setTaxAmount(BigDecimal.ZERO);
        if (!ObjectUtils.isEmpty(moveLine.getTaxPaymentMoveLineList())) {
            for (TaxPaymentMoveLine taxPaymentMoveLine : moveLine.getTaxPaymentMoveLineList()) {
                moveLine.setTaxAmount(moveLine.getTaxAmount().add(taxPaymentMoveLine.getTaxAmount()));
            }
        }
        return moveLine;
    }
}

