/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.tool.service.ArchivingToolService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.Map;

public class MoveRemoveService {
    protected MoveRepository moveRepo;
    protected MoveLineRepository moveLineRepo;
    protected ArchivingToolService archivingToolService;
    protected ReconcileService reconcileService;
    protected AccountingSituationService accountingSituationService;
    protected AccountCustomerService accountCustomerService;

    @Inject
    public MoveRemoveService(MoveRepository moveRepo, MoveLineRepository moveLineRepo, ArchivingToolService archivingToolService, ReconcileService reconcileService, AccountingSituationService accountingSituationService, AccountCustomerService accountCustomerService) {
        this.moveRepo = moveRepo;
        this.moveLineRepo = moveLineRepo;
        this.archivingToolService = archivingToolService;
        this.reconcileService = reconcileService;
        this.accountingSituationService = accountingSituationService;
        this.accountCustomerService = accountCustomerService;
    }

    public void archiveDaybookMove(Move move) throws Exception {
        if (move.getStatusSelect().equals(2)) {
            this.checkDaybookMove(move);
            this.cleanMoveToArchived(move);
            move = this.updateMoveToArchived(move);
            this.archiveMove(move);
            this.updateSystem(move);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected Move updateMoveToArchived(Move move) {
        move.setStatusSelect(4);
        return move;
    }

    protected void cleanMoveToArchived(Move move) throws Exception {
        for (MoveLine moveLine : move.getMoveLineList()) {
            for (Reconcile reconcile : moveLine.getDebitReconcileList()) {
                this.reconcileService.unreconcile(reconcile);
            }
            for (Reconcile reconcile : moveLine.getCreditReconcileList()) {
                this.reconcileService.unreconcile(reconcile);
            }
        }
    }

    protected void updateSystem(Move move) throws Exception {
        for (MoveLine moveLine : move.getMoveLineList()) {
            if (moveLine.getPartner() == null) continue;
            this.accountCustomerService.updateAccountingSituationCustomerAccount(this.accountingSituationService.getAccountingSituation(moveLine.getPartner(), move.getCompany()), true, true, true);
            this.accountingSituationService.updateCustomerCredit(moveLine.getPartner());
        }
    }

    protected void checkDaybookMove(Move move) throws Exception {
        String errorMessage = "";
        Map objectsLinkToMoveMap = this.archivingToolService.getObjectLinkTo((Object)move, move.getId());
        String moveModelError = null;
        for (Map.Entry entry : objectsLinkToMoveMap.entrySet()) {
            String modelName = I18n.get((String)this.archivingToolService.getModelTitle((String)entry.getKey()));
            if (((String)entry.getKey()).equals("MoveLine")) continue;
            if (moveModelError == null) {
                moveModelError = modelName;
                continue;
            }
            moveModelError = moveModelError + ", " + modelName;
        }
        if (moveModelError != null) {
            errorMessage = errorMessage + String.format(I18n.get((String)"This move %s can not be archived because it is linked to another piece named %s."), move.getReference(), moveModelError);
        }
        for (MoveLine moveLine : move.getMoveLineList()) {
            errorMessage = errorMessage + this.checkDaybookMoveLine(moveLine);
        }
        if (errorMessage != null && !errorMessage.isEmpty()) {
            throw new AxelorException(5, errorMessage);
        }
    }

    protected String checkDaybookMoveLine(MoveLine moveLine) throws AxelorException {
        String errorMessage = "";
        Map objectsLinkToMoveLineMap = this.archivingToolService.getObjectLinkTo((Object)moveLine, moveLine.getId());
        for (Map.Entry entry : objectsLinkToMoveLineMap.entrySet()) {
            String modelName = (String)entry.getKey();
            if (modelName.equals("Move") || modelName.equals("Reconcile")) continue;
            errorMessage = errorMessage + String.format(I18n.get((String)"This move line %s can not be archived because it is linked to another piece named %s."), moveLine.getName(), modelName);
        }
        return errorMessage;
    }

    @Transactional(rollbackOn={Exception.class})
    public Move archiveMove(Move move) {
        move.setArchived(true);
        for (MoveLine moveLine : move.getMoveLineList()) {
            moveLine.setArchived(true);
        }
        return move;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteMultiple(List<? extends Move> moveList) {
        int errorNB = 0;
        if (moveList == null) {
            return errorNB;
        }
        for (Move move : moveList) {
            try {
                Move move2 = (Move)((Object)this.moveRepo.find(move.getId()));
                if (move2.getStatusSelect().equals(1)) {
                    this.deleteMove(move2);
                    continue;
                }
                if (move2.getStatusSelect().equals(2)) {
                    this.archiveDaybookMove(move2);
                    continue;
                }
                if (!move2.getStatusSelect().equals(4)) continue;
                this.archiveMove(move2);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
                ++errorNB;
            }
            finally {
                JPA.clear();
            }
        }
        return errorNB;
    }

    @Transactional(rollbackOn={Exception.class})
    public void deleteMove(Move move) throws Exception {
        this.moveRepo.remove((Model)((Object)move));
    }
}

