/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import com.google.inject.Inject;

public class MoveSequenceService {
    private SequenceService sequenceService;

    @Inject
    public MoveSequenceService(SequenceService sequenceService) {
        this.sequenceService = sequenceService;
    }

    public void setDraftSequence(Move move) throws AxelorException {
        if (move.getId() != null && Strings.isNullOrEmpty((String)move.getReference()) && move.getStatusSelect() == 1) {
            move.setReference(this.sequenceService.getDraftSequenceNumber((Model)((Object)move)));
        }
    }

    public void setSequence(Move move) throws AxelorException {
        Journal journal = move.getJournal();
        if (journal.getSequence() == null) {
            throw new AxelorException(4, I18n.get((String)"Journal %s does not have any account move sequence configured"), new Object[]{journal.getName()});
        }
        move.setReference(this.sequenceService.getSequenceNumber(journal.getSequence()));
    }
}

