/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.PaymentModeRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentModeServiceImpl
implements PaymentModeService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public Account getPaymentModeAccount(PaymentMode paymentMode, Company company, BankDetails bankDetails) throws AxelorException {
        this.log.debug("R\u00e9cup\u00e9ration du compte comptable du mode de paiement associ\u00e9 \u00e0 la soci\u00e9t\u00e9 : Soci\u00e9t\u00e9 : {}, Mode de paiement : {}", new Object[]{company.getName(), paymentMode.getName()});
        AccountManagement accountManagement = this.getAccountManagement(paymentMode, company, bankDetails);
        if (accountManagement != null && accountManagement.getCashAccount() != null) {
            return accountManagement.getCashAccount();
        }
        throw new AxelorException((Model)((Object)paymentMode), 4, I18n.get((String)"Company") + " : %s, " + I18n.get((String)"Payment mode") + " : %s: " + I18n.get((String)"Associated account not configured"), new Object[]{company.getName(), paymentMode.getName()});
    }

    @Override
    public AccountManagement getAccountManagement(PaymentMode paymentMode, Company company, BankDetails bankDetails) {
        if (paymentMode.getAccountManagementList() == null) {
            return null;
        }
        if (!((AppAccountService)Beans.get(AppAccountService.class)).getAppBase().getManageMultiBanks().booleanValue()) {
            return this.getAccountManagement(paymentMode, company);
        }
        for (AccountManagement accountManagement : paymentMode.getAccountManagementList()) {
            if (accountManagement.getCompany() == null || !accountManagement.getCompany().equals((Object)company) || accountManagement.getBankDetails() == null || !accountManagement.getBankDetails().equals((Object)bankDetails)) continue;
            return accountManagement;
        }
        return null;
    }

    protected AccountManagement getAccountManagement(PaymentMode paymentMode, Company company) {
        if (paymentMode.getAccountManagementList() == null) {
            return null;
        }
        return ((AccountManagementService)Beans.get(AccountManagementService.class)).getAccountManagement(paymentMode.getAccountManagementList(), company);
    }

    @Override
    public Sequence getPaymentModeSequence(PaymentMode paymentMode, Company company, BankDetails bankDetails) throws AxelorException {
        AccountManagement accountManagement = this.getAccountManagement(paymentMode, company, bankDetails);
        if (accountManagement == null || accountManagement.getSequence() == null) {
            throw new AxelorException((Model)((Object)paymentMode), 4, I18n.get((String)"%s : Error : You must configure a sequence for the company %s and a payment mode %s"), new Object[]{I18n.get((String)"Warning !"), company.getName(), paymentMode.getName()});
        }
        return accountManagement.getSequence();
    }

    @Override
    public Journal getPaymentModeJournal(PaymentMode paymentMode, Company company, BankDetails bankDetails) throws AxelorException {
        AccountManagement accountManagement = this.getAccountManagement(paymentMode, company, bankDetails);
        if (accountManagement == null || accountManagement.getJournal() == null) {
            throw new AxelorException((Model)((Object)paymentMode), 4, I18n.get((String)"%s : Error : You must configure a journal for the company %s and a payment mode %s"), new Object[]{I18n.get((String)"Warning !"), company.getName(), paymentMode.getName()});
        }
        return accountManagement.getJournal();
    }

    @Override
    public List<BankDetails> getCompatibleBankDetailsList(PaymentMode paymentMode, Company company) {
        ArrayList<BankDetails> bankDetailsList = new ArrayList<BankDetails>();
        if (paymentMode == null) {
            return bankDetailsList;
        }
        List<AccountManagement> accountManagementList = paymentMode.getAccountManagementList();
        if (accountManagementList == null) {
            return bankDetailsList;
        }
        for (AccountManagement accountManagement : accountManagementList) {
            if (!accountManagement.getCompany().equals((Object)company) || accountManagement.getBankDetails() == null || !accountManagement.getBankDetails().getActive().booleanValue()) continue;
            bankDetailsList.add(accountManagement.getBankDetails());
        }
        return bankDetailsList;
    }

    @Override
    public PaymentMode reverseInOut(PaymentMode paymentMode) {
        if (paymentMode == null) {
            return null;
        }
        int inversedInOrOut = paymentMode.getInOutSelect() == 1 ? 2 : 1;
        return (PaymentMode)((Object)((PaymentModeRepository)((Object)Beans.get(PaymentModeRepository.class))).all().filter("self.typeSelect = :_paymentModeType AND self.inOutSelect = :_inversedInOrOut").bind("_paymentModeType", (Object)paymentMode.getTypeSelect()).bind("_inversedInOrOut", (Object)inversedInOrOut).fetchOne());
    }
}

