/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayVoucherElementToPay;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.payment.PaymentService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentServiceImpl
implements PaymentService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ReconcileService reconcileService;
    protected MoveLineService moveLineService;
    protected AppAccountService appAccountService;

    @Inject
    public PaymentServiceImpl(AppAccountService appAccountService, ReconcileService reconcileService, MoveLineService moveLineService) {
        this.reconcileService = reconcileService;
        this.moveLineService = moveLineService;
        this.appAccountService = appAccountService;
    }

    @Override
    public void useExcessPaymentOnMoveLines(List<MoveLine> debitMoveLines, List<MoveLine> creditMoveLines) throws AxelorException {
        this.useExcessPaymentOnMoveLines(debitMoveLines, creditMoveLines, false);
    }

    @Override
    public void useExcessPaymentOnMoveLinesDontThrow(List<MoveLine> debitMoveLines, List<MoveLine> creditMoveLines) {
        try {
            this.useExcessPaymentOnMoveLines(debitMoveLines, creditMoveLines, true);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            this.log.debug(e.getMessage());
        }
    }

    protected void useExcessPaymentOnMoveLines(List<MoveLine> debitMoveLines, List<MoveLine> creditMoveLines, boolean dontThrow) throws AxelorException {
        if (debitMoveLines != null && creditMoveLines != null) {
            this.log.debug("Emploie du trop per\u00e7u (nombre de lignes en d\u00e9bit : {}, nombre de ligne en cr\u00e9dit : {})", new Object[]{debitMoveLines.size(), creditMoveLines.size()});
            BigDecimal debitTotalRemaining = BigDecimal.ZERO;
            BigDecimal creditTotalRemaining = BigDecimal.ZERO;
            for (MoveLine creditMoveLine : creditMoveLines) {
                this.log.debug("Emploie du trop per\u00e7u : ligne en cr\u00e9dit : {})", (Object)creditMoveLine);
                this.log.debug("Emploie du trop per\u00e7u : ligne en cr\u00e9dit (restant \u00e0 payer): {})", (Object)creditMoveLine.getAmountRemaining());
                creditTotalRemaining = creditTotalRemaining.add(creditMoveLine.getAmountRemaining());
            }
            for (MoveLine debitMoveLine : debitMoveLines) {
                this.log.debug("Emploie du trop per\u00e7u : ligne en d\u00e9bit : {})", (Object)debitMoveLine);
                this.log.debug("Emploie du trop per\u00e7u : ligne en d\u00e9bit (restant \u00e0 payer): {})", (Object)debitMoveLine.getAmountRemaining());
                debitTotalRemaining = debitTotalRemaining.add(debitMoveLine.getAmountRemaining());
            }
            for (MoveLine creditMoveLine : creditMoveLines) {
                if (creditMoveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) != 1) continue;
                for (MoveLine debitMoveLine : debitMoveLines) {
                    if (debitMoveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) != 1 || creditMoveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) != 1) continue;
                    try {
                        this.createReconcile(debitMoveLine, creditMoveLine, debitTotalRemaining, creditTotalRemaining);
                    }
                    catch (Exception e) {
                        if (dontThrow) {
                            TraceBackService.trace((Throwable)e);
                            this.log.debug(e.getMessage());
                            continue;
                        }
                        throw e;
                    }
                }
            }
        }
    }

    @Transactional
    private void createReconcile(MoveLine debitMoveLine, MoveLine creditMoveLine, BigDecimal debitTotalRemaining, BigDecimal creditTotalRemaining) throws AxelorException {
        Reconcile reconcile;
        BigDecimal amount;
        if (debitMoveLine.getMaxAmountToReconcile() != null && debitMoveLine.getMaxAmountToReconcile().compareTo(BigDecimal.ZERO) > 0) {
            amount = debitMoveLine.getMaxAmountToReconcile().min(creditMoveLine.getAmountRemaining());
            debitMoveLine.setMaxAmountToReconcile(null);
        } else {
            amount = creditMoveLine.getAmountRemaining().min(debitMoveLine.getAmountRemaining());
        }
        this.log.debug("amount : {}", (Object)amount);
        this.log.debug("debitTotalRemaining : {}", (Object)debitTotalRemaining);
        this.log.debug("creditTotalRemaining : {}", (Object)creditTotalRemaining);
        BigDecimal nextDebitTotalRemaining = debitTotalRemaining.subtract(amount);
        BigDecimal nextCreditTotalRemaining = creditTotalRemaining.subtract(amount);
        if (nextDebitTotalRemaining.compareTo(BigDecimal.ZERO) <= 0 || nextCreditTotalRemaining.compareTo(BigDecimal.ZERO) <= 0) {
            this.log.debug("last loop");
            reconcile = this.reconcileService.createReconcile(debitMoveLine, creditMoveLine, amount, true);
        } else {
            reconcile = this.reconcileService.createReconcile(debitMoveLine, creditMoveLine, amount, false);
        }
        if (reconcile != null) {
            this.reconcileService.confirmReconcile(reconcile, true);
            debitTotalRemaining = debitTotalRemaining.subtract(amount);
            creditTotalRemaining = creditTotalRemaining.subtract(amount);
            this.log.debug("R\u00e9conciliation : {}", (Object)reconcile);
        }
    }

    @Override
    public int createExcessPaymentWithAmount(List<MoveLine> debitMoveLines, BigDecimal remainingPaidAmount, Move move, int moveLineNo, Partner partner, Company company, PayVoucherElementToPay payVoucherElementToPay, Account account, LocalDate paymentDate) throws AxelorException {
        this.log.debug("In createExcessPaymentWithAmount");
        int moveLineNo2 = moveLineNo;
        BigDecimal remainingPaidAmount2 = remainingPaidAmount;
        ArrayList<Reconcile> reconcileList = new ArrayList<Reconcile>();
        int i = debitMoveLines.size();
        for (MoveLine debitMoveLine : debitMoveLines) {
            --i;
            BigDecimal amountRemaining = debitMoveLine.getAmountRemaining();
            if (remainingPaidAmount2.compareTo(BigDecimal.ZERO) <= 0) break;
            BigDecimal amountToPay = remainingPaidAmount2.min(amountRemaining);
            String invoiceName = "";
            invoiceName = debitMoveLine.getMove().getInvoice() != null ? debitMoveLine.getMove().getInvoice().getInvoiceId() : payVoucherElementToPay.getPaymentVoucher().getRef();
            MoveLine creditMoveLine = this.moveLineService.createMoveLine(move, debitMoveLine.getPartner(), debitMoveLine.getAccount(), amountToPay, false, this.appAccountService.getTodayDate(), moveLineNo2, invoiceName, null);
            move.getMoveLineList().add(creditMoveLine);
            if (payVoucherElementToPay != null) {
                creditMoveLine.setPaymentScheduleLine(payVoucherElementToPay.getMoveLine().getPaymentScheduleLine());
                payVoucherElementToPay.setMoveLineGenerated(creditMoveLine);
            }
            ++moveLineNo2;
            Reconcile reconcile = null;
            if (i == 0) {
                this.log.debug("last loop");
                reconcile = this.reconcileService.createReconcile(debitMoveLine, creditMoveLine, amountToPay, true);
            } else {
                reconcile = this.reconcileService.createReconcile(debitMoveLine, creditMoveLine, amountToPay, false);
            }
            if (reconcile == null) continue;
            reconcileList.add(reconcile);
            remainingPaidAmount2 = remainingPaidAmount2.subtract(amountRemaining);
        }
        for (Reconcile reconcile : reconcileList) {
            this.reconcileService.confirmReconcile(reconcile, true);
        }
        if (remainingPaidAmount2.compareTo(BigDecimal.ZERO) > 0) {
            MoveLine moveLine = this.moveLineService.createMoveLine(move, partner, account, remainingPaidAmount2, false, this.appAccountService.getTodayDate(), moveLineNo2, null, null);
            move.getMoveLineList().add(moveLine);
            ++moveLineNo2;
            this.reconcileService.balanceCredit(moveLine);
        }
        this.log.debug("End createExcessPaymentWithAmount");
        return moveLineNo2;
    }

    @Override
    public int useExcessPaymentWithAmountConsolidated(List<MoveLine> creditMoveLines, BigDecimal remainingPaidAmount, Move move, int moveLineNo, Partner partner, Company company, Account account, LocalDate date, LocalDate dueDate) throws AxelorException {
        this.log.debug("In useExcessPaymentWithAmount");
        int moveLineNo2 = moveLineNo;
        BigDecimal remainingPaidAmount2 = remainingPaidAmount;
        ArrayList<Reconcile> reconcileList = new ArrayList<Reconcile>();
        int i = creditMoveLines.size();
        if (i != 0) {
            Query q = JPA.em().createQuery("select new map(ml.account, SUM(ml.amountRemaining)) FROM MoveLine as ml WHERE ml in ?1 group by ml.account");
            q.setParameter(1, creditMoveLines);
            List allMap = new ArrayList();
            allMap = q.getResultList();
            block0: for (Map map : allMap) {
                Account accountMap = (Account)((Object)map.values().toArray()[0]);
                BigDecimal amountMap = (BigDecimal)map.values().toArray()[1];
                BigDecimal amountDebit = amountMap.min(remainingPaidAmount2);
                if (amountDebit.compareTo(BigDecimal.ZERO) <= 0) continue;
                MoveLine debitMoveLine = this.moveLineService.createMoveLine(move, partner, accountMap, amountDebit, true, date, dueDate, moveLineNo2, null, null);
                move.getMoveLineList().add(debitMoveLine);
                ++moveLineNo2;
                for (MoveLine creditMoveLine : creditMoveLines) {
                    if (!creditMoveLine.getAccount().equals((Object)accountMap)) continue;
                    Reconcile reconcile = null;
                    --i;
                    if (amountDebit.compareTo(BigDecimal.ZERO) <= 0) continue block0;
                    BigDecimal amountToPay = amountDebit.min(creditMoveLine.getAmountRemaining());
                    reconcile = i == 0 ? this.reconcileService.createReconcile(debitMoveLine, creditMoveLine, amountToPay, true) : this.reconcileService.createReconcile(debitMoveLine, creditMoveLine, amountToPay, false);
                    if (reconcile == null) continue;
                    remainingPaidAmount2 = remainingPaidAmount2.subtract(amountToPay);
                    amountDebit = amountDebit.subtract(amountToPay);
                    reconcileList.add(reconcile);
                }
            }
            for (Reconcile reconcile : reconcileList) {
                this.reconcileService.confirmReconcile(reconcile, true);
            }
        }
        if (remainingPaidAmount2.compareTo(BigDecimal.ZERO) > 0) {
            MoveLine debitmoveLine = this.moveLineService.createMoveLine(move, partner, account, remainingPaidAmount2, true, date, dueDate, moveLineNo2, null, null);
            move.getMoveLineList().add(debitmoveLine);
            ++moveLineNo2;
        }
        this.log.debug("End useExcessPaymentWithAmount");
        return moveLineNo2;
    }

    @Override
    public BigDecimal getAmountRemainingFromPaymentMove(PaymentScheduleLine psl) {
        BigDecimal amountRemaining = BigDecimal.ZERO;
        if (psl.getAdvanceOrPaymentMove() != null && psl.getAdvanceOrPaymentMove().getMoveLineList() != null) {
            for (MoveLine moveLine : psl.getAdvanceOrPaymentMove().getMoveLineList()) {
                if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue()) continue;
                amountRemaining = amountRemaining.add(moveLine.getCredit());
            }
        }
        return amountRemaining;
    }

    @Override
    public BigDecimal getAmountRemainingFromPaymentMove(Invoice invoice) {
        BigDecimal amountRemaining = BigDecimal.ZERO;
        if (invoice.getPaymentMove() != null && invoice.getPaymentMove().getMoveLineList() != null) {
            for (MoveLine moveLine : invoice.getPaymentMove().getMoveLineList()) {
                if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue()) continue;
                amountRemaining = amountRemaining.add(moveLine.getCredit());
            }
        }
        return amountRemaining;
    }
}

