/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.paymentvoucher;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayVoucherElementToPay;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.repo.PaymentVoucherRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.payment.paymentvoucher.PayVoucherElementToPayService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherConfirmService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherSequenceService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentVoucherCreateService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveToolService moveToolService;
    protected PayVoucherElementToPayService payVoucherElementToPayService;
    protected PaymentVoucherConfirmService paymentVoucherConfirmService;
    protected PaymentVoucherSequenceService paymentVoucherSequenceService;
    protected PaymentVoucherRepository paymentVoucherRepository;
    protected AppAccountService appAccountService;

    @Inject
    public PaymentVoucherCreateService(AppAccountService appAccountService, MoveToolService moveToolService, PayVoucherElementToPayService payVoucherElementToPayService, PaymentVoucherConfirmService paymentVoucherConfirmService, PaymentVoucherSequenceService paymentVoucherSequenceService, PaymentVoucherRepository paymentVoucherRepository) {
        this.moveToolService = moveToolService;
        this.payVoucherElementToPayService = payVoucherElementToPayService;
        this.paymentVoucherConfirmService = paymentVoucherConfirmService;
        this.paymentVoucherSequenceService = paymentVoucherSequenceService;
        this.paymentVoucherRepository = paymentVoucherRepository;
        this.appAccountService = appAccountService;
    }

    @Transactional(rollbackOn={Exception.class})
    public PaymentVoucher createPaymentVoucherIPO(Invoice invoice, LocalDate date, BigDecimal amount, PaymentMode paymentMode) throws AxelorException {
        MoveLine customerMoveLine = this.moveToolService.getCustomerMoveLineByQuery(invoice);
        this.log.debug("Cr\u00e9ation d'une saisie paiement par TIP ou TIP ch\u00e8que - facture : {}", (Object)invoice.getInvoiceId());
        this.log.debug("Cr\u00e9ation d'une saisie paiement par TIP ou TIP ch\u00e8que - mode de paiement : {}", (Object)paymentMode.getCode());
        this.log.debug("Cr\u00e9ation d'une saisie paiement par TIP ou TIP ch\u00e8que - soci\u00e9t\u00e9 : {}", (Object)invoice.getCompany().getName());
        this.log.debug("Cr\u00e9ation d'une saisie paiement par TIP ou TIP ch\u00e8que - tiers payeur : {}", (Object)invoice.getPartner().getName());
        PaymentVoucher paymentVoucher = this.createPaymentVoucher(invoice.getCompany(), null, paymentMode, date, invoice.getPartner(), amount, null, invoice, null, null, null);
        paymentVoucher.setHasAutoInput(true);
        ArrayList<PayVoucherElementToPay> lines = new ArrayList<PayVoucherElementToPay>();
        lines.add(this.payVoucherElementToPayService.createPayVoucherElementToPay(paymentVoucher, 1, invoice, customerMoveLine, customerMoveLine.getDebit(), customerMoveLine.getAmountRemaining(), amount));
        paymentVoucher.setPayVoucherElementToPayList(lines);
        this.paymentVoucherRepository.save((Model)((Object)paymentVoucher));
        this.paymentVoucherConfirmService.confirmPaymentVoucher(paymentVoucher);
        return paymentVoucher;
    }

    public PaymentVoucher createPaymentVoucher(Company company, User user, PaymentMode paymentMode, LocalDate date, Partner partner, BigDecimal amount, MoveLine moveLine, Invoice invoiceToPay, MoveLine rejectToPay, PaymentScheduleLine scheduleToPay, PaymentSchedule paymentScheduleToPay) throws AxelorException {
        BigDecimal amount2;
        this.log.debug("\n\n createPaymentVoucher ....");
        LocalDate date2 = date;
        if (date2 == null) {
            date2 = this.appAccountService.getTodayDate();
        }
        if ((amount2 = amount) == null) {
            amount2 = BigDecimal.ZERO;
        }
        PaymentVoucher paymentVoucher = new PaymentVoucher();
        if (company != null && paymentMode != null && partner != null) {
            paymentVoucher.setCompany(company);
            paymentVoucher.setUser(user);
            paymentVoucher.setPaymentDate(date2);
            paymentVoucher.setPaymentMode(paymentMode);
            paymentVoucher.setPartner(partner);
            paymentVoucher.setPaidAmount(amount2);
            paymentVoucher.setMoveLine(moveLine);
            this.paymentVoucherSequenceService.setReference(paymentVoucher);
            return paymentVoucher;
        }
        return null;
    }
}

