/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.AccountClearance;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.AccountClearanceRepository;
import com.axelor.apps.account.service.AccountClearanceService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.util.HashMap;

@Singleton
public class AccountClearanceController {
    public void getExcessPayment(ActionRequest request, ActionResponse response) {
        AccountClearance accountClearance = (AccountClearance)((Object)request.getContext().asType(AccountClearance.class));
        try {
            ((AccountClearanceService)Beans.get(AccountClearanceService.class)).setExcessPayment(accountClearance);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateAccountClearance(ActionRequest request, ActionResponse response) {
        AccountClearanceRepository accountClearanceRepo = (AccountClearanceRepository)((Object)Beans.get(AccountClearanceRepository.class));
        AccountClearanceService accountClearanceService = (AccountClearanceService)Beans.get(AccountClearanceService.class);
        AccountClearance accountClearance = (AccountClearance)((Object)request.getContext().asType(AccountClearance.class));
        accountClearance = (AccountClearance)((Object)accountClearanceRepo.find(accountClearance.getId()));
        try {
            accountClearanceService.validateAccountClearance(accountClearance);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showAccountClearanceMoveLines(ActionRequest request, ActionResponse response) {
        HashMap<String, String> viewMap = new HashMap<String, String>();
        Context context = request.getContext();
        viewMap.put("title", I18n.get((String)"Move lines generated"));
        viewMap.put("resource", MoveLine.class.getName());
        viewMap.put("domain", "self.accountClearance.id = " + context.get((Object)"id"));
        response.setView(viewMap);
    }
}

