/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.service.AccountService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.math.BigDecimal;

@Singleton
public class AccountController {
    public void computeBalance(ActionRequest request, ActionResponse response) {
        try {
            Account account = (Account)((Object)request.getContext().asType(Account.class));
            if (account.getId() == null) {
                return;
            }
            account = (Account)((Object)((AccountRepository)((Object)Beans.get(AccountRepository.class))).find(account.getId()));
            BigDecimal balance = ((AccountService)Beans.get(AccountService.class)).computeBalance(account, AccountService.BALANCE_TYPE_DEBIT_BALANCE);
            if (balance.compareTo(BigDecimal.ZERO) >= 0) {
                response.setAttr("$balanceBtn", "title", (Object)I18n.get((String)"Debit balance"));
            } else {
                balance = balance.multiply(new BigDecimal(-1));
                response.setAttr("$balanceBtn", "title", (Object)I18n.get((String)"Credit balance"));
            }
            response.setValue("$balanceBtn", (Object)balance);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

