/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.repo.DebtRecoveryRepository;
import com.axelor.apps.account.service.debtrecovery.DebtRecoveryActionService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class DebtRecoveryController {
    public void runDebtRecovery(ActionRequest request, ActionResponse response) {
        DebtRecovery debtRecovery = (DebtRecovery)((Object)request.getContext().asType(DebtRecovery.class));
        debtRecovery = (DebtRecovery)((Object)((DebtRecoveryRepository)((Object)Beans.get(DebtRecoveryRepository.class))).find(debtRecovery.getId()));
        try {
            if (debtRecovery.getAccountingSituation() == null) {
                throw new AxelorException(1, I18n.get((String)"There's no accounting situation."));
            }
            debtRecovery.setDebtRecoveryMethodLine(debtRecovery.getWaitDebtRecoveryMethodLine());
            ((DebtRecoveryActionService)Beans.get(DebtRecoveryActionService.class)).runManualAction(debtRecovery);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

