/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.DepositSlip;
import com.axelor.apps.account.db.repo.DepositSlipRepository;
import com.axelor.apps.account.service.DepositSlipService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class DepositSlipController {
    public void loadPayments(ActionRequest request, ActionResponse response) {
        DepositSlip depositSlip = (DepositSlip)((Object)request.getContext().asType(DepositSlip.class));
        depositSlip = (DepositSlip)((Object)((DepositSlipRepository)((Object)Beans.get(DepositSlipRepository.class))).find(depositSlip.getId()));
        DepositSlipService depositSlipService = (DepositSlipService)Beans.get(DepositSlipService.class);
        try {
            depositSlipService.loadPayments(depositSlip);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void publish(ActionRequest request, ActionResponse response) {
        DepositSlip depositSlip = (DepositSlip)((Object)request.getContext().asType(DepositSlip.class));
        depositSlip = (DepositSlip)((Object)((DepositSlipRepository)((Object)Beans.get(DepositSlipRepository.class))).find(depositSlip.getId()));
        DepositSlipService depositSlipService = (DepositSlipService)Beans.get(DepositSlipService.class);
        try {
            String fileLink = depositSlipService.publish(depositSlip);
            response.setReload(true);
            response.setView(ActionView.define((String)depositSlipService.getFilename(depositSlip)).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

