/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.FixedAsset;
import com.axelor.apps.account.db.repo.FixedAssetRepository;
import com.axelor.apps.account.service.FixedAssetService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.LocalDate;

@Singleton
public class FixedAssetController {
    public void computeDepreciation(ActionRequest request, ActionResponse response) {
        FixedAsset fixedAsset = (FixedAsset)((Object)request.getContext().asType(FixedAsset.class));
        try {
            if (fixedAsset.getGrossValue().compareTo(BigDecimal.ZERO) > 0) {
                if (!fixedAsset.getFixedAssetLineList().isEmpty()) {
                    fixedAsset.getFixedAssetLineList().clear();
                }
                fixedAsset = ((FixedAssetService)Beans.get(FixedAssetService.class)).generateAndcomputeLines(fixedAsset);
            } else {
                fixedAsset.getFixedAssetLineList().clear();
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setValue("residualValue", (Object)fixedAsset.getGrossValue());
        response.setValue("fixedAssetLineList", fixedAsset.getFixedAssetLineList());
    }

    public void disposal(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        if (context.get((Object)"disposalDate") == null || context.get((Object)"disposalAmount") == null) {
            return;
        }
        LocalDate disposalDate = (LocalDate)context.get((Object)"disposalDate");
        BigDecimal disposalAmount = new BigDecimal(context.get((Object)"disposalAmount").toString());
        Long fixedAssetId = Long.valueOf(context.get((Object)"_id").toString());
        FixedAsset fixedAsset = (FixedAsset)((Object)((FixedAssetRepository)((Object)Beans.get(FixedAssetRepository.class))).find(fixedAssetId));
        ((FixedAssetService)Beans.get(FixedAssetService.class)).disposal(disposalDate, disposalAmount, fixedAsset);
        response.setCanClose(true);
    }

    public void createAnalyticDistributionWithTemplate(ActionRequest request, ActionResponse response) {
        try {
            FixedAsset fixedAsset = (FixedAsset)((Object)request.getContext().asType(FixedAsset.class));
            ((FixedAssetService)Beans.get(FixedAssetService.class)).updateAnalytic(fixedAsset);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

