/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCancelService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Singleton
public class InvoicePaymentController {
    public void cancelInvoicePayment(ActionRequest request, ActionResponse response) {
        InvoicePayment invoicePayment = (InvoicePayment)((Object)request.getContext().asType(InvoicePayment.class));
        invoicePayment = (InvoicePayment)((Object)((InvoicePaymentRepository)((Object)Beans.get(InvoicePaymentRepository.class))).find(invoicePayment.getId()));
        try {
            ((InvoicePaymentCancelService)Beans.get(InvoicePaymentCancelService.class)).cancel(invoicePayment);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void filterPaymentMode(ActionRequest request, ActionResponse response) {
        Map partialInvoice = (Map)request.getContext().get((Object)"_invoice");
        Invoice invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(Long.valueOf(partialInvoice.get("id").toString())));
        PaymentMode paymentMode = invoice.getPaymentMode();
        if (invoice != null && paymentMode != null && paymentMode.getInOutSelect() != null) {
            response.setAttr("paymentMode", "domain", (Object)("self.inOutSelect = " + paymentMode.getInOutSelect()));
        }
    }

    public void filterBankDetails(ActionRequest request, ActionResponse response) {
        InvoicePayment invoicePayment = (InvoicePayment)((Object)request.getContext().asType(InvoicePayment.class));
        Map partialInvoice = (Map)request.getContext().get((Object)"_invoice");
        Invoice invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(((Integer)partialInvoice.get("id")).longValue()));
        Company company = invoice.getCompany();
        List<BankDetails> bankDetailsList = ((InvoicePaymentToolService)Beans.get(InvoicePaymentToolService.class)).findCompatibleBankDetails(company, invoicePayment);
        if (bankDetailsList.isEmpty()) {
            response.setAttr("companyBankDetails", "domain", (Object)"self.id IN (0)");
        } else {
            String idList = StringTool.getIdListString(bankDetailsList);
            response.setAttr("companyBankDetails", "domain", (Object)("self.id IN (" + idList + ")"));
        }
    }

    public void fillBankDetails(ActionRequest request, ActionResponse response) throws AxelorException {
        InvoicePayment invoicePayment = (InvoicePayment)((Object)request.getContext().asType(InvoicePayment.class));
        Map partialInvoice = (Map)request.getContext().get((Object)"_invoice");
        Invoice invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(((Integer)partialInvoice.get("id")).longValue()));
        PaymentMode paymentMode = invoicePayment.getPaymentMode();
        Company company = invoice.getCompany();
        List<BankDetails> bankDetailsList = ((InvoicePaymentToolService)Beans.get(InvoicePaymentToolService.class)).findCompatibleBankDetails(company, invoicePayment);
        if (bankDetailsList.size() == 1) {
            response.setValue("companyBankDetails", (Object)bankDetailsList.get(0));
        } else {
            response.setValue("companyBankDetails", null);
        }
        Partner partner = invoice.getPartner();
        if (company == null) {
            return;
        }
        if (partner != null) {
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        }
        BankDetails defaultBankDetails = ((BankDetailsService)Beans.get(BankDetailsService.class)).getDefaultCompanyBankDetails(company, paymentMode, partner, null);
        response.setValue("bankDetails", (Object)defaultBankDetails);
    }

    public void validateMassPayment(ActionRequest request, ActionResponse response) {
        try {
            InvoicePayment invoicePayment = (InvoicePayment)((Object)request.getContext().asType(InvoicePayment.class));
            if (!ObjectUtils.isEmpty((Object)request.getContext().get((Object)"_selectedInvoices"))) {
                List invoiceIdList = Lists.transform((List)((List)request.getContext().get((Object)"_selectedInvoices")), (Function)new Function<Object, Long>(){

                    @Nullable
                    public Long apply(@Nullable Object input) {
                        return Long.parseLong(input.toString());
                    }
                });
                ((InvoicePaymentCreateService)Beans.get(InvoicePaymentCreateService.class)).createMassInvoicePayment(invoiceIdList, invoicePayment.getPaymentMode(), invoicePayment.getCompanyBankDetails(), invoicePayment.getPaymentDate(), invoicePayment.getBankDepositDate(), invoicePayment.getChequeNumber());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }
}

