/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.extract.ExtractContextMoveService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Singleton
public class MoveController {
    public void validate(ActionRequest request, ActionResponse response) {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        move = (Move)((Object)((MoveRepository)((Object)Beans.get(MoveRepository.class))).find(move.getId()));
        try {
            ((MoveService)Beans.get(MoveService.class)).getMoveValidateService().validate(move);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void getPeriod(ActionRequest request, ActionResponse response) {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        try {
            if (move.getDate() != null && move.getCompany() != null) {
                response.setValue("period", (Object)((PeriodService)Beans.get(PeriodService.class)).getActivePeriod(move.getDate(), move.getCompany(), 1));
            } else {
                response.setValue("period", null);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateReverse(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            Move move = (Move)((Object)context.asType(Move.class));
            move = (Move)((Object)((MoveRepository)((Object)Beans.get(MoveRepository.class))).find(move.getId()));
            Map<String, Object> assistantMap = ((ExtractContextMoveService)Beans.get(ExtractContextMoveService.class)).getMapFromMoveWizardGenerateReverseForm(context);
            Move newMove = ((MoveService)Beans.get(MoveService.class)).generateReverse(move, assistantMap);
            if (newMove != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Account move")).model("com.axelor.apps.account.db.Move").param("forceEdit", "true").context("_showRecord", (Object)newMove.getId().toString()).map());
                response.setCanClose(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateMultipleMoves(ActionRequest request, ActionResponse response) {
        List moveIds = (List)request.getContext().get((Object)"_ids");
        if (moveIds != null && !moveIds.isEmpty()) {
            List moveList = ((MoveRepository)((Object)Beans.get(MoveRepository.class))).all().filter("self.id in ?1 AND self.statusSelect NOT IN (?2, ?3)", new Object[]{moveIds, 3, 4}).order("date").fetch();
            if (!moveList.isEmpty()) {
                boolean error = ((MoveService)Beans.get(MoveService.class)).getMoveValidateService().validateMultiple(moveList);
                if (error) {
                    response.setFlash(I18n.get((String)"Error in move validation, please check the log"));
                } else {
                    response.setFlash(I18n.get((String)"Moves validated successfully"));
                    response.setReload(true);
                }
            } else {
                response.setFlash(I18n.get((String)"Please select 'Draft' or 'Simulated' moves"));
            }
        } else {
            response.setFlash(I18n.get((String)"Please select 'Draft' or 'Simulated' moves"));
        }
    }

    public void deleteMove(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Move move = (Move)((Object)request.getContext().asType(Move.class));
            MoveRepository moveRepository = (MoveRepository)((Object)Beans.get(MoveRepository.class));
            move = (Move)((Object)moveRepository.find(move.getId()));
            move = (Move)((Object)moveRepository.find(move.getId()));
            this.removeOneMove(move, response);
            if (!move.getStatusSelect().equals(3)) {
                response.setView(ActionView.define((String)"Moves").model(Move.class.getName()).add("grid", "move-grid").add("form", "move-form").map());
                response.setCanClose(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    protected void removeOneMove(Move move, ActionResponse response) throws Exception {
        MoveService moveService = (MoveService)Beans.get(MoveService.class);
        if (move.getStatusSelect().equals(1)) {
            moveService.getMoveRemoveService().deleteMove(move);
            response.setFlash(I18n.get((String)"Move(s) has been removed successfully"));
        } else if (move.getStatusSelect().equals(2)) {
            moveService.getMoveRemoveService().archiveDaybookMove(move);
            response.setFlash(I18n.get((String)"Move(s) has been archived successfully"));
        } else if (move.getStatusSelect().equals(4)) {
            moveService.getMoveRemoveService().archiveMove(move);
            response.setFlash(I18n.get((String)"Move(s) has been archived successfully"));
        }
    }

    public void deleteMultipleMoves(ActionRequest request, ActionResponse response) {
        try {
            List moveIds = (List)request.getContext().get((Object)"_ids");
            if (!moveIds.isEmpty()) {
                List moveList = ((MoveRepository)((Object)Beans.get(MoveRepository.class))).all().filter("self.id in ?1 AND self.statusSelect in (?2,?3,?4) AND (self.archived = false or self.archived = null)", new Object[]{moveIds, 1, 2, 4}).fetch();
                if (!moveList.isEmpty()) {
                    if (moveList.size() == 1) {
                        this.removeOneMove((Move)((Object)moveList.get(0)), response);
                    } else {
                        int errorNB = ((MoveService)Beans.get(MoveService.class)).getMoveRemoveService().deleteMultiple(moveList);
                        if (errorNB > 0) {
                            response.setFlash(String.format(I18n.get((String)"%d moves couldn't be deleted or archived, please check the logs."), errorNB));
                        } else {
                            response.setFlash(I18n.get((String)"Move(s) has been removed or archived successfully"));
                            response.setReload(true);
                        }
                    }
                } else {
                    response.setFlash(I18n.get((String)"Please select 'Draft' or 'Daybook' or 'Canceled' moves"));
                }
            } else {
                response.setFlash(I18n.get((String)"Please select 'Draft' or 'Daybook' or 'Canceled' moves"));
            }
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void printMove(ActionRequest request, ActionResponse response) throws AxelorException {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        move = (Move)((Object)((MoveRepository)((Object)Beans.get(MoveRepository.class))).find(move.getId()));
        String moveName = move.getReference().toString();
        String fileLink = ReportFactory.createReport((String)"AccountMove.rptdesign", (String)(moveName + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("moveId", (Object)move.getId()).generate().getFileLink();
        response.setView(ActionView.define((String)moveName).add("html", fileLink).map());
    }

    public void showMoveLines(ActionRequest request, ActionResponse response) {
        ActionView.ActionViewBuilder actionViewBuilder = ActionView.define((String)I18n.get((String)"Move Lines"));
        actionViewBuilder.model(MoveLine.class.getName());
        actionViewBuilder.add("grid", "move-line-grid");
        actionViewBuilder.add("form", "move-line-form");
        actionViewBuilder.param("search-filters", "move-line-filters");
        if (request.getContext().get((Object)"_accountingReportId") != null) {
            Long accountingReportId = Long.valueOf(request.getContext().get((Object)"_accountingReportId").toString());
            actionViewBuilder.domain("self.move.accountingReport.id = " + accountingReportId);
        }
        response.setView(actionViewBuilder.map());
    }

    public void updateInDayBookMode(ActionRequest request, ActionResponse response) {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        move = (Move)((Object)((MoveRepository)((Object)Beans.get(MoveRepository.class))).find(move.getId()));
        try {
            if (move.getStatusSelect() == 2) {
                ((MoveService)Beans.get(MoveService.class)).getMoveValidateService().updateInDayBookMode(move);
                response.setReload(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeTotals(ActionRequest request, ActionResponse response) {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        Map<String, Object> values = ((MoveService)Beans.get(MoveService.class)).computeTotals(move);
        response.setValues(values);
    }

    public void autoTaxLineGenerate(ActionRequest request, ActionResponse response) throws AxelorException {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        if (move.getMoveLineList() != null && !move.getMoveLineList().isEmpty() && move.getStatusSelect().equals(1)) {
            ((MoveService)Beans.get(MoveService.class)).getMoveLineService().autoTaxLineGenerate(move);
            response.setValue("moveLineList", move.getMoveLineList());
        }
    }

    public void filterPartner(ActionRequest request, ActionResponse response) {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        if (move != null) {
            String domain = ((MoveService)Beans.get(MoveService.class)).filterPartner(move);
            response.setAttr("partner", "domain", (Object)domain);
        }
    }

    public void isHiddenMoveLineListViewer(ActionRequest request, ActionResponse response) {
        Move move = (Move)((Object)request.getContext().asType(Move.class));
        boolean isHidden = true;
        try {
            if (move.getMoveLineList() != null && move.getStatusSelect() < 3) {
                for (MoveLine moveLine : move.getMoveLineList()) {
                    if (moveLine.getAmountPaid().compareTo(BigDecimal.ZERO) <= 0 && moveLine.getReconcileGroup() == null) continue;
                    isHidden = false;
                }
            }
            response.setAttr("$reconcileTags", "hidden", (Object)isHidden);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkRemoveLines(ActionRequest request, ActionResponse response) {
        try {
            Move moveView = (Move)((Object)request.getContext().asType(Move.class));
            Move moveBD = (Move)((Object)((MoveRepository)((Object)Beans.get(MoveRepository.class))).find(moveView.getId()));
            ArrayList<String> moveLineReconciledAndRemovedNameList = new ArrayList<String>();
            for (MoveLine moveLineBD : moveBD.getMoveLineList()) {
                if (moveView.getMoveLineList().contains((Object)moveLineBD) || moveLineBD.getReconcileGroup() == null) continue;
                moveLineReconciledAndRemovedNameList.add(moveLineBD.getName());
            }
            if (moveLineReconciledAndRemovedNameList != null && !moveLineReconciledAndRemovedNameList.isEmpty()) {
                response.setError(String.format(I18n.get((String)"The move lines %s are reconciled and should not have been removed."), ((Object)moveLineReconciledAndRemovedNameList).toString()));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

