/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveTemplate;
import com.axelor.apps.account.db.MoveTemplateLine;
import com.axelor.apps.account.db.MoveTemplateType;
import com.axelor.apps.account.db.repo.MoveTemplateRepository;
import com.axelor.apps.account.db.repo.MoveTemplateTypeRepository;
import com.axelor.apps.account.service.move.MoveTemplateService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MoveTemplateController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void checkValidity(ActionRequest request, ActionResponse response) {
        MoveTemplate moveTemplate = (MoveTemplate)((Object)request.getContext().asType(MoveTemplate.class));
        moveTemplate = (MoveTemplate)((Object)((MoveTemplateRepository)((Object)Beans.get(MoveTemplateRepository.class))).find(moveTemplate.getId()));
        boolean valid = ((MoveTemplateService)Beans.get(MoveTemplateService.class)).checkValidity(moveTemplate);
        if (valid) {
            response.setReload(true);
        } else {
            response.setFlash(I18n.get((String)"Template move is not balanced"));
        }
    }

    public void generateMove(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            HashMap moveTemplateTypeMap = (HashMap)context.get((Object)"moveTemplateType");
            MoveTemplateType moveTemplateType = (MoveTemplateType)((Object)((MoveTemplateTypeRepository)((Object)Beans.get(MoveTemplateTypeRepository.class))).find(Long.parseLong(moveTemplateTypeMap.get("id").toString())));
            HashMap moveTemplateMap = (HashMap)context.get((Object)"moveTemplate");
            MoveTemplate moveTemplate = null;
            if (moveTemplateType.getTypeSelect() == 1) {
                moveTemplate = (MoveTemplate)((Object)((MoveTemplateRepository)((Object)Beans.get(MoveTemplateRepository.class))).find(Long.parseLong(moveTemplateMap.get("id").toString())));
            }
            List dataList = (List)context.get((Object)"dataInputList");
            List moveTemplateList = (List)context.get((Object)"moveTemplateSet");
            LocalDate moveDate = null;
            if (moveTemplateType.getTypeSelect() == 2) {
                moveDate = LocalDate.parse((String)context.get((Object)"moveDate"), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
            LOG.debug("MoveTemplate : {}", (Object)moveTemplate);
            LOG.debug("Data inputlist : {}", (Object)dataList);
            LOG.debug("Data inputlist : {}", (Object)moveTemplateList);
            if (dataList != null && !dataList.isEmpty() || moveTemplateList != null && !moveTemplateList.isEmpty()) {
                List<Long> moveList = ((MoveTemplateService)Beans.get(MoveTemplateService.class)).generateMove(moveTemplateType, moveTemplate, dataList, moveDate, moveTemplateList);
                if (moveList != null && !moveList.isEmpty()) {
                    response.setView(ActionView.define((String)I18n.get((String)"Generated moves")).model(Move.class.getName()).add("grid", "move-grid").add("form", "move-form").domain("self.id in (" + Joiner.on((String)",").join(moveList) + ")").map());
                }
            } else {
                response.setFlash(I18n.get((String)"Please fill input lines"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setIsValid(ActionRequest request, ActionResponse response) {
        MoveTemplate moveTemplate = (MoveTemplate)((Object)request.getContext().asType(MoveTemplate.class));
        if (moveTemplate.getIsValid().booleanValue()) {
            boolean isValid = true;
            for (MoveTemplateLine line : moveTemplate.getMoveTemplateLineList()) {
                if (line.getIsValid().booleanValue()) continue;
                isValid = false;
            }
            if (!isValid) {
                response.setValue("isValid", (Object)false);
            }
        }
    }
}

