/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.repo.PaymentScheduleRepository;
import com.axelor.apps.account.service.IrrecoverableService;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Strings;
import com.google.inject.Singleton;

@Singleton
public class PaymentScheduleController {
    public void validate(ActionRequest request, ActionResponse response) {
        PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
        paymentSchedule = (PaymentSchedule)((Object)((PaymentScheduleRepository)((Object)Beans.get(PaymentScheduleRepository.class))).find(paymentSchedule.getId()));
        try {
            ((PaymentScheduleService)Beans.get(PaymentScheduleService.class)).validatePaymentSchedule(paymentSchedule);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
        paymentSchedule = (PaymentSchedule)((Object)((PaymentScheduleRepository)((Object)Beans.get(PaymentScheduleRepository.class))).find(paymentSchedule.getId()));
        try {
            ((PaymentScheduleService)Beans.get(PaymentScheduleService.class)).toCancelPaymentSchedule(paymentSchedule);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void paymentScheduleScheduleId(ActionRequest request, ActionResponse response) {
        try {
            PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
            ((PaymentScheduleService)Beans.get(PaymentScheduleService.class)).checkTotalLineAmount(paymentSchedule);
            if (Strings.isNullOrEmpty((String)paymentSchedule.getPaymentScheduleSeq())) {
                String num = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("paymentSchedule", paymentSchedule.getCompany());
                if (Strings.isNullOrEmpty((String)num)) {
                    response.setError(String.format(I18n.get((String)"You must configure a timetable sequence for the company %s"), paymentSchedule.getCompany().getName()));
                } else {
                    response.setValue("paymentScheduleSeq", (Object)num);
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void fillCompanyBankDetails(ActionRequest request, ActionResponse response) throws AxelorException {
        PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
        PaymentMode paymentMode = paymentSchedule.getPaymentMode();
        Company company = paymentSchedule.getCompany();
        Partner partner = paymentSchedule.getPartner();
        if (company == null) {
            return;
        }
        if (partner != null) {
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        }
        BankDetails defaultBankDetails = ((BankDetailsService)Beans.get(BankDetailsService.class)).getDefaultCompanyBankDetails(company, paymentMode, partner, null);
        response.setValue("companyBankDetails", (Object)defaultBankDetails);
    }

    public void fillPartnerBankDetails(ActionRequest request, ActionResponse response) {
        PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
        Partner partner = paymentSchedule.getPartner();
        if (partner != null) {
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        }
        BankDetails defaultBankDetails = ((PartnerService)Beans.get(PartnerService.class)).getDefaultBankDetails(partner);
        response.setValue("bankDetails", (Object)defaultBankDetails);
    }

    public void createPaymentScheduleLines(ActionRequest request, ActionResponse response) {
        PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
        paymentSchedule = (PaymentSchedule)((Object)((PaymentScheduleRepository)((Object)Beans.get(PaymentScheduleRepository.class))).find(paymentSchedule.getId()));
        ((PaymentScheduleService)Beans.get(PaymentScheduleService.class)).createPaymentScheduleLines(paymentSchedule);
        response.setReload(true);
    }

    public void passInIrrecoverable(ActionRequest request, ActionResponse response) {
        PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
        paymentSchedule = (PaymentSchedule)((Object)((PaymentScheduleRepository)((Object)Beans.get(PaymentScheduleRepository.class))).find(paymentSchedule.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).passInIrrecoverable(paymentSchedule);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void notPassInIrrecoverable(ActionRequest request, ActionResponse response) {
        PaymentSchedule paymentSchedule = (PaymentSchedule)((Object)request.getContext().asType(PaymentSchedule.class));
        paymentSchedule = (PaymentSchedule)((Object)((PaymentScheduleRepository)((Object)Beans.get(PaymentScheduleRepository.class))).find(paymentSchedule.getId()));
        try {
            ((IrrecoverableService)Beans.get(IrrecoverableService.class)).notPassInIrrecoverable(paymentSchedule);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

