/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.service.PeriodServiceAccount;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;

public class PeriodController {
    public void searchPeriodMoves(ActionRequest request, ActionResponse response) {
        try {
            Period period = (Period)request.getContext().asType(Period.class);
            period = (Period)((PeriodRepository)Beans.get(PeriodRepository.class)).find(period.getId());
            Long moveCount = ((PeriodServiceAccount)Beans.get(PeriodServiceAccount.class)).getMoveListToValidateQuery(period).count();
            if (moveCount > 0L) {
                response.setView(ActionView.define((String)"Moves to validate").model(Period.class.getName()).add("form", "period-moves-to-validate-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").context("_showRecord", (Object)period.getId()).map());
            } else {
                ((PeriodService)Beans.get(PeriodService.class)).close(period);
                response.setReload(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void continueClose(ActionRequest request, ActionResponse response) {
        try {
            Period period = (Period)request.getContext().asType(Period.class);
            period = (Period)((PeriodRepository)Beans.get(PeriodRepository.class)).find(period.getId());
            ((PeriodService)Beans.get(PeriodService.class)).close(period);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }
}

