/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.SubrogationRelease;
import com.axelor.apps.account.db.repo.SubrogationReleaseRepository;
import com.axelor.apps.account.service.SubrogationReleaseService;
import com.axelor.apps.base.db.Company;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class SubrogationReleaseController {
    public void retrieveInvoices(ActionRequest request, ActionResponse response) {
        try {
            SubrogationRelease subrogationRelease = (SubrogationRelease)((Object)request.getContext().asType(SubrogationRelease.class));
            Company company = subrogationRelease.getCompany();
            List<Invoice> invoiceList = ((SubrogationReleaseService)Beans.get(SubrogationReleaseService.class)).retrieveInvoices(company);
            response.setValue("invoiceSet", invoiceList);
        }
        catch (Exception e) {
            response.setError(e.getMessage());
            TraceBackService.trace((Throwable)e);
        }
    }

    public void transmitRelease(ActionRequest request, ActionResponse response) {
        try {
            SubrogationRelease subrogationRelease = (SubrogationRelease)((Object)request.getContext().asType(SubrogationRelease.class));
            subrogationRelease = (SubrogationRelease)((Object)((SubrogationReleaseRepository)((Object)Beans.get(SubrogationReleaseRepository.class))).find(subrogationRelease.getId()));
            ((SubrogationReleaseService)Beans.get(SubrogationReleaseService.class)).transmitRelease(subrogationRelease);
            response.setReload(true);
        }
        catch (Exception e) {
            response.setError(e.getMessage());
            TraceBackService.trace((Throwable)e);
        }
    }

    public void printToPDF(ActionRequest request, ActionResponse response) {
        try {
            SubrogationRelease subrogationRelease = (SubrogationRelease)((Object)request.getContext().asType(SubrogationRelease.class));
            String name = String.format("%s %s", I18n.get((String)"Subrogation release"), subrogationRelease.getSequenceNumber());
            String fileLink = ((SubrogationReleaseService)Beans.get(SubrogationReleaseService.class)).printToPDF(subrogationRelease, name);
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
            response.setReload(true);
        }
        catch (Exception e) {
            response.setError(e.getMessage());
            TraceBackService.trace((Throwable)e);
        }
    }

    public void exportToCSV(ActionRequest request, ActionResponse response) {
        try {
            SubrogationRelease subrogationRelease = (SubrogationRelease)((Object)request.getContext().asType(SubrogationRelease.class));
            ((SubrogationReleaseService)Beans.get(SubrogationReleaseService.class)).exportToCSV(subrogationRelease);
            response.setReload(true);
        }
        catch (Exception e) {
            response.setError(e.getMessage());
            TraceBackService.trace((Throwable)e);
        }
    }

    public void enterReleaseInTheAccounts(ActionRequest request, ActionResponse response) {
        try {
            SubrogationRelease subrogationRelease = (SubrogationRelease)((Object)request.getContext().asType(SubrogationRelease.class));
            subrogationRelease = (SubrogationRelease)((Object)((SubrogationReleaseRepository)((Object)Beans.get(SubrogationReleaseRepository.class))).find(subrogationRelease.getId()));
            ((SubrogationReleaseService)Beans.get(SubrogationReleaseService.class)).enterReleaseInTheAccounts(subrogationRelease);
            response.setReload(true);
        }
        catch (Exception e) {
            response.setError(e.getMessage());
            TraceBackService.trace((Throwable)e);
        }
    }

    public void displayMoveLines(ActionRequest request, ActionResponse response) {
        try {
            SubrogationRelease subrogationRelease = (SubrogationRelease)((Object)request.getContext().asType(SubrogationRelease.class));
            ArrayList<Long> moveLineIdList = new ArrayList<Long>();
            for (Move move : subrogationRelease.getMoveList()) {
                for (MoveLine moveLine : move.getMoveLineList()) {
                    moveLineIdList.add(moveLine.getId());
                }
            }
            response.setView(ActionView.define((String)"MoveLines").model(MoveLine.class.getName()).add("grid", "move-line-grid").add("form", "move-line-form").domain("self.id in (" + Joiner.on((String)",").join(moveLineIdList) + ")").map());
        }
        catch (Exception e) {
            response.setError(e.getMessage());
            TraceBackService.trace((Throwable)e);
        }
    }
}

