/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.InterbankCode;
import com.axelor.apps.account.db.PayerQualityConfigLine;
import com.axelor.apps.base.db.App;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_APP_ACCOUNT", indexes={@Index(columnList="transfer_and_direct_debit_interbank_code"), @Index(columnList="cheque_interbank_code")})
@Track(fields={@TrackField(name="transferAndDirectDebitInterbankCode", on={TrackEvent.UPDATE}), @TrackField(name="chequeInterbankCode", on={TrackEvent.UPDATE}), @TrackField(name="manageCustomerCredit", on={TrackEvent.UPDATE}), @TrackField(name="manageAnalyticAccounting", on={TrackEvent.UPDATE}), @TrackField(name="analyticDistributionTypeSelect", on={TrackEvent.UPDATE}), @TrackField(name="manageFactors", on={TrackEvent.UPDATE}), @TrackField(name="partnerBalConfigSelect", on={TrackEvent.UPDATE}), @TrackField(name="manageAdvancePaymentInvoice", on={TrackEvent.UPDATE}), @TrackField(name="paymentVouchersOnInvoice", on={TrackEvent.UPDATE})})
public class AppAccount
extends App {
    @Widget(title="Code list for rejects/return of Direct debit, Wire Transfers and IPO")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCode transferAndDirectDebitInterbankCode;
    @Widget(title="Code list for rejects/return of Cheques")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCode chequeInterbankCode;
    @Widget(title="Weight table (Payer quality)")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<PayerQualityConfigLine> payerQualityConfigLineList;
    @Widget(title="Manage customerCredit")
    private Boolean manageCustomerCredit = Boolean.FALSE;
    @Widget(title="Manage analytic accounting")
    private Boolean manageAnalyticAccounting = Boolean.FALSE;
    @Widget(title="Analytic distribution type", selection="account.general.analytic.distribution.type.select")
    private Integer analyticDistributionTypeSelect = 1;
    private Boolean manageFactors = Boolean.FALSE;
    @Widget(title="Partner balance viewer configuration", selection="account.partner.bal.config.select")
    private Integer partnerBalConfigSelect = 1;
    @Widget(title="Manage advance payment invoice")
    private Boolean manageAdvancePaymentInvoice = Boolean.TRUE;
    private Boolean paymentVouchersOnInvoice = Boolean.FALSE;
    @Widget(title="Activate passed for payment")
    private Boolean activatePassedForPayment = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public InterbankCode getTransferAndDirectDebitInterbankCode() {
        return this.transferAndDirectDebitInterbankCode;
    }

    public void setTransferAndDirectDebitInterbankCode(InterbankCode transferAndDirectDebitInterbankCode) {
        this.transferAndDirectDebitInterbankCode = transferAndDirectDebitInterbankCode;
    }

    public InterbankCode getChequeInterbankCode() {
        return this.chequeInterbankCode;
    }

    public void setChequeInterbankCode(InterbankCode chequeInterbankCode) {
        this.chequeInterbankCode = chequeInterbankCode;
    }

    public List<PayerQualityConfigLine> getPayerQualityConfigLineList() {
        return this.payerQualityConfigLineList;
    }

    public void setPayerQualityConfigLineList(List<PayerQualityConfigLine> payerQualityConfigLineList) {
        this.payerQualityConfigLineList = payerQualityConfigLineList;
    }

    public void addPayerQualityConfigLineListItem(PayerQualityConfigLine item) {
        if (this.getPayerQualityConfigLineList() == null) {
            this.setPayerQualityConfigLineList(new ArrayList<PayerQualityConfigLine>());
        }
        this.getPayerQualityConfigLineList().add(item);
    }

    public void removePayerQualityConfigLineListItem(PayerQualityConfigLine item) {
        if (this.getPayerQualityConfigLineList() == null) {
            return;
        }
        this.getPayerQualityConfigLineList().remove((Object)item);
    }

    public void clearPayerQualityConfigLineList() {
        if (this.getPayerQualityConfigLineList() != null) {
            this.getPayerQualityConfigLineList().clear();
        }
    }

    public Boolean getManageCustomerCredit() {
        return this.manageCustomerCredit == null ? Boolean.FALSE : this.manageCustomerCredit;
    }

    public void setManageCustomerCredit(Boolean manageCustomerCredit) {
        this.manageCustomerCredit = manageCustomerCredit;
    }

    public Boolean getManageAnalyticAccounting() {
        return this.manageAnalyticAccounting == null ? Boolean.FALSE : this.manageAnalyticAccounting;
    }

    public void setManageAnalyticAccounting(Boolean manageAnalyticAccounting) {
        this.manageAnalyticAccounting = manageAnalyticAccounting;
    }

    public Integer getAnalyticDistributionTypeSelect() {
        return this.analyticDistributionTypeSelect == null ? 0 : this.analyticDistributionTypeSelect;
    }

    public void setAnalyticDistributionTypeSelect(Integer analyticDistributionTypeSelect) {
        this.analyticDistributionTypeSelect = analyticDistributionTypeSelect;
    }

    public Boolean getManageFactors() {
        return this.manageFactors == null ? Boolean.FALSE : this.manageFactors;
    }

    public void setManageFactors(Boolean manageFactors) {
        this.manageFactors = manageFactors;
    }

    public Integer getPartnerBalConfigSelect() {
        return this.partnerBalConfigSelect == null ? 0 : this.partnerBalConfigSelect;
    }

    public void setPartnerBalConfigSelect(Integer partnerBalConfigSelect) {
        this.partnerBalConfigSelect = partnerBalConfigSelect;
    }

    public Boolean getManageAdvancePaymentInvoice() {
        return this.manageAdvancePaymentInvoice == null ? Boolean.FALSE : this.manageAdvancePaymentInvoice;
    }

    public void setManageAdvancePaymentInvoice(Boolean manageAdvancePaymentInvoice) {
        this.manageAdvancePaymentInvoice = manageAdvancePaymentInvoice;
    }

    public Boolean getPaymentVouchersOnInvoice() {
        return this.paymentVouchersOnInvoice == null ? Boolean.FALSE : this.paymentVouchersOnInvoice;
    }

    public void setPaymentVouchersOnInvoice(Boolean paymentVouchersOnInvoice) {
        this.paymentVouchersOnInvoice = paymentVouchersOnInvoice;
    }

    public Boolean getActivatePassedForPayment() {
        return this.activatePassedForPayment == null ? Boolean.FALSE : this.activatePassedForPayment;
    }

    public void setActivatePassedForPayment(Boolean activatePassedForPayment) {
        this.activatePassedForPayment = activatePassedForPayment;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        return EntityHelper.equals((Model)((Object)this), (Object)obj);
    }

    public int hashCode() {
        return EntityHelper.hashCode((Model)((Object)this));
    }

    public String toString() {
        return EntityHelper.toString((Model)((Object)this));
    }
}

