/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.base.db.BarcodeTypeConfig;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.base.db.ProductMultipleQty;
import com.axelor.apps.base.db.ProductVariant;
import com.axelor.apps.base.db.ProductVariantConfig;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PRODUCT", indexes={@Index(columnList="name"), @Index(columnList="picture"), @Index(columnList="product_category"), @Index(columnList="product_family"), @Index(columnList="unit"), @Index(columnList="sale_currency"), @Index(columnList="purchase_currency"), @Index(columnList="product_variant_config"), @Index(columnList="product_variant"), @Index(columnList="parent_product"), @Index(columnList="default_supplier_partner"), @Index(columnList="bar_code"), @Index(columnList="barcode_type_config"), @Index(columnList="fullName"), @Index(columnList="mass_unit"), @Index(columnList="length_unit"), @Index(columnList="purchases_unit")})
@Track(on={TrackEvent.UPDATE}, fields={@TrackField(name="name"), @TrackField(name="code"), @TrackField(name="productCategory"), @TrackField(name="productFamily"), @TrackField(name="saleSupplySelect"), @TrackField(name="sellable"), @TrackField(name="salePrice"), @TrackField(name="saleCurrency"), @TrackField(name="unit"), @TrackField(name="startDate"), @TrackField(name="endDate"), @TrackField(name="purchasable"), @TrackField(name="purchasePrice"), @TrackField(name="defaultSupplierPartner"), @TrackField(name="purchaseCurrency"), @TrackField(name="supplierDeliveryTime"), @TrackField(name="costPrice"), @TrackField(name="managPriceCoef"), @TrackField(name="costTypeSelect"), @TrackField(name="hasWarranty"), @TrackField(name="warrantyNbrOfMonths"), @TrackField(name="isPerishable"), @TrackField(name="perishableNbrOfMonths"), @TrackField(name="purchasesUnit")}, messages={@TrackMessage(message="Product updated", condition="true", on={TrackEvent.UPDATE})})
public class Product
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRODUCT_SEQ")
    @SequenceGenerator(name="BASE_PRODUCT_SEQ", sequenceName="BASE_PRODUCT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", translatable=true)
    @NotNull
    private String name;
    @Widget(title="Serial Nbr")
    private String serialNumber;
    @HashKey
    @Widget(title="Code")
    @Column(unique=true)
    private String code;
    @Widget(title="Description", translatable=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Internal description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String internalDescription;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile picture;
    @Widget(title="Product category", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductCategory productCategory;
    @Widget(title="Accounting family", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductFamily productFamily;
    @Widget(title="Unit", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Sale supply default method on sale order", selection="product.sale.supply.select", massUpdate=true)
    private Integer saleSupplySelect = 0;
    @Widget(title="Type", selection="product.product.type.select", massUpdate=true)
    @NotNull
    private String productTypeSelect;
    @Widget(title="Procurement method", selection="product.procurement.method.select")
    private String procurementMethodSelect;
    @Widget(title="Prototype")
    private Boolean isPrototype = Boolean.FALSE;
    @Widget(title="Unrenewed")
    private Boolean isUnrenewed = Boolean.FALSE;
    @Widget(title="Product Subtype", selection="product.sub.type.product.select")
    private Integer productSubTypeSelect = 0;
    @Widget(title="Inventory type", selection="product.inventory.type.select")
    private Integer inventoryTypeSelect = 0;
    @Widget(title="Sale price W.T.", massUpdate=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal salePrice = BigDecimal.ZERO;
    @Widget(title="Sale currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency saleCurrency;
    @Widget(title="Purchase price W.T.", massUpdate=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal purchasePrice = BigDecimal.ZERO;
    @Widget(title="Purchase / Cost currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency purchaseCurrency;
    @Widget(title="Update sale price from cost price")
    private Boolean autoUpdateSalePrice = Boolean.FALSE;
    @Widget(title="Cost price", massUpdate=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal costPrice = BigDecimal.ZERO;
    @Widget(title="Management coef.")
    private BigDecimal managPriceCoef = BigDecimal.ZERO;
    @Widget(title="Shipping Coef.")
    private BigDecimal shippingCoef = BigDecimal.ZERO;
    @Widget(title="Define the shipping coef by partner")
    private Boolean defShipCoefByPartner = Boolean.FALSE;
    @Widget(title="Product launch Date")
    private LocalDate startDate;
    @Widget(title="Product pulled off market Date")
    private LocalDate endDate;
    @Widget(title="Warranty")
    private Boolean hasWarranty = Boolean.FALSE;
    @Widget(title="Perishable")
    private Boolean isPerishable = Boolean.FALSE;
    @Widget(title="Warranty length (in months)")
    private Integer warrantyNbrOfMonths = 0;
    @Widget(title="Time before expiry (in months)")
    private Integer perishableNbrOfMonths = 0;
    private Boolean checkExpirationDateAtStockMoveRealization = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantConfig productVariantConfig;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariant productVariant;
    @Widget(title="Parent product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product parentProduct;
    @Widget(title="Is model")
    private Boolean isModel = Boolean.FALSE;
    @Widget(title="Manage prices for product variants")
    private Boolean manageVariantPrice = Boolean.FALSE;
    @Widget(title="Default supplier")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner defaultSupplierPartner;
    @Widget(title="Accounts configuration")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountManagement> accountManagementList;
    @Widget(title="Version", selection="base.product.version.select")
    private Integer versionSelect = 0;
    @Widget(title="Sellable")
    private Boolean sellable = Boolean.TRUE;
    @Widget(title="Purchasable")
    private Boolean purchasable = Boolean.TRUE;
    @Widget(title="In ATI")
    private Boolean inAti = Boolean.FALSE;
    @Widget(title="Cost type", selection="base.product.cost.type.select")
    private Integer costTypeSelect = 1;
    @Widget(title="Supplier delivery time (days)")
    private Integer supplierDeliveryTime = 0;
    @Widget(title="Barcode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile barCode;
    @Widget(title="Barcode Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BarcodeTypeConfig barcodeTypeConfig;
    @Widget(title="Full name", translatable=true)
    @NameColumn
    private String fullName;
    @Widget(title="Unit of mass")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit massUnit;
    @Widget(title="Gross mass")
    @Digits(integer=17, fraction=3)
    private BigDecimal grossMass = BigDecimal.ZERO;
    @Widget(title="Net mass")
    @Digits(integer=17, fraction=3)
    private BigDecimal netMass = BigDecimal.ZERO;
    @Widget(title="Unit of length")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit lengthUnit;
    @Widget(title="Length")
    private BigDecimal length = new BigDecimal("0");
    @Widget(title="Width")
    private BigDecimal width = new BigDecimal("0");
    @Widget(title="Height")
    private BigDecimal height = new BigDecimal("0");
    @Widget(title="Diameter")
    private BigDecimal diameter = BigDecimal.ZERO;
    @Widget(title="Article volume")
    private BigDecimal articleVolume = BigDecimal.ZERO;
    @Widget(title="Economic manuf. qty")
    private BigDecimal economicManufOrderQty = BigDecimal.ZERO;
    @Widget(title="Is shipping costs product")
    private Boolean isShippingCostsProduct = Boolean.FALSE;
    @Widget(title="Multiple quantities")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleProduct", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="multipleQty")
    private List<ProductMultipleQty> saleProductMultipleQtyList;
    @Widget(title="Allow to force sales quantities")
    private Boolean allowToForceSaleQty = Boolean.FALSE;
    @Widget(title="Multiple quantities")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="purchaseProduct", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="multipleQty")
    private List<ProductMultipleQty> purchaseProductMultipleQtyList;
    @Widget(title="Allow to force purchases quantities")
    private Boolean allowToForcePurchaseQty = Boolean.FALSE;
    @Widget(title="Purchases unit", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit purchasesUnit;
    @Widget(title="Supplier Catalog Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SupplierCatalog> supplierCatalogList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Product() {
    }

    public Product(String name, String code, String description, String internalDescription, MetaFile picture, ProductCategory productCategory, ProductFamily productFamily, Unit unit, Integer saleSupplySelect, String productTypeSelect, String procurementMethodSelect, Currency saleCurrency, Currency purchaseCurrency, LocalDate startDate, LocalDate endDate) {
        this.name = name;
        this.code = code;
        this.description = description;
        this.internalDescription = internalDescription;
        this.picture = picture;
        this.productCategory = productCategory;
        this.productFamily = productFamily;
        this.unit = unit;
        this.saleSupplySelect = saleSupplySelect;
        this.productTypeSelect = productTypeSelect;
        this.procurementMethodSelect = procurementMethodSelect;
        this.saleCurrency = saleCurrency;
        this.purchaseCurrency = purchaseCurrency;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public void setInternalDescription(String internalDescription) {
        this.internalDescription = internalDescription;
    }

    public MetaFile getPicture() {
        return this.picture;
    }

    public void setPicture(MetaFile picture) {
        this.picture = picture;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(ProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public ProductFamily getProductFamily() {
        return this.productFamily;
    }

    public void setProductFamily(ProductFamily productFamily) {
        this.productFamily = productFamily;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Integer getSaleSupplySelect() {
        return this.saleSupplySelect == null ? 0 : this.saleSupplySelect;
    }

    public void setSaleSupplySelect(Integer saleSupplySelect) {
        this.saleSupplySelect = saleSupplySelect;
    }

    public String getProductTypeSelect() {
        return this.productTypeSelect;
    }

    public void setProductTypeSelect(String productTypeSelect) {
        this.productTypeSelect = productTypeSelect;
    }

    public String getProcurementMethodSelect() {
        return this.procurementMethodSelect;
    }

    public void setProcurementMethodSelect(String procurementMethodSelect) {
        this.procurementMethodSelect = procurementMethodSelect;
    }

    public Boolean getIsPrototype() {
        return this.isPrototype == null ? Boolean.FALSE : this.isPrototype;
    }

    public void setIsPrototype(Boolean isPrototype) {
        this.isPrototype = isPrototype;
    }

    public Boolean getIsUnrenewed() {
        return this.isUnrenewed == null ? Boolean.FALSE : this.isUnrenewed;
    }

    public void setIsUnrenewed(Boolean isUnrenewed) {
        this.isUnrenewed = isUnrenewed;
    }

    public Integer getProductSubTypeSelect() {
        return this.productSubTypeSelect == null ? 0 : this.productSubTypeSelect;
    }

    public void setProductSubTypeSelect(Integer productSubTypeSelect) {
        this.productSubTypeSelect = productSubTypeSelect;
    }

    public Integer getInventoryTypeSelect() {
        return this.inventoryTypeSelect == null ? 0 : this.inventoryTypeSelect;
    }

    public void setInventoryTypeSelect(Integer inventoryTypeSelect) {
        this.inventoryTypeSelect = inventoryTypeSelect;
    }

    public BigDecimal getSalePrice() {
        return this.salePrice == null ? BigDecimal.ZERO : this.salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Currency getSaleCurrency() {
        return this.saleCurrency;
    }

    public void setSaleCurrency(Currency saleCurrency) {
        this.saleCurrency = saleCurrency;
    }

    public BigDecimal getPurchasePrice() {
        return this.purchasePrice == null ? BigDecimal.ZERO : this.purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public Currency getPurchaseCurrency() {
        return this.purchaseCurrency;
    }

    public void setPurchaseCurrency(Currency purchaseCurrency) {
        this.purchaseCurrency = purchaseCurrency;
    }

    public Boolean getAutoUpdateSalePrice() {
        return this.autoUpdateSalePrice == null ? Boolean.FALSE : this.autoUpdateSalePrice;
    }

    public void setAutoUpdateSalePrice(Boolean autoUpdateSalePrice) {
        this.autoUpdateSalePrice = autoUpdateSalePrice;
    }

    public BigDecimal getCostPrice() {
        return this.costPrice == null ? BigDecimal.ZERO : this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getManagPriceCoef() {
        return this.managPriceCoef == null ? BigDecimal.ZERO : this.managPriceCoef;
    }

    public void setManagPriceCoef(BigDecimal managPriceCoef) {
        this.managPriceCoef = managPriceCoef;
    }

    public BigDecimal getShippingCoef() {
        return this.shippingCoef == null ? BigDecimal.ZERO : this.shippingCoef;
    }

    public void setShippingCoef(BigDecimal shippingCoef) {
        this.shippingCoef = shippingCoef;
    }

    public Boolean getDefShipCoefByPartner() {
        return this.defShipCoefByPartner == null ? Boolean.FALSE : this.defShipCoefByPartner;
    }

    public void setDefShipCoefByPartner(Boolean defShipCoefByPartner) {
        this.defShipCoefByPartner = defShipCoefByPartner;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Boolean getHasWarranty() {
        return this.hasWarranty == null ? Boolean.FALSE : this.hasWarranty;
    }

    public void setHasWarranty(Boolean hasWarranty) {
        this.hasWarranty = hasWarranty;
    }

    public Boolean getIsPerishable() {
        return this.isPerishable == null ? Boolean.FALSE : this.isPerishable;
    }

    public void setIsPerishable(Boolean isPerishable) {
        this.isPerishable = isPerishable;
    }

    public Integer getWarrantyNbrOfMonths() {
        return this.warrantyNbrOfMonths == null ? 0 : this.warrantyNbrOfMonths;
    }

    public void setWarrantyNbrOfMonths(Integer warrantyNbrOfMonths) {
        this.warrantyNbrOfMonths = warrantyNbrOfMonths;
    }

    public Integer getPerishableNbrOfMonths() {
        return this.perishableNbrOfMonths == null ? 0 : this.perishableNbrOfMonths;
    }

    public void setPerishableNbrOfMonths(Integer perishableNbrOfMonths) {
        this.perishableNbrOfMonths = perishableNbrOfMonths;
    }

    public Boolean getCheckExpirationDateAtStockMoveRealization() {
        return this.checkExpirationDateAtStockMoveRealization == null ? Boolean.FALSE : this.checkExpirationDateAtStockMoveRealization;
    }

    public void setCheckExpirationDateAtStockMoveRealization(Boolean checkExpirationDateAtStockMoveRealization) {
        this.checkExpirationDateAtStockMoveRealization = checkExpirationDateAtStockMoveRealization;
    }

    public ProductVariantConfig getProductVariantConfig() {
        return this.productVariantConfig;
    }

    public void setProductVariantConfig(ProductVariantConfig productVariantConfig) {
        this.productVariantConfig = productVariantConfig;
    }

    public ProductVariant getProductVariant() {
        return this.productVariant;
    }

    public void setProductVariant(ProductVariant productVariant) {
        this.productVariant = productVariant;
    }

    public Product getParentProduct() {
        return this.parentProduct;
    }

    public void setParentProduct(Product parentProduct) {
        this.parentProduct = parentProduct;
    }

    public Boolean getIsModel() {
        return this.isModel == null ? Boolean.FALSE : this.isModel;
    }

    public void setIsModel(Boolean isModel) {
        this.isModel = isModel;
    }

    public Boolean getManageVariantPrice() {
        return this.manageVariantPrice == null ? Boolean.FALSE : this.manageVariantPrice;
    }

    public void setManageVariantPrice(Boolean manageVariantPrice) {
        this.manageVariantPrice = manageVariantPrice;
    }

    public Partner getDefaultSupplierPartner() {
        return this.defaultSupplierPartner;
    }

    public void setDefaultSupplierPartner(Partner defaultSupplierPartner) {
        this.defaultSupplierPartner = defaultSupplierPartner;
    }

    public List<AccountManagement> getAccountManagementList() {
        return this.accountManagementList;
    }

    public void setAccountManagementList(List<AccountManagement> accountManagementList) {
        this.accountManagementList = accountManagementList;
    }

    public void addAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            this.setAccountManagementList(new ArrayList<AccountManagement>());
        }
        this.getAccountManagementList().add(item);
        item.setProduct(this);
    }

    public void removeAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            return;
        }
        this.getAccountManagementList().remove(item);
    }

    public void clearAccountManagementList() {
        if (this.getAccountManagementList() != null) {
            this.getAccountManagementList().clear();
        }
    }

    public Integer getVersionSelect() {
        return this.versionSelect == null ? 0 : this.versionSelect;
    }

    public void setVersionSelect(Integer versionSelect) {
        this.versionSelect = versionSelect;
    }

    public Boolean getSellable() {
        return this.sellable == null ? Boolean.FALSE : this.sellable;
    }

    public void setSellable(Boolean sellable) {
        this.sellable = sellable;
    }

    public Boolean getPurchasable() {
        return this.purchasable == null ? Boolean.FALSE : this.purchasable;
    }

    public void setPurchasable(Boolean purchasable) {
        this.purchasable = purchasable;
    }

    public Boolean getInAti() {
        return this.inAti == null ? Boolean.FALSE : this.inAti;
    }

    public void setInAti(Boolean inAti) {
        this.inAti = inAti;
    }

    public Integer getCostTypeSelect() {
        return this.costTypeSelect == null ? 0 : this.costTypeSelect;
    }

    public void setCostTypeSelect(Integer costTypeSelect) {
        this.costTypeSelect = costTypeSelect;
    }

    public Integer getSupplierDeliveryTime() {
        return this.supplierDeliveryTime == null ? 0 : this.supplierDeliveryTime;
    }

    public void setSupplierDeliveryTime(Integer supplierDeliveryTime) {
        this.supplierDeliveryTime = supplierDeliveryTime;
    }

    public MetaFile getBarCode() {
        return this.barCode;
    }

    public void setBarCode(MetaFile barCode) {
        this.barCode = barCode;
    }

    public BarcodeTypeConfig getBarcodeTypeConfig() {
        return this.barcodeTypeConfig;
    }

    public void setBarcodeTypeConfig(BarcodeTypeConfig barcodeTypeConfig) {
        this.barcodeTypeConfig = barcodeTypeConfig;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Unit getMassUnit() {
        return this.massUnit;
    }

    public void setMassUnit(Unit massUnit) {
        this.massUnit = massUnit;
    }

    public BigDecimal getGrossMass() {
        return this.grossMass == null ? BigDecimal.ZERO : this.grossMass;
    }

    public void setGrossMass(BigDecimal grossMass) {
        this.grossMass = grossMass;
    }

    public BigDecimal getNetMass() {
        return this.netMass == null ? BigDecimal.ZERO : this.netMass;
    }

    public void setNetMass(BigDecimal netMass) {
        this.netMass = netMass;
    }

    public Unit getLengthUnit() {
        return this.lengthUnit;
    }

    public void setLengthUnit(Unit lengthUnit) {
        this.lengthUnit = lengthUnit;
    }

    public BigDecimal getLength() {
        return this.length == null ? BigDecimal.ZERO : this.length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return this.width == null ? BigDecimal.ZERO : this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return this.height == null ? BigDecimal.ZERO : this.height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getDiameter() {
        return this.diameter == null ? BigDecimal.ZERO : this.diameter;
    }

    public void setDiameter(BigDecimal diameter) {
        this.diameter = diameter;
    }

    public BigDecimal getArticleVolume() {
        return this.articleVolume == null ? BigDecimal.ZERO : this.articleVolume;
    }

    public void setArticleVolume(BigDecimal articleVolume) {
        this.articleVolume = articleVolume;
    }

    public BigDecimal getEconomicManufOrderQty() {
        return this.economicManufOrderQty == null ? BigDecimal.ZERO : this.economicManufOrderQty;
    }

    public void setEconomicManufOrderQty(BigDecimal economicManufOrderQty) {
        this.economicManufOrderQty = economicManufOrderQty;
    }

    public Boolean getIsShippingCostsProduct() {
        return this.isShippingCostsProduct == null ? Boolean.FALSE : this.isShippingCostsProduct;
    }

    public void setIsShippingCostsProduct(Boolean isShippingCostsProduct) {
        this.isShippingCostsProduct = isShippingCostsProduct;
    }

    public List<ProductMultipleQty> getSaleProductMultipleQtyList() {
        return this.saleProductMultipleQtyList;
    }

    public void setSaleProductMultipleQtyList(List<ProductMultipleQty> saleProductMultipleQtyList) {
        this.saleProductMultipleQtyList = saleProductMultipleQtyList;
    }

    public void addSaleProductMultipleQtyListItem(ProductMultipleQty item) {
        if (this.getSaleProductMultipleQtyList() == null) {
            this.setSaleProductMultipleQtyList(new ArrayList<ProductMultipleQty>());
        }
        this.getSaleProductMultipleQtyList().add(item);
        item.setSaleProduct(this);
    }

    public void removeSaleProductMultipleQtyListItem(ProductMultipleQty item) {
        if (this.getSaleProductMultipleQtyList() == null) {
            return;
        }
        this.getSaleProductMultipleQtyList().remove(item);
    }

    public void clearSaleProductMultipleQtyList() {
        if (this.getSaleProductMultipleQtyList() != null) {
            this.getSaleProductMultipleQtyList().clear();
        }
    }

    public Boolean getAllowToForceSaleQty() {
        return this.allowToForceSaleQty == null ? Boolean.FALSE : this.allowToForceSaleQty;
    }

    public void setAllowToForceSaleQty(Boolean allowToForceSaleQty) {
        this.allowToForceSaleQty = allowToForceSaleQty;
    }

    public List<ProductMultipleQty> getPurchaseProductMultipleQtyList() {
        return this.purchaseProductMultipleQtyList;
    }

    public void setPurchaseProductMultipleQtyList(List<ProductMultipleQty> purchaseProductMultipleQtyList) {
        this.purchaseProductMultipleQtyList = purchaseProductMultipleQtyList;
    }

    public void addPurchaseProductMultipleQtyListItem(ProductMultipleQty item) {
        if (this.getPurchaseProductMultipleQtyList() == null) {
            this.setPurchaseProductMultipleQtyList(new ArrayList<ProductMultipleQty>());
        }
        this.getPurchaseProductMultipleQtyList().add(item);
        item.setPurchaseProduct(this);
    }

    public void removePurchaseProductMultipleQtyListItem(ProductMultipleQty item) {
        if (this.getPurchaseProductMultipleQtyList() == null) {
            return;
        }
        this.getPurchaseProductMultipleQtyList().remove(item);
    }

    public void clearPurchaseProductMultipleQtyList() {
        if (this.getPurchaseProductMultipleQtyList() != null) {
            this.getPurchaseProductMultipleQtyList().clear();
        }
    }

    public Boolean getAllowToForcePurchaseQty() {
        return this.allowToForcePurchaseQty == null ? Boolean.FALSE : this.allowToForcePurchaseQty;
    }

    public void setAllowToForcePurchaseQty(Boolean allowToForcePurchaseQty) {
        this.allowToForcePurchaseQty = allowToForcePurchaseQty;
    }

    public Unit getPurchasesUnit() {
        return this.purchasesUnit;
    }

    public void setPurchasesUnit(Unit purchasesUnit) {
        this.purchasesUnit = purchasesUnit;
    }

    public List<SupplierCatalog> getSupplierCatalogList() {
        return this.supplierCatalogList;
    }

    public void setSupplierCatalogList(List<SupplierCatalog> supplierCatalogList) {
        this.supplierCatalogList = supplierCatalogList;
    }

    public void addSupplierCatalogListItem(SupplierCatalog item) {
        if (this.getSupplierCatalogList() == null) {
            this.setSupplierCatalogList(new ArrayList<SupplierCatalog>());
        }
        this.getSupplierCatalogList().add(item);
        item.setProduct(this);
    }

    public void removeSupplierCatalogListItem(SupplierCatalog item) {
        if (this.getSupplierCatalogList() == null) {
            return;
        }
        this.getSupplierCatalogList().remove((Object)item);
    }

    public void clearSupplierCatalogList() {
        if (this.getSupplierCatalogList() != null) {
            this.getSupplierCatalogList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Product)) {
            return false;
        }
        Product other = (Product)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1355179215, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("serialNumber", (Object)this.getSerialNumber()).add("code", (Object)this.getCode()).add("saleSupplySelect", (Object)this.getSaleSupplySelect()).add("productTypeSelect", (Object)this.getProductTypeSelect()).add("procurementMethodSelect", (Object)this.getProcurementMethodSelect()).add("isPrototype", (Object)this.getIsPrototype()).add("isUnrenewed", (Object)this.getIsUnrenewed()).add("productSubTypeSelect", (Object)this.getProductSubTypeSelect()).add("inventoryTypeSelect", (Object)this.getInventoryTypeSelect()).add("salePrice", (Object)this.getSalePrice()).omitNullValues().toString();
    }
}

