/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.db;

import com.axelor.apps.base.db.BirtTemplate;
import com.axelor.apps.base.db.Language;
import com.axelor.apps.message.db.TemplateContext;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MESSAGE_TEMPLATE", indexes={@Index(columnList="name"), @Index(columnList="meta_model"), @Index(columnList="meta_json_model"), @Index(columnList="birt_template"), @Index(columnList="language")})
public class Template
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MESSAGE_TEMPLATE_SEQ")
    @SequenceGenerator(name="MESSAGE_TEMPLATE_SEQ", sequenceName="MESSAGE_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="Content", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String content;
    @Widget(title="Subject", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String subject;
    @Widget(title="From", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String fromAdress;
    @Widget(title="Reply to", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String replyToRecipients;
    @Widget(title="To", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String toRecipients;
    @Widget(title="Cc", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String ccRecipients;
    @Widget(title="Bcc", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String bccRecipients;
    @Widget(title="Target receptor")
    private String target;
    @Widget(title="Media Type", selection="template.media.type.select")
    @NotNull
    private Integer mediaTypeSelect = 2;
    @Widget(title="Address Block", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String addressBlock;
    @Widget(title="Model")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Default")
    private Boolean isDefault = Boolean.FALSE;
    @Widget(title="System")
    private Boolean isSystem = Boolean.FALSE;
    @Widget(title="Json")
    private Boolean isJson = Boolean.FALSE;
    @Widget(title="Model")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonModel metaJsonModel;
    @Widget(title="Context")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="template", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TemplateContext> templateContextList;
    @Widget(title="Birt Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BirtTemplate birtTemplate;
    @Widget(title="Language")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Language language;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Template() {
    }

    public Template(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFromAdress() {
        return this.fromAdress;
    }

    public void setFromAdress(String fromAdress) {
        this.fromAdress = fromAdress;
    }

    public String getReplyToRecipients() {
        return this.replyToRecipients;
    }

    public void setReplyToRecipients(String replyToRecipients) {
        this.replyToRecipients = replyToRecipients;
    }

    public String getToRecipients() {
        return this.toRecipients;
    }

    public void setToRecipients(String toRecipients) {
        this.toRecipients = toRecipients;
    }

    public String getCcRecipients() {
        return this.ccRecipients;
    }

    public void setCcRecipients(String ccRecipients) {
        this.ccRecipients = ccRecipients;
    }

    public String getBccRecipients() {
        return this.bccRecipients;
    }

    public void setBccRecipients(String bccRecipients) {
        this.bccRecipients = bccRecipients;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Integer getMediaTypeSelect() {
        return this.mediaTypeSelect == null ? 0 : this.mediaTypeSelect;
    }

    public void setMediaTypeSelect(Integer mediaTypeSelect) {
        this.mediaTypeSelect = mediaTypeSelect;
    }

    public String getAddressBlock() {
        return this.addressBlock;
    }

    public void setAddressBlock(String addressBlock) {
        this.addressBlock = addressBlock;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public Boolean getIsDefault() {
        return this.isDefault == null ? Boolean.FALSE : this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsSystem() {
        return this.isSystem == null ? Boolean.FALSE : this.isSystem;
    }

    public void setIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
    }

    public Boolean getIsJson() {
        return this.isJson == null ? Boolean.FALSE : this.isJson;
    }

    public void setIsJson(Boolean isJson) {
        this.isJson = isJson;
    }

    public MetaJsonModel getMetaJsonModel() {
        return this.metaJsonModel;
    }

    public void setMetaJsonModel(MetaJsonModel metaJsonModel) {
        this.metaJsonModel = metaJsonModel;
    }

    public List<TemplateContext> getTemplateContextList() {
        return this.templateContextList;
    }

    public void setTemplateContextList(List<TemplateContext> templateContextList) {
        this.templateContextList = templateContextList;
    }

    public void addTemplateContextListItem(TemplateContext item) {
        if (this.getTemplateContextList() == null) {
            this.setTemplateContextList(new ArrayList<TemplateContext>());
        }
        this.getTemplateContextList().add(item);
        item.setTemplate(this);
    }

    public void removeTemplateContextListItem(TemplateContext item) {
        if (this.getTemplateContextList() == null) {
            return;
        }
        this.getTemplateContextList().remove(item);
    }

    public void clearTemplateContextList() {
        if (this.getTemplateContextList() != null) {
            this.getTemplateContextList().clear();
        }
    }

    public BirtTemplate getBirtTemplate() {
        return this.birtTemplate;
    }

    public void setBirtTemplate(BirtTemplate birtTemplate) {
        this.birtTemplate = birtTemplate;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("target", (Object)this.getTarget()).add("mediaTypeSelect", (Object)this.getMediaTypeSelect()).add("isDefault", (Object)this.getIsDefault()).add("isSystem", (Object)this.getIsSystem()).add("isJson", (Object)this.getIsJson()).omitNullValues().toString();
    }
}

