/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="PURCHASE_PURCHASE_ORDER_LINE", indexes={@Index(columnList="fullName"), @Index(columnList="purchase_order"), @Index(columnList="product"), @Index(columnList="tax_line"), @Index(columnList="tax_equiv"), @Index(columnList="unit")})
public class PurchaseOrderLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_ORDER_LINE_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_ORDER_LINE_SEQ", sequenceName="PURCHASE_PURCHASE_ORDER_LINE_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Purchase order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrder purchaseOrder;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal qty = new BigDecimal("1");
    @Widget(title="Displayed Product name", translatable=true)
    @NotNull
    private String productName;
    @Widget(title="Supplier code")
    private String productCode;
    @Widget(title="Unit price W.T.")
    @Digits(integer=10, fraction=10)
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Unit price A.T.I.")
    @Digits(integer=10, fraction=10)
    private BigDecimal inTaxPrice = BigDecimal.ZERO;
    @Widget(title="Unit price discounted")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceDiscounted = BigDecimal.ZERO;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Total W.T.")
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.")
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Tax Equiv")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxEquiv taxEquiv;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Discount amount")
    @Digits(integer=10, fraction=10)
    private BigDecimal discountAmount = BigDecimal.ZERO;
    @Widget(title="Discount Type", selection="base.price.list.line.amount.type.select")
    private Integer discountTypeSelect = 0;
    @Widget(title="Ordered")
    private Boolean isOrdered = Boolean.FALSE;
    @Widget(title="Min sale price")
    @Digits(integer=10, fraction=10)
    private BigDecimal saleMinPrice = BigDecimal.ZERO;
    @Widget(title="Estim. receipt date")
    private LocalDate estimatedDelivDate;
    @Widget(title="Desired receipt date")
    private LocalDate desiredDelivDate;
    @Widget(title="Received quantity")
    private BigDecimal receivedQty = BigDecimal.ZERO;
    @Widget(title="Supplier Comment")
    private String supplierComment;
    @Widget(title="Fixed Assets")
    private Boolean fixedAssets = Boolean.FALSE;
    @Widget(title="Total W.T. in company currency", hidden=true)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I. in company currency", hidden=true)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Digits(integer=10, fraction=10)
    private BigDecimal salePrice = BigDecimal.ZERO;
    @Widget(title="Title Line")
    private Boolean isTitleLine = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.purchaseOrder != null && this.purchaseOrder.getPurchaseOrderSeq() != null) {
            fullName = fullName + this.purchaseOrder.getPurchaseOrderSeq();
        }
        if (this.productName != null) {
            fullName = fullName + "-";
            fullName = this.productName.length() > 100 ? fullName + this.productName.substring(1, 100) : fullName + this.productName;
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public PurchaseOrder getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getInTaxPrice() {
        return this.inTaxPrice == null ? BigDecimal.ZERO : this.inTaxPrice;
    }

    public void setInTaxPrice(BigDecimal inTaxPrice) {
        this.inTaxPrice = inTaxPrice;
    }

    public BigDecimal getPriceDiscounted() {
        return this.priceDiscounted == null ? BigDecimal.ZERO : this.priceDiscounted;
    }

    public void setPriceDiscounted(BigDecimal priceDiscounted) {
        this.priceDiscounted = priceDiscounted;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public TaxEquiv getTaxEquiv() {
        return this.taxEquiv;
    }

    public void setTaxEquiv(TaxEquiv taxEquiv) {
        this.taxEquiv = taxEquiv;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount == null ? BigDecimal.ZERO : this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountTypeSelect() {
        return this.discountTypeSelect == null ? 0 : this.discountTypeSelect;
    }

    public void setDiscountTypeSelect(Integer discountTypeSelect) {
        this.discountTypeSelect = discountTypeSelect;
    }

    public Boolean getIsOrdered() {
        return this.isOrdered == null ? Boolean.FALSE : this.isOrdered;
    }

    public void setIsOrdered(Boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public BigDecimal getSaleMinPrice() {
        return this.saleMinPrice == null ? BigDecimal.ZERO : this.saleMinPrice;
    }

    public void setSaleMinPrice(BigDecimal saleMinPrice) {
        this.saleMinPrice = saleMinPrice;
    }

    public LocalDate getEstimatedDelivDate() {
        return this.estimatedDelivDate;
    }

    public void setEstimatedDelivDate(LocalDate estimatedDelivDate) {
        this.estimatedDelivDate = estimatedDelivDate;
    }

    public LocalDate getDesiredDelivDate() {
        return this.desiredDelivDate;
    }

    public void setDesiredDelivDate(LocalDate desiredDelivDate) {
        this.desiredDelivDate = desiredDelivDate;
    }

    public BigDecimal getReceivedQty() {
        return this.receivedQty == null ? BigDecimal.ZERO : this.receivedQty;
    }

    public void setReceivedQty(BigDecimal receivedQty) {
        this.receivedQty = receivedQty;
    }

    public String getSupplierComment() {
        return this.supplierComment;
    }

    public void setSupplierComment(String supplierComment) {
        this.supplierComment = supplierComment;
    }

    public Boolean getFixedAssets() {
        return this.fixedAssets == null ? Boolean.FALSE : this.fixedAssets;
    }

    public void setFixedAssets(Boolean fixedAssets) {
        this.fixedAssets = fixedAssets;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public BigDecimal getSalePrice() {
        return this.salePrice == null ? BigDecimal.ZERO : this.salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Boolean getIsTitleLine() {
        return this.isTitleLine == null ? Boolean.FALSE : this.isTitleLine;
    }

    public void setIsTitleLine(Boolean isTitleLine) {
        this.isTitleLine = isTitleLine;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseOrderLine)) {
            return false;
        }
        PurchaseOrderLine other = (PurchaseOrderLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("qty", (Object)this.getQty()).add("productName", (Object)this.getProductName()).add("productCode", (Object)this.getProductCode()).add("price", (Object)this.getPrice()).add("inTaxPrice", (Object)this.getInTaxPrice()).add("priceDiscounted", (Object)this.getPriceDiscounted()).add("exTaxTotal", (Object)this.getExTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).add("discountAmount", (Object)this.getDiscountAmount()).add("discountTypeSelect", (Object)this.getDiscountTypeSelect()).omitNullValues().toString();
    }
}

