/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PURCHASE_PURCHASE_ORDER_LINE_TAX", indexes={@Index(columnList="purchase_order"), @Index(columnList="tax_line")})
public class PurchaseOrderLineTax
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_ORDER_LINE_TAX_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_ORDER_LINE_TAX_SEQ", sequenceName="PURCHASE_PURCHASE_ORDER_LINE_TAX_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Purchase order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrder purchaseOrder;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Base W.T.")
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxBase = BigDecimal.ZERO;
    @Widget(title="Amount Tax")
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Amount A.T.I.")
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    private Boolean reverseCharged = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PurchaseOrder getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public BigDecimal getExTaxBase() {
        return this.exTaxBase == null ? BigDecimal.ZERO : this.exTaxBase;
    }

    public void setExTaxBase(BigDecimal exTaxBase) {
        this.exTaxBase = exTaxBase;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public Boolean getReverseCharged() {
        return this.reverseCharged == null ? Boolean.FALSE : this.reverseCharged;
    }

    public void setReverseCharged(Boolean reverseCharged) {
        this.reverseCharged = reverseCharged;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseOrderLineTax)) {
            return false;
        }
        PurchaseOrderLineTax other = (PurchaseOrderLineTax)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("exTaxBase", (Object)this.getExTaxBase()).add("taxTotal", (Object)this.getTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).add("reverseCharged", (Object)this.getReverseCharged()).omitNullValues().toString();
    }
}

