/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaJsonField;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="PURCHASE_PURCHASE_REQUEST_CREATOR", indexes={@Index(columnList="name")})
public class PurchaseRequestCreator
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_REQUEST_CREATOR_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_REQUEST_CREATOR_SEQ", sequenceName="PURCHASE_PURCHASE_REQUEST_CREATOR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Attributes")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaJsonField> attributes;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PurchaseRequestCreator() {
    }

    public PurchaseRequestCreator(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<MetaJsonField> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<MetaJsonField> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(MetaJsonField item) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<MetaJsonField>());
        }
        this.getAttributes().add(item);
    }

    public void removeAttribute(MetaJsonField item) {
        if (this.getAttributes() == null) {
            return;
        }
        this.getAttributes().remove(item);
    }

    public void clearAttributes() {
        if (this.getAttributes() != null) {
            this.getAttributes().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseRequestCreator)) {
            return false;
        }
        PurchaseRequestCreator other = (PurchaseRequestCreator)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

