/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.exception.AxelorException;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;

public interface PurchaseOrderLineService {
    public BigDecimal getExTaxUnitPrice(PurchaseOrder var1, PurchaseOrderLine var2, TaxLine var3) throws AxelorException;

    public BigDecimal getInTaxUnitPrice(PurchaseOrder var1, PurchaseOrderLine var2, TaxLine var3) throws AxelorException;

    public BigDecimal getMinSalePrice(PurchaseOrder var1, PurchaseOrderLine var2) throws AxelorException;

    public BigDecimal getSalePrice(PurchaseOrder var1, Product var2, BigDecimal var3) throws AxelorException;

    public TaxLine getTaxLine(PurchaseOrder var1, PurchaseOrderLine var2) throws AxelorException;

    public Optional<TaxLine> getOptionalTaxLine(PurchaseOrder var1, PurchaseOrderLine var2);

    public BigDecimal computePurchaseOrderLine(PurchaseOrderLine var1);

    public BigDecimal getCompanyExTaxTotal(BigDecimal var1, PurchaseOrder var2) throws AxelorException;

    public PriceListLine getPriceListLine(PurchaseOrderLine var1, PriceList var2, BigDecimal var3);

    public Map<String, BigDecimal> compute(PurchaseOrderLine var1, PurchaseOrder var2) throws AxelorException;

    public BigDecimal computeDiscount(PurchaseOrderLine var1, Boolean var2);

    public PurchaseOrderLine createPurchaseOrderLine(PurchaseOrder var1, Product var2, String var3, String var4, BigDecimal var5, Unit var6) throws AxelorException;

    public BigDecimal getQty(PurchaseOrder var1, PurchaseOrderLine var2);

    public SupplierCatalog getSupplierCatalog(PurchaseOrder var1, PurchaseOrderLine var2);

    public BigDecimal convertUnitPrice(Boolean var1, TaxLine var2, BigDecimal var3);

    public Map<String, Object> updateInfoFromCatalog(PurchaseOrder var1, PurchaseOrderLine var2) throws AxelorException;

    public Map<String, Object> getDiscountsFromPriceLists(PurchaseOrder var1, PurchaseOrderLine var2, BigDecimal var3);

    public int getDiscountTypeSelect(PurchaseOrderLine var1, PurchaseOrder var2, BigDecimal var3);

    public Unit getPurchaseUnit(PurchaseOrderLine var1);

    public BigDecimal getMinQty(PurchaseOrder var1, PurchaseOrderLine var2);

    public void checkMinQty(PurchaseOrder var1, PurchaseOrderLine var2, ActionRequest var3, ActionResponse var4);

    public void checkMultipleQty(PurchaseOrderLine var1, ActionResponse var2);

    public String[] getProductSupplierInfos(PurchaseOrder var1, PurchaseOrderLine var2) throws AxelorException;

    public PurchaseOrderLine fill(PurchaseOrderLine var1, PurchaseOrder var2) throws AxelorException;

    public PurchaseOrderLine reset(PurchaseOrderLine var1);
}

