/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.PurchaseOrderLineTax;
import com.axelor.apps.purchase.service.PurchaseOrderToolService;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderLineTaxService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private PurchaseOrderToolService purchaseOrderToolService;

    public List<PurchaseOrderLineTax> createsPurchaseOrderLineTax(PurchaseOrder purchaseOrder, List<PurchaseOrderLine> purchaseOrderLineList) {
        ArrayList<PurchaseOrderLineTax> purchaseOrderLineTaxList = new ArrayList<PurchaseOrderLineTax>();
        HashMap<TaxLine, PurchaseOrderLineTax> map = new HashMap<TaxLine, PurchaseOrderLineTax>();
        if (purchaseOrderLineList != null && !purchaseOrderLineList.isEmpty()) {
            LOG.debug("Cr\u00e9ation des lignes de tva pour les lignes de commande.");
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
                TaxLine taxLineRC;
                TaxLine taxLine = purchaseOrderLine.getTaxLine();
                TaxEquiv taxEquiv = purchaseOrderLine.getTaxEquiv();
                TaxLine taxLine2 = taxLineRC = taxEquiv != null && taxEquiv.getReverseCharge() != false && taxEquiv.getReverseChargeTax() != null ? taxEquiv.getReverseChargeTax().getActiveTaxLine() : null;
                if (taxLine != null) {
                    LOG.debug("TVA {}", (Object)taxLine);
                    if (map.containsKey(taxLine)) {
                        PurchaseOrderLineTax purchaseOrderLineVat = (PurchaseOrderLineTax)((Object)map.get(taxLine));
                        purchaseOrderLineVat.setExTaxBase(purchaseOrderLineVat.getExTaxBase().add(purchaseOrderLine.getExTaxTotal()));
                        purchaseOrderLineVat.setReverseCharged(false);
                    } else {
                        PurchaseOrderLineTax purchaseOrderLineTax = new PurchaseOrderLineTax();
                        purchaseOrderLineTax.setPurchaseOrder(purchaseOrder);
                        purchaseOrderLineTax.setExTaxBase(purchaseOrderLine.getExTaxTotal());
                        purchaseOrderLineTax.setReverseCharged(false);
                        purchaseOrderLineTax.setTaxLine(taxLine);
                        map.put(taxLine, purchaseOrderLineTax);
                    }
                }
                if (taxLineRC == null) continue;
                LOG.debug("TVA {}", (Object)taxLineRC);
                if (map.containsKey(taxLineRC)) {
                    PurchaseOrderLineTax purchaseOrderLineRC = (PurchaseOrderLineTax)((Object)map.get(taxEquiv.getReverseChargeTax().getActiveTaxLine()));
                    purchaseOrderLineRC.setExTaxBase(purchaseOrderLineRC.getExTaxBase().add(purchaseOrderLine.getExTaxTotal()));
                    purchaseOrderLineRC.setReverseCharged(true);
                    continue;
                }
                PurchaseOrderLineTax purchaseOrderLineTaxRC = new PurchaseOrderLineTax();
                purchaseOrderLineTaxRC.setPurchaseOrder(purchaseOrder);
                purchaseOrderLineTaxRC.setExTaxBase(purchaseOrderLine.getExTaxTotal());
                purchaseOrderLineTaxRC.setReverseCharged(true);
                purchaseOrderLineTaxRC.setTaxLine(taxLineRC);
                map.put(taxLineRC, purchaseOrderLineTaxRC);
            }
        }
        for (PurchaseOrderLineTax purchaseOrderLineTax : map.values()) {
            BigDecimal exTaxBase = purchaseOrderLineTax.getReverseCharged() != false ? purchaseOrderLineTax.getExTaxBase().negate() : purchaseOrderLineTax.getExTaxBase();
            BigDecimal taxTotal = BigDecimal.ZERO;
            if (purchaseOrderLineTax.getTaxLine() != null) {
                taxTotal = this.purchaseOrderToolService.computeAmount(exTaxBase, purchaseOrderLineTax.getTaxLine().getValue());
            }
            purchaseOrderLineTax.setTaxTotal(taxTotal);
            purchaseOrderLineTax.setInTaxTotal(purchaseOrderLineTax.getExTaxBase().add(taxTotal));
            purchaseOrderLineTaxList.add(purchaseOrderLineTax);
            LOG.debug("Ligne de TVA : Total TVA => {}, Total HT => {}", new Object[]{purchaseOrderLineTax.getTaxTotal(), purchaseOrderLineTax.getInTaxTotal()});
        }
        return purchaseOrderLineTaxList;
    }
}

