/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderToolService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private CurrencyService currencyService;

    public BigDecimal computeAmount(BigDecimal quantity, BigDecimal price) {
        BigDecimal amount = quantity.multiply(price).setScale(2, RoundingMode.HALF_EVEN);
        LOG.debug("Calcul du montant HT avec une quantit\u00e9 de {} pour {} : {}", new Object[]{quantity, price, amount});
        return amount;
    }

    public BigDecimal getAccountingExTaxTotal(BigDecimal exTaxTotal, PurchaseOrder purchaseOrder) throws AxelorException {
        return this.currencyService.getAmountCurrencyConvertedAtDate(purchaseOrder.getCurrency(), purchaseOrder.getSupplierPartner().getCurrency(), exTaxTotal, purchaseOrder.getOrderDate()).setScale(2, RoundingMode.HALF_UP);
    }
}

