/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.PurchaseRequest;
import com.axelor.apps.purchase.db.PurchaseRequestLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.db.repo.PurchaseRequestRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.PurchaseOrderService;
import com.axelor.apps.purchase.service.PurchaseRequestService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class PurchaseRequestServiceImpl
implements PurchaseRequestService {
    @Inject
    private PurchaseRequestRepository purchaseRequestRepo;
    @Inject
    private PurchaseOrderService purchaseOrderService;
    @Inject
    private PurchaseOrderLineService purchaseOrderLineService;
    @Inject
    private PurchaseOrderRepository purchaseOrderRepo;
    @Inject
    private PurchaseOrderLineRepository purchaseOrderLineRepo;

    @Override
    @Transactional
    public void confirmCart() {
        List purchaseRequests = this.purchaseRequestRepo.all().filter("self.statusSelect = 1 and self.createdBy = ?1", new Object[]{AuthUtils.getUser()}).fetch();
        for (PurchaseRequest purchaseRequest : purchaseRequests) {
            purchaseRequest.setStatusSelect(2);
            this.purchaseRequestRepo.save((Model)((Object)purchaseRequest));
        }
    }

    @Override
    @Transactional
    public void acceptRequest(List<PurchaseRequest> purchaseRequests) {
        for (PurchaseRequest purchaseRequest : purchaseRequests) {
            purchaseRequest.setStatusSelect(3);
            this.purchaseRequestRepo.save((Model)((Object)purchaseRequest));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public List<PurchaseOrder> generatePo(List<PurchaseRequest> purchaseRequests, Boolean groupBySupplier, Boolean groupByProduct) throws AxelorException {
        ArrayList<PurchaseOrderLine> purchaseOrderLineList = new ArrayList<PurchaseOrderLine>();
        HashMap<String, PurchaseOrder> purchaseOrderMap = new HashMap<String, PurchaseOrder>();
        for (PurchaseRequest purchaseRequest : purchaseRequests) {
            PurchaseOrder purchaseOrder;
            String key;
            String string = key = groupBySupplier != false ? this.getPurchaseOrderGroupBySupplierKey(purchaseRequest) : null;
            if (key != null && purchaseOrderMap.containsKey(key)) {
                purchaseOrder = (PurchaseOrder)((Object)purchaseOrderMap.get(key));
            } else {
                purchaseOrder = this.createPurchaseOrder(purchaseRequest);
                key = key == null ? purchaseRequest.getId().toString() : key;
                purchaseOrderMap.put(key, purchaseOrder);
            }
            if (purchaseOrder == null) {
                purchaseOrder = this.createPurchaseOrder(purchaseRequest);
            }
            for (PurchaseRequestLine purchaseRequestLine : purchaseRequest.getPurchaseRequestLineList()) {
                PurchaseOrderLine purchaseOrderLine = new PurchaseOrderLine();
                Product product = purchaseRequestLine.getProduct();
                purchaseOrderLine = groupByProduct != false && purchaseOrder != null ? this.getPoLineByProduct(product, purchaseOrder) : null;
                purchaseOrderLine = this.purchaseOrderLineService.createPurchaseOrderLine(purchaseOrder, product, purchaseRequestLine.getNewProduct() != false ? purchaseRequestLine.getProductTitle() : product.getName(), purchaseRequestLine.getNewProduct() != false ? null : product.getDescription(), purchaseRequestLine.getQuantity(), purchaseRequestLine.getUnit());
                purchaseOrder.addPurchaseOrderLineListItem(purchaseOrderLine);
                purchaseOrderLineList.add(purchaseOrderLine);
                this.purchaseOrderLineService.compute(purchaseOrderLine, purchaseOrder);
            }
            purchaseOrder.getPurchaseOrderLineList().addAll(purchaseOrderLineList);
            this.purchaseOrderService.computePurchaseOrder(purchaseOrder);
            this.purchaseOrderRepo.save((Model)((Object)purchaseOrder));
        }
        List<PurchaseOrder> purchaseOrders = purchaseOrderMap.values().stream().collect(Collectors.toList());
        return purchaseOrders;
    }

    private PurchaseOrderLine getPoLineByProduct(Product product, PurchaseOrder purchaseOrder) {
        PurchaseOrderLine purchaseOrderLine = purchaseOrder.getPurchaseOrderLineList() != null && !purchaseOrder.getPurchaseOrderLineList().isEmpty() ? (PurchaseOrderLine)purchaseOrder.getPurchaseOrderLineList().stream().filter(poLine -> poLine.getProduct().equals((Object)product)).findFirst().orElse(null) : null;
        return purchaseOrderLine;
    }

    protected PurchaseOrder createPurchaseOrder(PurchaseRequest purchaseRequest) throws AxelorException {
        return (PurchaseOrder)((Object)this.purchaseOrderRepo.save((Model)((Object)this.purchaseOrderService.createPurchaseOrder(AuthUtils.getUser(), purchaseRequest.getCompany(), null, purchaseRequest.getSupplierUser().getCurrency(), null, null, null, LocalDate.now(), null, purchaseRequest.getSupplierUser(), null))));
    }

    protected String getPurchaseOrderGroupBySupplierKey(PurchaseRequest purchaseRequest) {
        return purchaseRequest.getSupplierUser().getId().toString();
    }
}

