/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.service.print;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.service.print.PurchaseOrderPrintService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class PurchaseOrderPrintServiceImpl
implements PurchaseOrderPrintService {
    @Override
    public String printPurchaseOrder(PurchaseOrder purchaseOrder, String formatPdf) throws AxelorException {
        String fileName = this.getPurchaseOrderFilesName(false, formatPdf);
        return PdfTool.getFileLinkFromPdfFile((File)this.print(purchaseOrder, formatPdf), (String)fileName);
    }

    @Override
    public String printPurchaseOrders(List<Long> ids) throws IOException {
        final ArrayList printedPurchaseOrders = new ArrayList();
        ModelTool.apply(PurchaseOrder.class, ids, (ThrowConsumer)new ThrowConsumer<PurchaseOrder>(){

            public void accept(PurchaseOrder purchaseOrder) throws Exception {
                printedPurchaseOrders.add(PurchaseOrderPrintServiceImpl.this.print(purchaseOrder, "pdf"));
            }
        });
        String fileName = this.getPurchaseOrderFilesName(true, "pdf");
        return PdfTool.mergePdfToFileLink(printedPurchaseOrders, (String)fileName);
    }

    public File print(PurchaseOrder purchaseOrder, String formatPdf) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(purchaseOrder, formatPdf);
        return reportSettings.generate().getFile();
    }

    public ReportSettings prepareReportSettings(PurchaseOrder purchaseOrder, String formatPdf) throws AxelorException {
        if (purchaseOrder.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on purchase order %s"), purchaseOrder.getPurchaseOrderSeq()), new Object[]{purchaseOrder});
        }
        String locale = ReportSettings.getPrintingLocale((Partner)purchaseOrder.getSupplierPartner());
        String title = this.getFileName(purchaseOrder);
        ReportSettings reportSetting = ReportFactory.createReport((String)"PurchaseOrder.rptdesign", (String)(title + " - ${date}"));
        return reportSetting.addParam("PurchaseOrderId", (Object)purchaseOrder.getId()).addParam("Locale", (Object)locale).addParam("HeaderHeight", (Object)purchaseOrder.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)purchaseOrder.getPrintingSettings().getPdfFooterHeight()).addFormat(formatPdf);
    }

    protected String getPurchaseOrderFilesName(boolean plural, String formatPdf) {
        return I18n.get((String)(plural ? "Purchase orders" : "Purchase order")) + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate().format(DateTimeFormatter.BASIC_ISO_DATE) + "." + formatPdf;
    }

    @Override
    public String getFileName(PurchaseOrder purchaseOrder) {
        return I18n.get((String)"Purchase order") + " " + purchaseOrder.getPurchaseOrderSeq() + (purchaseOrder.getVersionNumber() > 1 ? "-V" + purchaseOrder.getVersionNumber() : "");
    }
}

