/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.web;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderService;
import com.axelor.apps.purchase.service.print.PurchaseOrderPrintService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PurchaseOrderController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setSequence(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            if (purchaseOrder != null && purchaseOrder.getCompany() != null) {
                response.setValue("purchaseOrderSeq", (Object)((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).getSequence(purchaseOrder.getCompany()));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void compute(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        if (purchaseOrder != null) {
            try {
                purchaseOrder = ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).computePurchaseOrder(purchaseOrder);
                response.setValues((Object)purchaseOrder);
            }
            catch (Exception e) {
                TraceBackService.trace((ActionResponse)response, (Throwable)e);
            }
        }
    }

    public void validateSupplier(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        response.setValue("supplierPartner", (Object)((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).validateSupplier(purchaseOrder));
    }

    public void showPurchaseOrder(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        PurchaseOrderPrintService purchaseOrderPrintService = (PurchaseOrderPrintService)Beans.get(PurchaseOrderPrintService.class);
        try {
            String title;
            String fileLink;
            if (!ObjectUtils.isEmpty((Object)request.getContext().get((Object)"_ids"))) {
                List ids = Lists.transform((List)((List)request.getContext().get((Object)"_ids")), (Function)new Function<Object, Long>(){

                    @Nullable
                    public Long apply(@Nullable Object input) {
                        return Long.parseLong(input.toString());
                    }
                });
                fileLink = purchaseOrderPrintService.printPurchaseOrders(ids);
                title = I18n.get((String)"Purchase orders");
            } else if (context.get((Object)"id") != null) {
                PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
                title = purchaseOrderPrintService.getFileName(purchaseOrder);
                fileLink = purchaseOrderPrintService.printPurchaseOrder(purchaseOrder, "pdf");
                this.logger.debug("Printing " + title);
            } else {
                throw new AxelorException(1, I18n.get((String)"Please select the purchase order(s) to print."));
            }
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void requestPurchaseOrder(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        try {
            ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).requestPurchaseOrder((PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateCostPrice(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).updateCostPrice((PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId())));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void mergePurchaseOrder(ActionRequest request, ActionResponse response) {
        ArrayList<PurchaseOrder> purchaseOrderList = new ArrayList<PurchaseOrder>();
        ArrayList<Long> purchaseOrderIdList = new ArrayList<Long>();
        boolean fromPopup = false;
        if (request.getContext().get((Object)"purchaseOrderToMerge") != null) {
            if (request.getContext().get((Object)"purchaseOrderToMerge") instanceof List) {
                List purchaseOrderMap = (List)request.getContext().get((Object)"purchaseOrderToMerge");
                for (Map map : purchaseOrderMap) {
                    purchaseOrderIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                String purchaseOrderIdListStr = (String)request.getContext().get((Object)"purchaseOrderToMerge");
                for (String purchaseOrderId : purchaseOrderIdListStr.split(",")) {
                    purchaseOrderIdList.add(new Long(purchaseOrderId));
                }
                fromPopup = true;
            }
        }
        Currency commonCurrency = null;
        Partner commonSupplierPartner = null;
        Company commonCompany = null;
        Partner commonContactPartner = null;
        TradingName commonTradingName = null;
        boolean existContactPartnerDiff = false;
        PriceList commonPriceList = null;
        boolean existPriceListDiff = false;
        boolean allTradingNamesAreNull = true;
        int count = 1;
        for (Long purchaseOrderId : purchaseOrderIdList) {
            PurchaseOrder purchaseOrderTemp = (PurchaseOrder)((Object)JPA.em().find(PurchaseOrder.class, (Object)purchaseOrderId));
            purchaseOrderList.add(purchaseOrderTemp);
            if (count == 1) {
                commonCurrency = purchaseOrderTemp.getCurrency();
                commonSupplierPartner = purchaseOrderTemp.getSupplierPartner();
                commonCompany = purchaseOrderTemp.getCompany();
                commonContactPartner = purchaseOrderTemp.getContactPartner();
                commonPriceList = purchaseOrderTemp.getPriceList();
                commonTradingName = purchaseOrderTemp.getTradingName();
                allTradingNamesAreNull = commonTradingName == null;
            } else {
                if (commonCurrency != null && !commonCurrency.equals((Object)purchaseOrderTemp.getCurrency())) {
                    commonCurrency = null;
                }
                if (commonSupplierPartner != null && !commonSupplierPartner.equals((Object)purchaseOrderTemp.getSupplierPartner())) {
                    commonSupplierPartner = null;
                }
                if (commonCompany != null && !commonCompany.equals((Object)purchaseOrderTemp.getCompany())) {
                    commonCompany = null;
                }
                if (commonContactPartner != null && !commonContactPartner.equals((Object)purchaseOrderTemp.getContactPartner())) {
                    commonContactPartner = null;
                    existContactPartnerDiff = true;
                }
                if (commonPriceList != null && !commonPriceList.equals((Object)purchaseOrderTemp.getPriceList())) {
                    commonPriceList = null;
                    existPriceListDiff = true;
                }
                if (!Objects.equals(commonTradingName, purchaseOrderTemp.getTradingName())) {
                    commonTradingName = null;
                    allTradingNamesAreNull = false;
                }
            }
            ++count;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (commonCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all purchase orders"));
        }
        if (commonSupplierPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The supplier Partner is required and must be the same for all purchase orders"));
        }
        if (commonCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all purchase orders"));
        }
        if (commonTradingName == null && !allTradingNamesAreNull) {
            fieldErrors.append(I18n.get((String)"The trading name must be the same for all purchase orders"));
        }
        if (fieldErrors.length() > 0) {
            response.setFlash(fieldErrors.toString());
            return;
        }
        if (request.getContext().get((Object)"priceList") != null) {
            commonPriceList = (PriceList)JPA.em().find(PriceList.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"priceList")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            commonContactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        if (!fromPopup && (existContactPartnerDiff || existPriceListDiff)) {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Confirm merge purchase order").model(Wizard.class.getName()).add("form", "purchase-order-merge-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
            if (existPriceListDiff) {
                confirmView.context("contextPriceListToCheck", (Object)"true");
            }
            if (existContactPartnerDiff) {
                confirmView.context("contextContactPartnerToCheck", (Object)"true");
                confirmView.context("contextPartnerId", (Object)commonSupplierPartner.getId().toString());
            }
            confirmView.context("purchaseOrderToMerge", (Object)Joiner.on((String)",").join(purchaseOrderIdList));
            response.setView(confirmView.map());
            return;
        }
        try {
            PurchaseOrder purchaseOrder = ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).mergePurchaseOrders(purchaseOrderList, commonCurrency, commonSupplierPartner, commonCompany, commonContactPartner, commonPriceList, commonTradingName);
            if (purchaseOrder != null) {
                response.setView(ActionView.define((String)"Purchase order").model(PurchaseOrder.class.getName()).add("grid", "purchase-order-grid").add("form", "purchase-order-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(purchaseOrder.getId())).map());
                response.setCanClose(true);
            }
        }
        catch (Exception e) {
            response.setFlash(e.getLocalizedMessage());
        }
    }

    public void fillCompanyBankDetails(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            PaymentMode paymentMode = (PaymentMode)request.getContext().get((Object)"paymentMode");
            Company company = purchaseOrder.getCompany();
            Partner partner = purchaseOrder.getSupplierPartner();
            if (company == null) {
                return;
            }
            if (partner != null) {
                partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
            }
            BankDetails defaultBankDetails = ((BankDetailsService)Beans.get(BankDetailsService.class)).getDefaultCompanyBankDetails(company, paymentMode, partner, null);
            response.setValue("companyBankDetails", (Object)defaultBankDetails);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
            ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).validatePurchaseOrder(purchaseOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
            ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).cancelPurchaseOrder(purchaseOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void filterPrintingSettings(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            List printingSettingsList = ((TradingNameService)Beans.get(TradingNameService.class)).getPrintingSettingsList(purchaseOrder.getTradingName(), purchaseOrder.getCompany());
            String domain = String.format("self.id IN (%s)", !printingSettingsList.isEmpty() ? StringTool.getIdListString((Collection)printingSettingsList) : "0");
            response.setAttr("printingSettings", "domain", (Object)domain);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillDefaultPrintingSettings(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            response.setValue("printingSettings", (Object)((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(purchaseOrder.getTradingName(), purchaseOrder.getCompany()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillPriceList(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            response.setValue("priceList", (Object)((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(purchaseOrder.getSupplierPartner(), 2));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void changePriceListDomain(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            String domain = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getPriceListDomain(purchaseOrder.getSupplierPartner(), 2);
            response.setAttr("priceList", "domain", (Object)domain);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void finishPurchaseOrder(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
            ((PurchaseOrderService)Beans.get(PurchaseOrderService.class)).finishPurchaseOrder(purchaseOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void supplierPartnerDomain(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            Company company = purchaseOrder.getCompany();
            long companyId = company.getPartner() == null ? 0L : company.getPartner().getId();
            String domain = String.format("self.id != %d AND self.isContact = false AND self.isSupplier = true", companyId);
            String blockedPartnerQuery = ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(company, 6);
            if (!Strings.isNullOrEmpty((String)blockedPartnerQuery)) {
                domain = domain + String.format(" AND self.id NOT in (%s)", blockedPartnerQuery);
            }
            domain = domain + " AND :company member of self.companySet";
            response.setAttr("supplierPartner", "domain", (Object)domain);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

