/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.web;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;

@Singleton
public class PurchaseOrderLineController {
    public void compute(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
            PurchaseOrder purchaseOrder = this.getPurchaseOrder(context);
            Map<String, BigDecimal> map = ((PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class)).compute(purchaseOrderLine, purchaseOrder);
            response.setValues(map);
            response.setAttr("priceDiscounted", "hidden", (Object)(map.getOrDefault("priceDiscounted", BigDecimal.ZERO).compareTo(purchaseOrder.getInAti() != false ? purchaseOrderLine.getInTaxPrice() : purchaseOrderLine.getPrice()) == 0 ? 1 : 0));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getProductInformation(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrderLineService service = (PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class);
            Context context = request.getContext();
            PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
            PurchaseOrder purchaseOrder = this.getPurchaseOrder(context);
            Product product = purchaseOrderLine.getProduct();
            this.resetProductInformation(response);
            response.setValues((Object)service.reset(purchaseOrderLine));
            if (purchaseOrder == null || product == null) {
                return;
            }
            purchaseOrderLine.setPurchaseOrder(purchaseOrder);
            service.fill(purchaseOrderLine, purchaseOrder);
            response.setValues((Object)purchaseOrderLine);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void resetProductInformation(ActionResponse response) {
        response.setAttr("minQtyNotRespectedLabel", "hidden", (Object)true);
        response.setAttr("multipleQtyNotRespectedLabel", "hidden", (Object)true);
    }

    public void getTaxEquiv(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
        PurchaseOrder purchaseOrder = this.getPurchaseOrder(context);
        response.setValue("taxEquiv", null);
        if (purchaseOrder == null || purchaseOrderLine == null || purchaseOrder.getSupplierPartner() == null || purchaseOrderLine.getTaxLine() == null) {
            return;
        }
        response.setValue("taxEquiv", (Object)((FiscalPositionService)Beans.get(FiscalPositionService.class)).getTaxEquiv(purchaseOrder.getSupplierPartner().getFiscalPosition(), purchaseOrderLine.getTaxLine().getTax()));
    }

    public void updateProductInformation(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
        PurchaseOrder purchaseOrder = this.getPurchaseOrder(context);
        if (purchaseOrder == null || purchaseOrderLine.getProduct() == null) {
            return;
        }
        try {
            Map<String, Object> discounts;
            PurchaseOrderLineService purchaseOrderLineService = (PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class);
            BigDecimal price = purchaseOrderLine.getProduct().getInAti() != false ? purchaseOrderLineService.getInTaxUnitPrice(purchaseOrder, purchaseOrderLine, purchaseOrderLine.getTaxLine()) : purchaseOrderLineService.getExTaxUnitPrice(purchaseOrder, purchaseOrderLine, purchaseOrderLine.getTaxLine());
            Map<String, Object> catalogInfo = purchaseOrderLineService.updateInfoFromCatalog(purchaseOrder, purchaseOrderLine);
            Product product = purchaseOrderLine.getProduct();
            String productName = null;
            String productCode = null;
            if (catalogInfo != null) {
                if (catalogInfo.get("price") != null) {
                    price = (BigDecimal)catalogInfo.get("price");
                }
                productName = catalogInfo.get("productName") != null ? (String)catalogInfo.get("productName") : product.getName();
                productCode = catalogInfo.get("productCode") != null ? (String)catalogInfo.get("productCode") : product.getCode();
            } else {
                price = product.getPurchasePrice();
                productName = product.getName();
                productCode = product.getCode();
            }
            if (purchaseOrderLine.getProductName() == null) {
                response.setValue("productName", (Object)productName);
            }
            if (purchaseOrderLine.getProductCode() == null) {
                response.setValue("productCode", (Object)productCode);
            }
            if ((discounts = purchaseOrderLineService.getDiscountsFromPriceLists(purchaseOrder, purchaseOrderLine, price)) != null) {
                if (discounts.get("price") != null) {
                    price = (BigDecimal)discounts.get("price");
                }
                if (purchaseOrderLine.getProduct().getInAti() != purchaseOrder.getInAti() && (Integer)discounts.get("discountTypeSelect") != 1) {
                    response.setValue("discountAmount", (Object)purchaseOrderLineService.convertUnitPrice(purchaseOrderLine.getProduct().getInAti(), purchaseOrderLine.getTaxLine(), (BigDecimal)discounts.get("discountAmount")));
                } else {
                    response.setValue("discountAmount", discounts.get("discountAmount"));
                }
                response.setValue("discountTypeSelect", discounts.get("discountTypeSelect"));
            }
            if (price.compareTo(purchaseOrderLine.getProduct().getInAti() != false ? purchaseOrderLine.getInTaxPrice() : purchaseOrderLine.getPrice()) != 0) {
                if (purchaseOrderLine.getProduct().getInAti().booleanValue()) {
                    response.setValue("inTaxPrice", (Object)price);
                    response.setValue("price", (Object)purchaseOrderLineService.convertUnitPrice(true, purchaseOrderLine.getTaxLine(), price));
                } else {
                    response.setValue("price", (Object)price);
                    response.setValue("inTaxPrice", (Object)purchaseOrderLineService.convertUnitPrice(false, purchaseOrderLine.getTaxLine(), price));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updatePrice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
        try {
            BigDecimal inTaxPrice = purchaseOrderLine.getInTaxPrice();
            TaxLine taxLine = purchaseOrderLine.getTaxLine();
            response.setValue("price", (Object)((PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class)).convertUnitPrice(true, taxLine, inTaxPrice));
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }

    public void updateInTaxPrice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
        try {
            BigDecimal exTaxPrice = purchaseOrderLine.getPrice();
            TaxLine taxLine = purchaseOrderLine.getTaxLine();
            response.setValue("inTaxPrice", (Object)((PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class)).convertUnitPrice(false, taxLine, exTaxPrice));
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }

    public void convertUnitPrice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
        PurchaseOrder purchaseOrder = this.getPurchaseOrder(context);
        if (purchaseOrder == null || purchaseOrderLine.getProduct() == null || purchaseOrderLine.getPrice() == null || purchaseOrderLine.getInTaxPrice() == null || purchaseOrderLine.getTaxLine() == null) {
            return;
        }
        try {
            BigDecimal price = purchaseOrderLine.getPrice();
            BigDecimal inTaxPrice = price.add(price.multiply(purchaseOrderLine.getTaxLine().getValue()));
            response.setValue("inTaxPrice", (Object)inTaxPrice);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public PurchaseOrder getPurchaseOrder(Context context) {
        Context parentContext = context.getParent();
        PurchaseOrder purchaseOrder = null;
        if (parentContext != null && parentContext.getContextClass() == PurchaseOrder.class) {
            purchaseOrder = (PurchaseOrder)((Object)parentContext.asType(PurchaseOrder.class));
            if (!parentContext.getContextClass().toString().equals(PurchaseOrder.class.toString())) {
                PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
                purchaseOrder = purchaseOrderLine.getPurchaseOrder();
            }
        } else {
            PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
            purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        }
        return purchaseOrder;
    }

    public void emptyLine(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)request.getContext().asType(PurchaseOrderLine.class));
            if (purchaseOrderLine.getIsTitleLine().booleanValue()) {
                PurchaseOrderLine newPurchaseOrderLine = new PurchaseOrderLine();
                newPurchaseOrderLine.setIsTitleLine(true);
                newPurchaseOrderLine.setQty(BigDecimal.ZERO);
                newPurchaseOrderLine.setId(purchaseOrderLine.getId());
                newPurchaseOrderLine.setVersion(purchaseOrderLine.getVersion());
                response.setValues((Object)Mapper.toMap((Object)((Object)purchaseOrderLine)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkQty(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)context.asType(PurchaseOrderLine.class));
            PurchaseOrder purchaseOrder = this.getPurchaseOrder(context);
            PurchaseOrderLineService service = (PurchaseOrderLineService)Beans.get(PurchaseOrderLineService.class);
            service.checkMinQty(purchaseOrder, purchaseOrderLine, request, response);
            service.checkMultipleQty(purchaseOrderLine, response);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void supplierPartnerDomain(ActionRequest request, ActionResponse response) {
        PurchaseOrderLine purchaseOrderLine = (PurchaseOrderLine)((Object)request.getContext().asType(PurchaseOrderLine.class));
        PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        if (purchaseOrder == null) {
            purchaseOrder = (PurchaseOrder)((Object)request.getContext().getParent().asType(PurchaseOrder.class));
        }
        Company company = purchaseOrder.getCompany();
        String domain = "";
        if (((AppPurchaseService)Beans.get(AppPurchaseService.class)).getAppPurchase().getManageSupplierCatalog().booleanValue() && purchaseOrderLine.getProduct() != null && !purchaseOrderLine.getProduct().getSupplierCatalogList().isEmpty()) {
            domain = domain + "self.id != " + company.getPartner().getId() + " AND self.id IN " + purchaseOrderLine.getProduct().getSupplierCatalogList().stream().map(s -> s.getSupplierPartner().getId()).collect(Collectors.toList()).toString().replace('[', '(').replace(']', ')');
            String blockedPartnerQuery = ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(company, 6);
            if (!Strings.isNullOrEmpty((String)blockedPartnerQuery)) {
                domain = domain + String.format(" AND self.id NOT in (%s)", blockedPartnerQuery);
            }
        } else {
            domain = domain + "self.id = 0";
        }
        domain = domain + " AND " + company.getId() + " in (SELECT id FROM self.companySet)";
        response.setAttr("supplierPartner", "domain", (Object)domain);
    }
}

