/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.web;

import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseRequest;
import com.axelor.apps.purchase.db.repo.PurchaseRequestRepository;
import com.axelor.apps.purchase.service.PurchaseRequestService;
import com.axelor.apps.tool.StringTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class PurchaseRequestController {
    public void confirmCart(ActionRequest request, ActionResponse response) {
        ((PurchaseRequestService)Beans.get(PurchaseRequestService.class)).confirmCart();
        response.setReload(true);
    }

    public void acceptRequest(ActionRequest request, ActionResponse response) {
        if (request.getContext().get((Object)"_ids") == null) {
            return;
        }
        List requestIds = (List)request.getContext().get((Object)"_ids");
        if (!requestIds.isEmpty()) {
            List purchaseRequests = ((PurchaseRequestRepository)((Object)Beans.get(PurchaseRequestRepository.class))).all().filter("self.id in (?1)", new Object[]{requestIds}).fetch();
            ((PurchaseRequestService)Beans.get(PurchaseRequestService.class)).acceptRequest(purchaseRequests);
            response.setReload(true);
        }
    }

    public void generatePo(ActionRequest request, ActionResponse response) {
        List requestIds = (List)request.getContext().get((Object)"_ids");
        Boolean groupBySupplier = (Boolean)request.getContext().get((Object)"groupBySupplier");
        groupBySupplier = groupBySupplier == null ? false : groupBySupplier;
        Boolean groupByProduct = (Boolean)request.getContext().get((Object)"groupByProduct");
        groupByProduct = groupByProduct == null ? false : groupByProduct;
        if (requestIds != null && !requestIds.isEmpty()) {
            try {
                List purchaseRequests = ((PurchaseRequestRepository)((Object)Beans.get(PurchaseRequestRepository.class))).all().filter("self.id in (?1)", new Object[]{requestIds}).fetch();
                List purchaseRequestSeqs = purchaseRequests.stream().filter(pr -> pr.getSupplierUser() == null).map(PurchaseRequest::getPurchaseRequestSeq).collect(Collectors.toList());
                if (purchaseRequestSeqs != null && !purchaseRequestSeqs.isEmpty()) {
                    throw new AxelorException(4, I18n.get((String)"Please enter supplier for following purchase request : %s"), new Object[]{purchaseRequestSeqs.toString()});
                }
                response.setCanClose(true);
                List<PurchaseOrder> purchaseOrderList = ((PurchaseRequestService)Beans.get(PurchaseRequestService.class)).generatePo(purchaseRequests, groupBySupplier, groupByProduct);
                ActionView.ActionViewBuilder actionViewBuilder = ActionView.define((String)String.format("Purchase Order%s generated", purchaseOrderList.size() > 1 ? "s" : "")).model(PurchaseOrder.class.getName()).add("grid", "purchase-order-quotation-grid").add("form", "purchase-order-form").context("_showSingle", (Object)true).domain(String.format("self.id in (%s)", StringTool.getIdListString(purchaseOrderList)));
                response.setView(actionViewBuilder.map());
            }
            catch (AxelorException e) {
                response.setFlash(e.getMessage());
            }
        }
    }
}

