/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.db.AlarmEngine;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ALARM", indexes={@Index(columnList="alarm_engine"), @Index(columnList="partner"), @Index(columnList="invoice")})
public class Alarm
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ALARM_SEQ")
    @SequenceGenerator(name="BASE_ALARM_SEQ", sequenceName="BASE_ALARM_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Date")
    @NotNull
    @Column(name="date_val")
    private ZonedDateTime date;
    @Widget(title="Alarm engine")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AlarmEngine alarmEngine;
    @Widget(title="Suspend Alarm")
    private Boolean acquitOk = Boolean.FALSE;
    @Widget(title="Message")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String content;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Invoice")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Due balance debt recovery")
    private BigDecimal balanceDueDebtRecovery = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public void setDate(ZonedDateTime date) {
        this.date = date;
    }

    public AlarmEngine getAlarmEngine() {
        return this.alarmEngine;
    }

    public void setAlarmEngine(AlarmEngine alarmEngine) {
        this.alarmEngine = alarmEngine;
    }

    public Boolean getAcquitOk() {
        return this.acquitOk == null ? Boolean.FALSE : this.acquitOk;
    }

    public void setAcquitOk(Boolean acquitOk) {
        this.acquitOk = acquitOk;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public BigDecimal getBalanceDueDebtRecovery() {
        return this.balanceDueDebtRecovery == null ? BigDecimal.ZERO : this.balanceDueDebtRecovery;
    }

    public void setBalanceDueDebtRecovery(BigDecimal balanceDueDebtRecovery) {
        this.balanceDueDebtRecovery = balanceDueDebtRecovery;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("date", (Object)this.getDate()).add("acquitOk", (Object)this.getAcquitOk()).add("balanceDueDebtRecovery", (Object)this.getBalanceDueDebtRecovery()).omitNullValues().toString();
    }
}

