/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.quality.db.ControlPointType;
import com.axelor.apps.quality.db.QualityControl;
import com.axelor.apps.quality.db.QualityMeasuringPoint;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="QUALITY_CONTROL_POINT", indexes={@Index(columnList="quality_control"), @Index(columnList="optional_quality_control"), @Index(columnList="name"), @Index(columnList="responsible"), @Index(columnList="control_point_type")})
public class ControlPoint
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_CONTROL_POINT_SEQ")
    @SequenceGenerator(name="QUALITY_CONTROL_POINT_SEQ", sequenceName="QUALITY_CONTROL_POINT_SEQ", allocationSize=1)
    private Long id;
    @Widget(selection="quality.control.points.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Quality control")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private QualityControl qualityControl;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private QualityControl optionalQualityControl;
    @Widget(title="Control point name")
    @NotNull
    private String name;
    @Widget(title="quality.responsible")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee responsible;
    @Widget(title="Control Frequency")
    private BigDecimal controlFrequency = BigDecimal.ZERO;
    @Widget(title="Notes")
    private String notes;
    @Widget(title="Date")
    private LocalDate controlPointDate;
    @Widget(title="Measuring point list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="controlPoint", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<QualityMeasuringPoint> measuringPointList;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Type")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ControlPointType controlPointType;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ControlPoint() {
    }

    public ControlPoint(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public QualityControl getQualityControl() {
        return this.qualityControl;
    }

    public void setQualityControl(QualityControl qualityControl) {
        this.qualityControl = qualityControl;
    }

    public QualityControl getOptionalQualityControl() {
        return this.optionalQualityControl;
    }

    public void setOptionalQualityControl(QualityControl optionalQualityControl) {
        this.optionalQualityControl = optionalQualityControl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Employee getResponsible() {
        return this.responsible;
    }

    public void setResponsible(Employee responsible) {
        this.responsible = responsible;
    }

    public BigDecimal getControlFrequency() {
        return this.controlFrequency == null ? BigDecimal.ZERO : this.controlFrequency;
    }

    public void setControlFrequency(BigDecimal controlFrequency) {
        this.controlFrequency = controlFrequency;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public LocalDate getControlPointDate() {
        return this.controlPointDate;
    }

    public void setControlPointDate(LocalDate controlPointDate) {
        this.controlPointDate = controlPointDate;
    }

    public List<QualityMeasuringPoint> getMeasuringPointList() {
        return this.measuringPointList;
    }

    public void setMeasuringPointList(List<QualityMeasuringPoint> measuringPointList) {
        this.measuringPointList = measuringPointList;
    }

    public void addMeasuringPointListItem(QualityMeasuringPoint item) {
        if (this.getMeasuringPointList() == null) {
            this.setMeasuringPointList(new ArrayList<QualityMeasuringPoint>());
        }
        this.getMeasuringPointList().add(item);
        item.setControlPoint(this);
    }

    public void removeMeasuringPointListItem(QualityMeasuringPoint item) {
        if (this.getMeasuringPointList() == null) {
            return;
        }
        this.getMeasuringPointList().remove((Object)item);
    }

    public void clearMeasuringPointList() {
        if (this.getMeasuringPointList() != null) {
            this.getMeasuringPointList().clear();
        }
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public ControlPointType getControlPointType() {
        return this.controlPointType;
    }

    public void setControlPointType(ControlPointType controlPointType) {
        this.controlPointType = controlPointType;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ControlPoint)) {
            return false;
        }
        ControlPoint other = (ControlPoint)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("name", (Object)this.getName()).add("controlFrequency", (Object)this.getControlFrequency()).add("notes", (Object)this.getNotes()).add("controlPointDate", (Object)this.getControlPointDate()).add("sequence", (Object)this.getSequence()).omitNullValues().toString();
    }
}

