/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.quality.db.QualityTag;
import com.axelor.apps.quality.db.RootCause;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="QUALITY_QUALITY_ALERT", indexes={@Index(columnList="product"), @Index(columnList="work_center"), @Index(columnList="team"), @Index(columnList="responsible"), @Index(columnList="root_cause"), @Index(columnList="fullName")})
public class QualityAlert
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_QUALITY_ALERT_SEQ")
    @SequenceGenerator(name="QUALITY_QUALITY_ALERT_SEQ", sequenceName="QUALITY_QUALITY_ALERT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Work center")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WorkCenter workCenter;
    @Widget(title="Team")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="quality.responsible")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee responsible;
    @Widget(title="Tags")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<QualityTag> qualityTagSet;
    @Widget(title="Root cause")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private RootCause rootCause;
    @Widget(readonly=true)
    private String reference;
    @Widget(title="Full name")
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Priority", selection="quality.alert.priority.select")
    private Integer prioritySelect = 0;
    @Widget(title="Status", readonly=true, selection="quality.alert.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Start date")
    private LocalDate startDate;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Deadline")
    private LocalDate deadLineDate;
    @Widget(title="Description")
    private String description;
    @Widget(title="Corrective actions")
    private String correctiveActions;
    @Widget(title="Preventive actions")
    private String preventiveActions;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public WorkCenter getWorkCenter() {
        return this.workCenter;
    }

    public void setWorkCenter(WorkCenter workCenter) {
        this.workCenter = workCenter;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Employee getResponsible() {
        return this.responsible;
    }

    public void setResponsible(Employee responsible) {
        this.responsible = responsible;
    }

    public Set<QualityTag> getQualityTagSet() {
        return this.qualityTagSet;
    }

    public void setQualityTagSet(Set<QualityTag> qualityTagSet) {
        this.qualityTagSet = qualityTagSet;
    }

    public void addQualityTagSetItem(QualityTag item) {
        if (this.getQualityTagSet() == null) {
            this.setQualityTagSet(new HashSet<QualityTag>());
        }
        this.getQualityTagSet().add(item);
    }

    public void removeQualityTagSetItem(QualityTag item) {
        if (this.getQualityTagSet() == null) {
            return;
        }
        this.getQualityTagSet().remove((Object)item);
    }

    public void clearQualityTagSet() {
        if (this.getQualityTagSet() != null) {
            this.getQualityTagSet().clear();
        }
    }

    public RootCause getRootCause() {
        return this.rootCause;
    }

    public void setRootCause(RootCause rootCause) {
        this.rootCause = rootCause;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.reference != null && this.reference != "") {
            fullName = this.product.getCode() != null ? fullName + this.reference + "[" + this.product.getCode() + "]" : fullName + this.reference;
        } else if (this.product.getCode() != null) {
            fullName = fullName + "[" + this.product.getCode() + "]";
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getPrioritySelect() {
        return this.prioritySelect == null ? 0 : this.prioritySelect;
    }

    public void setPrioritySelect(Integer prioritySelect) {
        this.prioritySelect = prioritySelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalDate getDeadLineDate() {
        return this.deadLineDate;
    }

    public void setDeadLineDate(LocalDate deadLineDate) {
        this.deadLineDate = deadLineDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCorrectiveActions() {
        return this.correctiveActions;
    }

    public void setCorrectiveActions(String correctiveActions) {
        this.correctiveActions = correctiveActions;
    }

    public String getPreventiveActions() {
        return this.preventiveActions;
    }

    public void setPreventiveActions(String preventiveActions) {
        this.preventiveActions = preventiveActions;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QualityAlert)) {
            return false;
        }
        QualityAlert other = (QualityAlert)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("reference", (Object)this.getReference()).add("prioritySelect", (Object)this.getPrioritySelect()).add("statusSelect", (Object)this.getStatusSelect()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).add("deadLineDate", (Object)this.getDeadLineDate()).add("description", (Object)this.getDescription()).add("correctiveActions", (Object)this.getCorrectiveActions()).add("preventiveActions", (Object)this.getPreventiveActions()).omitNullValues().toString();
    }
}

