/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.base.db.PrintingSettings;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.quality.db.ControlPoint;
import com.axelor.apps.quality.db.QualityCorrectiveAction;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="QUALITY_QUALITY_CONTROL", indexes={@Index(columnList="team"), @Index(columnList="responsible"), @Index(columnList="reference"), @Index(columnList="project"), @Index(columnList="inspector_signature"), @Index(columnList="customer_signature"), @Index(columnList="name"), @Index(columnList="printing_settings")})
public class QualityControl
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_QUALITY_CONTROL_SEQ")
    @SequenceGenerator(name="QUALITY_QUALITY_CONTROL_SEQ", sequenceName="QUALITY_QUALITY_CONTROL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="quality.responsible")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee responsible;
    @Widget(readonly=true)
    @NameColumn
    private String reference;
    @Widget(title="Status", readonly=true, selection="quality.control.status.select")
    private Integer statusSelect = 0;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="qualityControl", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ControlPoint> controlPointList;
    @Widget(title="Start date")
    private LocalDate startDate;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Deadline")
    private LocalDate deadLineDate;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Optional control point list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="optionalQualityControl", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ControlPoint> optionalControlPointList;
    @Widget(title="Corrective actions list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="qualityControl", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<QualityCorrectiveAction> qualityCorrectiveActionList;
    @Widget(title="Inspector signature")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile inspectorSignature;
    @Widget(title="Customer signature")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile customerSignature;
    @Widget(title="Name")
    private String name;
    @Widget(title="Printing settings")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PrintingSettings printingSettings;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public QualityControl() {
    }

    public QualityControl(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Employee getResponsible() {
        return this.responsible;
    }

    public void setResponsible(Employee responsible) {
        this.responsible = responsible;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public List<ControlPoint> getControlPointList() {
        return this.controlPointList;
    }

    public void setControlPointList(List<ControlPoint> controlPointList) {
        this.controlPointList = controlPointList;
    }

    public void addControlPointListItem(ControlPoint item) {
        if (this.getControlPointList() == null) {
            this.setControlPointList(new ArrayList<ControlPoint>());
        }
        this.getControlPointList().add(item);
        item.setQualityControl(this);
    }

    public void removeControlPointListItem(ControlPoint item) {
        if (this.getControlPointList() == null) {
            return;
        }
        this.getControlPointList().remove((Object)item);
    }

    public void clearControlPointList() {
        if (this.getControlPointList() != null) {
            this.getControlPointList().clear();
        }
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalDate getDeadLineDate() {
        return this.deadLineDate;
    }

    public void setDeadLineDate(LocalDate deadLineDate) {
        this.deadLineDate = deadLineDate;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public List<ControlPoint> getOptionalControlPointList() {
        return this.optionalControlPointList;
    }

    public void setOptionalControlPointList(List<ControlPoint> optionalControlPointList) {
        this.optionalControlPointList = optionalControlPointList;
    }

    public void addOptionalControlPointListItem(ControlPoint item) {
        if (this.getOptionalControlPointList() == null) {
            this.setOptionalControlPointList(new ArrayList<ControlPoint>());
        }
        this.getOptionalControlPointList().add(item);
        item.setOptionalQualityControl(this);
    }

    public void removeOptionalControlPointListItem(ControlPoint item) {
        if (this.getOptionalControlPointList() == null) {
            return;
        }
        this.getOptionalControlPointList().remove((Object)item);
    }

    public void clearOptionalControlPointList() {
        if (this.getOptionalControlPointList() != null) {
            this.getOptionalControlPointList().clear();
        }
    }

    public List<QualityCorrectiveAction> getQualityCorrectiveActionList() {
        return this.qualityCorrectiveActionList;
    }

    public void setQualityCorrectiveActionList(List<QualityCorrectiveAction> qualityCorrectiveActionList) {
        this.qualityCorrectiveActionList = qualityCorrectiveActionList;
    }

    public void addQualityCorrectiveActionListItem(QualityCorrectiveAction item) {
        if (this.getQualityCorrectiveActionList() == null) {
            this.setQualityCorrectiveActionList(new ArrayList<QualityCorrectiveAction>());
        }
        this.getQualityCorrectiveActionList().add(item);
        item.setQualityControl(this);
    }

    public void removeQualityCorrectiveActionListItem(QualityCorrectiveAction item) {
        if (this.getQualityCorrectiveActionList() == null) {
            return;
        }
        this.getQualityCorrectiveActionList().remove((Object)item);
    }

    public void clearQualityCorrectiveActionList() {
        if (this.getQualityCorrectiveActionList() != null) {
            this.getQualityCorrectiveActionList().clear();
        }
    }

    public MetaFile getInspectorSignature() {
        return this.inspectorSignature;
    }

    public void setInspectorSignature(MetaFile inspectorSignature) {
        this.inspectorSignature = inspectorSignature;
    }

    public MetaFile getCustomerSignature() {
        return this.customerSignature;
    }

    public void setCustomerSignature(MetaFile customerSignature) {
        this.customerSignature = customerSignature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PrintingSettings getPrintingSettings() {
        return this.printingSettings;
    }

    public void setPrintingSettings(PrintingSettings printingSettings) {
        this.printingSettings = printingSettings;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QualityControl)) {
            return false;
        }
        QualityControl other = (QualityControl)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("reference", (Object)this.getReference()).add("statusSelect", (Object)this.getStatusSelect()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).add("deadLineDate", (Object)this.getDeadLineDate()).add("sequence", (Object)this.getSequence()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

